/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  128
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Decod_queue * _Decod_queue = new Decod_queue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_DECOD_IN_VAL            ," in_DECOD_IN_VAL           ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IN_ACK            ,"out_DECOD_IN_ACK           ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_CONTEXT_ID     ," in_DECOD_IN_CONTEXT_ID    ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_DEPTH          ," in_DECOD_IN_DEPTH         ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_TYPE           ," in_DECOD_IN_TYPE          ",Ttype_t            ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_OPERATION      ," in_DECOD_IN_OPERATION     ",Toperation_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_NO_EXECUTE     ," in_DECOD_IN_NO_EXECUTE    ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_IS_DELAY_SLOT  ," in_DECOD_IN_IS_DELAY_SLOT ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_ADDRESS        ," in_DECOD_IN_ADDRESS       ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_HAS_IMMEDIAT   ," in_DECOD_IN_HAS_IMMEDIAT  ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_IMMEDIAT       ," in_DECOD_IN_IMMEDIAT      ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_READ_RA        ," in_DECOD_IN_READ_RA       ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RA     ," in_DECOD_IN_NUM_REG_RA    ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_READ_RB        ," in_DECOD_IN_READ_RB       ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RB     ," in_DECOD_IN_NUM_REG_RB    ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_READ_RC        ," in_DECOD_IN_READ_RC       ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RC     ," in_DECOD_IN_NUM_REG_RC    ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_WRITE_RD       ," in_DECOD_IN_WRITE_RD      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RD     ," in_DECOD_IN_NUM_REG_RD    ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_WRITE_RE       ," in_DECOD_IN_WRITE_RE      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RE     ," in_DECOD_IN_NUM_REG_RE    ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_EXCEPTION_USE  ," in_DECOD_IN_EXCEPTION_USE ",Texception_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IN_EXCEPTION      ," in_DECOD_IN_EXCEPTION     ",Texception_t       ,_param->_nb_inst_decod);
									                          
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_VAL           ,"out_DECOD_OUT_VAL          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_OUT_ACK           ," in_DECOD_OUT_ACK          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_CONTEXT_ID    ,"out_DECOD_OUT_CONTEXT_ID   ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_DEPTH         ,"out_DECOD_OUT_DEPTH        ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_TYPE          ,"out_DECOD_OUT_TYPE         ",Ttype_t            ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_OPERATION     ,"out_DECOD_OUT_OPERATION    ",Toperation_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_NO_EXECUTE    ,"out_DECOD_OUT_NO_EXECUTE   ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_IS_DELAY_SLOT ,"out_DECOD_OUT_IS_DELAY_SLOT",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_ADDRESS       ,"out_DECOD_OUT_ADDRESS      ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_HAS_IMMEDIAT  ,"out_DECOD_OUT_HAS_IMMEDIAT ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_IMMEDIAT      ,"out_DECOD_OUT_IMMEDIAT     ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_READ_RA       ,"out_DECOD_OUT_READ_RA      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RA    ,"out_DECOD_OUT_NUM_REG_RA   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_READ_RB       ,"out_DECOD_OUT_READ_RB      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RB    ,"out_DECOD_OUT_NUM_REG_RB   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_READ_RC       ,"out_DECOD_OUT_READ_RC      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RC    ,"out_DECOD_OUT_NUM_REG_RC   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_WRITE_RD      ,"out_DECOD_OUT_WRITE_RD     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RD    ,"out_DECOD_OUT_NUM_REG_RD   ",Tgeneral_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_WRITE_RE      ,"out_DECOD_OUT_WRITE_RE     ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RE    ,"out_DECOD_OUT_NUM_REG_RE   ",Tspecial_address_t ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_EXCEPTION_USE ,"out_DECOD_OUT_EXCEPTION_USE",Texception_t       ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OUT_EXCEPTION     ,"out_DECOD_OUT_EXCEPTION    ",Texception_t       ,_param->_nb_inst_decod);
									                          
  ALLOC1_SC_SIGNAL( in_DEPTH_MIN               ," in_DEPTH_MIN              ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_DEPTH_MAX               ," in_DEPTH_MAX              ",Tdepth_t           ,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_NB_INST_ALL             ,"out_NB_INST_ALL            ",Tcounter_t         ,_param->_nb_context);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Decod_queue.\n"),name.c_str());

  (*(_Decod_queue->in_CLOCK))        (*(in_CLOCK));
  (*(_Decod_queue->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_VAL            ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_IN_ACK            ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_CONTEXT_ID     ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_DEPTH          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_TYPE           ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_OPERATION      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_NO_EXECUTE     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_IS_DELAY_SLOT  ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_ADDRESS        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_HAS_IMMEDIAT   ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_IMMEDIAT       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_READ_RA        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_NUM_REG_RA     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_READ_RB        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_NUM_REG_RB     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_READ_RC        ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_NUM_REG_RC     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_WRITE_RD       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_NUM_REG_RD     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_WRITE_RE       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_NUM_REG_RE     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_EXCEPTION_USE  ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_IN_EXCEPTION      ,_param->_nb_inst_decod);

  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_VAL           ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DECOD_OUT_ACK           ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_CONTEXT_ID    ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_DEPTH         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_TYPE          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_OPERATION     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_NO_EXECUTE    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_IS_DELAY_SLOT ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_ADDRESS       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_HAS_IMMEDIAT  ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_IMMEDIAT      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_READ_RA       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_NUM_REG_RA    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_READ_RB       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_NUM_REG_RB    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_READ_RC       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_NUM_REG_RC    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_WRITE_RD      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_NUM_REG_RD    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_WRITE_RE      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_NUM_REG_RE    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_EXCEPTION_USE ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_DECOD_OUT_EXCEPTION     ,_param->_nb_inst_decod);

  for (uint32_t i=0; i<_param->_nb_context; ++i)
    if (_param->_have_port_depth)
      INSTANCE_SC_SIGNAL(_Decod_queue, in_DEPTH_MIN  [i]);
  INSTANCE1_SC_SIGNAL(_Decod_queue, in_DEPTH_MAX               ,_param->_nb_context);
  
  INSTANCE1_SC_SIGNAL(_Decod_queue,out_NB_INST_ALL             ,_param->_nb_context);
  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  Tcounter_t nb_inst      [_param->_nb_context];
  Tdepth_t   depth        [_param->_nb_context];
  Taddress_t address_src  [_param->_nb_context];
  Taddress_t address_dest [_param->_nb_context];

  for (uint32_t i=0; i<_param->_nb_context; i++)
    {
      nb_inst      [i] = 0;
      depth        [i] = 0;
      address_src  [i] = 0;
      address_dest [i] = 0;
    }

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      {
	Taddress_t address_tmp [_param->_nb_context];
	
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  address_tmp [i] = address_src [i];

	uint32_t x = rand()%_param->_nb_inst_decod;
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    Tcontext_t context = rand()%_param->_nb_context;

	    in_DECOD_IN_VAL        [i]->write(i<=x);
	    in_DECOD_IN_CONTEXT_ID [i]->write(context);
	    in_DECOD_IN_DEPTH      [i]->write(depth [context]);
	    in_DECOD_IN_ADDRESS    [i]->write(address_tmp [context]);

	    address_tmp [context] ++;
	  }
      }

      {
	uint32_t x = rand()%_param->_nb_inst_decod;
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    in_DECOD_OUT_ACK       [i]->write(i<=x);
	  }
      }
      
      SC_START(0);

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  LABEL("DECOD_IN  [%d] - %d %d",i,in_DECOD_IN_VAL [i]->read(),out_DECOD_IN_ACK [i]->read());

	  if (in_DECOD_IN_VAL [i]->read() and out_DECOD_IN_ACK [i]->read())
	    {
	      LABEL("DECOD_IN  [%d] - Transaction Accepted",i);
	      Tcontext_t context = in_DECOD_IN_CONTEXT_ID [i]->read();
	      LABEL("  * context  : %d",context);
	      
	      nb_inst      [context] ++;
	      address_src  [context] ++;
	    }
	}

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  LABEL("DECOD_OUT [%d] - %d %d",i,out_DECOD_OUT_VAL [i]->read(),in_DECOD_OUT_ACK [i]->read());
	  if (out_DECOD_OUT_VAL [i]->read() and in_DECOD_OUT_ACK [i]->read())
	    {
	      LABEL("DECOD_OUT [%d] - Transaction Accepted",i);
	      Tcontext_t context = out_DECOD_OUT_CONTEXT_ID [i]->read();
	      LABEL("  * context  : %d",context);
	      
	      TEST(Tdepth_t  ,out_DECOD_OUT_DEPTH   [i]->read(),depth        [context]);
	      TEST(Taddress_t,out_DECOD_OUT_ADDRESS [i]->read(),address_dest [context]);
	      
	      nb_inst      [context] --;
	      address_dest [context] ++;
	    }
	}

      SC_START(1);

      for (uint32_t i=0; i<_param->_nb_context; i++)
	TEST(Tcounter_t,out_NB_INST_ALL[i]->read(), nb_inst[i]);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_DECOD_IN_VAL            ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IN_ACK            ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_CONTEXT_ID     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_DEPTH          ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_TYPE           ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_OPERATION      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_NO_EXECUTE     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_IS_DELAY_SLOT  ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_ADDRESS        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_HAS_IMMEDIAT   ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_IMMEDIAT       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_READ_RA        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RA     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_READ_RB        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RB     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_READ_RC        ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RC     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_WRITE_RD       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RD     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_WRITE_RE       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_NUM_REG_RE     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_EXCEPTION_USE  ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_IN_EXCEPTION      ,_param->_nb_inst_decod);

  DELETE1_SC_SIGNAL(out_DECOD_OUT_VAL           ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_OUT_ACK           ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_CONTEXT_ID    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_DEPTH         ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_TYPE          ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_OPERATION     ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_NO_EXECUTE    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_IS_DELAY_SLOT ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_ADDRESS       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_HAS_IMMEDIAT  ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_IMMEDIAT      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_READ_RA       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RA    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_READ_RB       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RB    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_READ_RC       ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RC    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_WRITE_RD      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RD    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_WRITE_RE      ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_NUM_REG_RE    ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_EXCEPTION_USE ,_param->_nb_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OUT_EXCEPTION     ,_param->_nb_inst_decod);

  DELETE1_SC_SIGNAL( in_DEPTH_MIN               ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DEPTH_MAX               ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_NB_INST_ALL             ,_param->_nb_context);
    }
#endif

  delete _Decod_queue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
