#ifdef STATISTICS
/*
 * $Id: Decod_queue_statistics_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::statistics_allocation"
  void Decod_queue::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Decod_queue,FUNCTION);


    _stat = new Stat (static_cast<std::string>(_name),
		      "Decod_queue",
		      param_statistics);

    _stat_use_queue = _stat->create_variable ("use_queue");
    _stat_nb_inst   = new counter_t * [_param->_nb_context];

    std::string expr_average_inst = "";

    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
        _stat_nb_inst [i] = _stat->create_variable("nb_inst_"+toString(i));
        
        _stat->create_expr_average_by_cycle("average_inst_"+toString(i), "nb_inst_"+toString(i), "", toString(_("Average instruction number in decod_queue by cycle (context %d)"),i));
        _stat->create_expr_percent         ("percent_use_inst_"+toString(i) , "average_inst_"+toString(i), toString(_param->_size_queue), toString(_("Percent decod_queue's occupation (context %d)"),i));
        
        if (i == 0)
          expr_average_inst = "nb_inst_"+toString(i);
	else
	  expr_average_inst = "+ nb_inst_"+toString(i) + " " +expr_average_inst;
      }

    _stat->create_expr_average_by_cycle("average_inst", expr_average_inst, "", _("Average instruction number in decod_queue by cycle (all context)"));
    _stat->create_expr_percent         ("percent_use_inst" , "average_inst", toString(_param->_size_queue), _("Percent decod_queue's occupation (all context)"));
    
    _stat->create_expr_average_by_cycle("average_use_queue", "use_queue", "", _("Average slot decod_queue occupation by cycle."));
    _stat->create_expr_percent         ("percent_use_queue", "average_use_queue", toString(_param->_size_queue), _("Percent slot decod_queue occupation."));
    
    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
