/*
 * $Id: Ifetch_unit_Glue.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/include/Ifetch_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_unit_glue {


#undef  FUNCTION
#define FUNCTION "Ifetch_unit_Glue::Ifetch_unit_Glue"
  Ifetch_unit_Glue::Ifetch_unit_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_unit_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"Begin");

#if DEBUG_Ifetch_unit_Glue == true
    log_printf(INFO,Ifetch_unit_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // Write constant
        PORT_WRITE(out_ICACHE_REQ_TYPE,ICACHE_TYPE_LOAD);

# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
	log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
#  ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
#  endif    
# endif	

	log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Method - genMealy_icache_req");

	SC_METHOD (genMealy_icache_req);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't use internal register
	sensitive << (*(in_ICACHE_REQ_ADDRESS_VAL))
		  << (*(in_ICACHE_REQ_ACK        ))
		  << (*(in_ICACHE_REQ_QUEUE_ACK  ))
		  << (*(in_ICACHE_REQ_ADDRESS_ADDRESS))
	  ;
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	(*(out_ICACHE_REQ_VAL        )) (*( in_ICACHE_REQ_ADDRESS_VAL));
	(*(out_ICACHE_REQ_VAL        )) (*( in_ICACHE_REQ_QUEUE_ACK  ));
	
	(*(out_ICACHE_REQ_QUEUE_VAL  )) (*( in_ICACHE_REQ_ADDRESS_VAL));
	(*(out_ICACHE_REQ_QUEUE_VAL  )) (*( in_ICACHE_REQ_ACK        ));
	
	(*(out_ICACHE_REQ_ADDRESS_ACK)) (*( in_ICACHE_REQ_QUEUE_ACK  ));
	(*(out_ICACHE_REQ_ADDRESS_ACK)) (*( in_ICACHE_REQ_ACK        ));

	(*(out_ICACHE_REQ_ADDRESS      )) (*( in_ICACHE_REQ_ADDRESS_ADDRESS));
	(*(out_ICACHE_REQ_QUEUE_ADDRESS)) (*( in_ICACHE_REQ_ADDRESS_ADDRESS));

# endif    

	log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Method - genMealy_event");

	SC_METHOD (genMealy_event);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't use internal register
	sensitive << (*(in_EVENT_VAL        ))
		  << (*(in_EVENT_ADDRESS_ACK))
		  << (*(in_EVENT_QUEUE_ACK  ));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	(*(out_EVENT_ACK        )) (*( in_EVENT_ADDRESS_ACK));
	(*(out_EVENT_ACK        )) (*( in_EVENT_QUEUE_ACK  ));
	
	(*(out_EVENT_QUEUE_VAL  )) (*( in_EVENT_ADDRESS_ACK));
	(*(out_EVENT_QUEUE_VAL  )) (*( in_EVENT_VAL        ));
	
	(*(out_EVENT_ADDRESS_VAL)) (*( in_EVENT_QUEUE_ACK  ));
	(*(out_EVENT_ADDRESS_VAL)) (*( in_EVENT_VAL        ));
# endif
#endif
      }
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Ifetch_unit_Glue::~Ifetch_unit_Glue"
  Ifetch_unit_Glue::~Ifetch_unit_Glue (void)
  {
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))  
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Ifetch_unit_Glue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"End");
  };

}; // end namespace ifetch_unit_glue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
