#ifdef VHDL
/*
 * $Id: Meta_Predictor_Glue_vhdl_body.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_body","Begin");
    vhdl->set_body ("");
    vhdl->set_body (" -- predict");
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	string meta_predictor_ack =  (_param._have_meta_predictor==true)?("in_PREDICT_"+toString(i)+"_PREDICTOR_0_ACK and in_PREDICT_"+toString(i)+"_PREDICTOR_1_ACK"):"'1'";

	vhdl->set_body ("out_PREDICT_"+toString(i)+"_ACK         <= "+meta_predictor_ack+" and "+"in_PREDICT_"+toString(i)+"_PREDICTOR_2_ACK;");

	uint32_t index=_param._size_history;


	if (_param._predictor_2_have_pht)
	  {
	vhdl->set_body ("out_PREDICT_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_2_pht_size_counter)+" <= in_PREDICT_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY;");
	index-= _param._predictor_2_pht_size_counter;
	  }
	if (_param._predictor_2_have_bht)
	  {
	vhdl->set_body ("out_PREDICT_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_2_bht_size_shifter)+" <= in_PREDICT_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY;");
	index-= _param._predictor_2_bht_size_shifter;
	  }

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_pht)
	  {
	vhdl->set_body ("out_PREDICT_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_1_pht_size_counter)+" <= in_PREDICT_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY;");
	index-= _param._predictor_1_pht_size_counter;
	  }
	if (_param._predictor_1_have_bht)
	  {
	vhdl->set_body ("out_PREDICT_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_1_bht_size_shifter)+" <= in_PREDICT_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY;");
	index-= _param._predictor_1_bht_size_shifter;
	  }

 	if (_param._predictor_0_have_pht)
	  {
	vhdl->set_body ("out_PREDICT_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_0_pht_size_counter)+" <= in_PREDICT_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY;");
	index-= _param._predictor_0_pht_size_counter;
	  }
	if (_param._predictor_0_have_bht)
	  {
	vhdl->set_body ("out_PREDICT_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_0_bht_size_shifter)+" <= in_PREDICT_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY;");
	index-= _param._predictor_0_bht_size_shifter;
	  }
	  }

	// direction of prediction
	vhdl->set_body ("");
	if (_param._have_meta_predictor)
	  vhdl->set_body ("out_PREDICT_"+toString(i)+"_DIRECTION   <= predict_"+toString(i)+"_predictor_0_direction when predict_"+toString(i)+"_predictor_2_direction='0' else predict_"+toString(i)+"_predictor_1_direction;");
	else
	  vhdl->set_body ("out_PREDICT_"+toString(i)+"_DIRECTION   <= predict_"+toString(i)+"_predictor_2_direction;");
      }

    // Interface - branch_complete

    vhdl->set_body ("");
    vhdl->set_body (" -- branch_complete");
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	// branch_complete_predictor_2 val and directionn
	if (_param._have_meta_predictor)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_VAL       <= (branch_complete_"+toString(i)+"_predictor_0_direction xor branch_complete_"+toString(i)+"_predictor_1_direction) and "+"in_BRANCH_COMPLETE_"+toString(i)+"_VAL;");
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_DIRECTION <= (branch_complete_"+toString(i)+"_predictor_0_direction and not in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION) or (branch_complete_"+toString(i)+"_predictor_1_direction and in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION);");
	  }

	string meta_predictor_ack =  (_param._have_meta_predictor==true)?("in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_ACK and in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_ACK"):"'1'";

	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_ACK                   <= "+meta_predictor_ack+" and "+"in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_ACK;");

	uint32_t index=_param._size_history;

	if (_param._predictor_2_have_pht)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY <= in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_2_pht_size_counter)+";");
	index-= _param._predictor_2_pht_size_counter;
	  }
	if (_param._predictor_2_have_bht)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY <= in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_2_bht_size_shifter)+";");
	index-= _param._predictor_2_bht_size_shifter;
	  }

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_pht)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY <= in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_1_pht_size_counter)+";");
	index-= _param._predictor_1_pht_size_counter;
	  }
	if (_param._predictor_1_have_bht)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY <= in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_1_bht_size_shifter)+";");
	index-= _param._predictor_1_bht_size_shifter;
	  }

	if (_param._predictor_0_have_pht)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY <= in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_0_pht_size_counter)+";");
	index-= _param._predictor_0_pht_size_counter;
	  }
	if (_param._predictor_0_have_bht)
	  {
	vhdl->set_body ("out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY <= in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"+std_logic_range(index-1,index-_param._predictor_0_bht_size_shifter)+";");
	index-= _param._predictor_0_bht_size_shifter;
	  }
	  }
      }

    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_body","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
#endif
