#ifdef SYSTEMC
/*
 * $Id: Two_Level_Branch_Predictor_Glue_genMealy_branch_complete_bht_address.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {

  void Two_Level_Branch_Predictor_Glue::genMealy_branch_complete_bht_address (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_branch_complete_address","Begin");

    if (_param._have_bht)
      for (uint32_t i=0; i<_param._nb_branch_complete; i++)
	{
	  // Address
	  Taddress_t address = PORT_READ(in_BRANCH_COMPLETE_ADDRESS [i]);
	  
	  PORT_WRITE (out_BRANCH_COMPLETE_BHT_ADDRESS [i], range<Taddress_t>(_param._size_address, address, _param._bht_size_address));
	}
    
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_branch_complete_address","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
