#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_return_address_stack_Return_Address_Stack_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_return_address_stack_Return_Address_Stack_h

/*
 * $Id: Return_Address_Stack.h 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


  class Return_Address_Stack 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;
	     
    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL           ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK           ; //[nb_inst_predict]
  public    : SC_IN (Tcontext_t)           **  in_PREDICT_CONTEXT_ID    ; //[nb_inst_predict] 
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_HIT           ; //[nb_inst_predict] 
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PUSH          ; //[nb_inst_predict] 1 = push, else pop
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS_PUSH  ; //[nb_inst_predict]
  public    : SC_OUT(Taddress_t)           ** out_PREDICT_ADDRESS_POP   ; //[nb_inst_predict] if pop:addr_top else addr_old
  public    : SC_OUT(Tptr_t    )           ** out_PREDICT_INDEX         ; //[nb_inst_predict]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_DECOD_VAL             ; //[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t)           ** out_DECOD_ACK             ; //[nb_inst_decod]
  public    : SC_IN (Tcontext_t)           **  in_DECOD_CONTEXT_ID      ; //[nb_inst_decod] 
  public    : SC_OUT(Tcontrol_t)           ** out_DECOD_HIT             ; //[nb_inst_decod] 
  public    : SC_IN (Tcontrol_t)           **  in_DECOD_PUSH            ; //[nb_inst_decod]   1 = push, else pop
  public    : SC_IN (Taddress_t)           **  in_DECOD_ADDRESS_PUSH    ; //[nb_inst_decod]
  public    : SC_OUT(Taddress_t)           ** out_DECOD_ADDRESS_POP     ; //[nb_inst_decod]   if pop:addr_top else addr_old
  public    : SC_OUT(Tptr_t    )           ** out_DECOD_INDEX           ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t)           **  in_DECOD_MISS_PREDICTION ; //[nb_inst_decod]   predict at stage 1 is a miss

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_VAL              ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_ACK              ; //[nb_inst_update]
  public    : SC_IN (Tcontext_t)           **  in_UPDATE_CONTEXT_ID       ; //[nb_inst_update] 
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_PUSH             ; //[nb_inst_update]  1 = push, else pop
  public    : SC_IN (Taddress_t)           **  in_UPDATE_ADDRESS          ; //[nb_inst_update]
  public    : SC_IN (Tptr_t    )           **  in_UPDATE_INDEX            ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_MISS_PREDICTION  ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_PREDICTION_IFETCH; //[nb_inst_update] // prediction only ifetch

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : ras_entry_t                  ** reg_stack         ; //[nb_context][size_queue]
  private   : Tptr_t                        * reg_TOP           ; //[nb_context]
  private   : Tptr_t                        * reg_BOTTOM        ; //[nb_context]
  private   : Tptr_t                        * reg_NB_ELT        ; //[nb_context]
  private   : Tptr_t                        * reg_PREDICT_TOP   ; //[nb_context]
  private   : Tptr_t                        * reg_PREDICT_BOTTOM; //[nb_context]
  private   : Tptr_t                        * reg_PREDICT_NB_ELT; //[nb_context]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : Tcontrol_t                    * internal_PREDICT_ACK; //[nb_inst_predict]
  public    : Tcontrol_t                    * internal_PREDICT_HIT; //[nb_inst_predict]
  public    : Tcontrol_t                    * internal_DECOD_ACK  ; //[nb_inst_decod  ]
  public    : Tcontrol_t                    * internal_DECOD_HIT  ; //[nb_inst_decod  ]
  public    : Tcontrol_t                    * internal_UPDATE_ACK ; //[nb_inst_update ]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Return_Address_Stack);
#endif
  public  :          Return_Address_Stack              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Return_Address_Stack             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy_predict          (void);
  public  : void        genMealy_decod            (void);
//   public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
