/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::Parameters"
  Parameters::Parameters (uint32_t   nb_context     ,
			  uint32_t * size_queue     ,
			  uint32_t   size_address   ,
			  uint32_t   nb_inst_predict,
			  uint32_t   nb_inst_decod  ,
			  uint32_t   nb_inst_update ,
                          bool       is_toplevel
                          )
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    _nb_context      = nb_context     ;
    _size_queue      = size_queue     ;
    _nb_inst_predict = nb_inst_predict;
    _nb_inst_decod   = nb_inst_decod  ;
    _nb_inst_update  = nb_inst_update ;

    _size_index      = max<uint32_t>(size_queue,nb_context);

    test();

    if (is_toplevel)
      {
        _size_instruction_address = size_address   ;
        _size_context_id          = log2(nb_context);
        _have_port_context_id     = _size_context_id > 0;

        copy ();
      }

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Return_Address_Stack::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
