/*
 * $Id: Return_Address_Stack_deallocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::deallocation"
  void Return_Address_Stack::deallocation (void)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL             ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_ACK             ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_CONTEXT_ID      ,_param->_nb_inst_predict,_param->_size_context_id); 
        DELETE1_SIGNAL(out_PREDICT_HIT             ,_param->_nb_inst_predict,1); 
        DELETE1_SIGNAL( in_PREDICT_PUSH            ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_ADDRESS_PUSH    ,_param->_nb_inst_predict,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_PREDICT_ADDRESS_POP     ,_param->_nb_inst_predict,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_PREDICT_INDEX           ,_param->_nb_inst_predict,_param->_size_index);

        DELETE1_SIGNAL( in_DECOD_VAL               ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_ACK               ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_CONTEXT_ID        ,_param->_nb_inst_decod,_param->_size_context_id); 
        DELETE1_SIGNAL(out_DECOD_HIT               ,_param->_nb_inst_decod,1); 
        DELETE1_SIGNAL( in_DECOD_PUSH              ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_ADDRESS_PUSH      ,_param->_nb_inst_decod,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_DECOD_ADDRESS_POP       ,_param->_nb_inst_decod,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_DECOD_INDEX             ,_param->_nb_inst_decod,_param->_size_index);
        DELETE1_SIGNAL( in_DECOD_MISS_PREDICTION   ,_param->_nb_inst_decod,1);

        DELETE1_SIGNAL( in_UPDATE_VAL              ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_ACK              ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_CONTEXT_ID       ,_param->_nb_inst_update,_param->_size_context_id); 
        DELETE1_SIGNAL( in_UPDATE_PUSH             ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_ADDRESS          ,_param->_nb_inst_update,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_UPDATE_INDEX            ,_param->_nb_inst_update,_param->_size_index);
        DELETE1_SIGNAL( in_UPDATE_MISS_PREDICTION  ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_PREDICTION_IFETCH,_param->_nb_inst_update,1);
        
        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        
        for (uint32_t i=0; i<_param->_nb_context; i++)
          delete [] reg_stack [i];
        delete [] reg_stack;
        delete [] reg_TOP;
        delete [] reg_BOTTOM;
        delete [] reg_NB_ELT;
        delete [] reg_PREDICT_TOP;
        delete [] reg_PREDICT_BOTTOM;
        delete [] reg_PREDICT_NB_ELT;
        
        delete [] internal_PREDICT_ACK;
        delete [] internal_PREDICT_HIT;
        delete [] internal_DECOD_ACK;
        delete [] internal_DECOD_HIT;
        delete [] internal_UPDATE_ACK;
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
