#ifdef SYSTEMC
/*
 * $Id: Update_Prediction_Table_transition.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {

#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::transition"
  void Update_Prediction_Table::transition (void)
  {
    log_begin(Update_Prediction_Table,FUNCTION);
    log_function(Update_Prediction_Table,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
        // Initialisation

        reg_UPDATE_PRIORITY = 0;

        // All pointer is set at 0
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  {
            for (uint32_t j=0; j<_param->_size_ufpt_queue[i]; ++j)
              reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._state = UPDATE_FETCH_PREDICTION_STATE_EMPTY;
            reg_UFPT_BOTTOM          [i] = 0;
            reg_UFPT_TOP             [i] = 0;
            reg_UFPT_UPDATE          [i] = 0;
            reg_UFPT_NB_NEED_UPDATE  [i] = 0;
                                                                
            for (uint32_t j=0; j<_param->_size_upt_queue[i]; ++j)
              reg_UPDATE_PREDICTION_TABLE [i][j]._state = UPDATE_PREDICTION_STATE_EMPTY;
            reg_UPT_BOTTOM           [i] = 0;
            reg_UPT_TOP              [i] = 0;
            reg_UPT_UPDATE           [i] = 0;
            reg_UPT_NB_NEED_UPDATE   [i] = 0;
                                                                                    
            reg_IS_ACCURATE          [i] = true;

            reg_EVENT_STATE          [i] = EVENT_STATE_OK;
          }
      }
    else
      {
	// ===================================================================
	// =====[ GARBAGE COLLECTOR ]=========================================
	// ===================================================================

        // Each cycle, if the most lastest branch have update all prediction struction (state = end), free this slot
        //   * Update state -> new status is "empty"
        //   * Update pointer (bottom and accurate)
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * GARBAGE COLLECTOR");
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  {
            // UPDATE_FETCH_PREDICTION_TABLE
            {
              uint32_t bottom = reg_UFPT_BOTTOM [i];
              
              // Test if state is end
              if (reg_UPDATE_FETCH_PREDICTION_TABLE [i][bottom]._state == UPDATE_FETCH_PREDICTION_STATE_END)
                {
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UFPT [%d][%d]",i,bottom);
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UFPT [%d][%d].state =  UPDATE_FETCH_PREDICTION_STATE_EMPTY",i,bottom);

                  // Free slot
                  reg_UPDATE_FETCH_PREDICTION_TABLE [i][bottom]._state = UPDATE_FETCH_PREDICTION_STATE_EMPTY;
                  // Update pointer
                  reg_UFPT_BOTTOM [i] = (bottom+1)%_param->_size_ufpt_queue[i];
                }
            }

            // UPDATE_PREDICTION_TABLE
            {
              uint32_t bottom = reg_UPT_BOTTOM [i];
              
              // Test if state is end
              if (reg_UPDATE_PREDICTION_TABLE [i][bottom]._state == UPDATE_PREDICTION_STATE_END)
                {
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UPT [%d][%d]",i,bottom);
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UPT [%d][%d]._state =  UPDATE_PREDICTION_STATE_EMPTY",i,bottom);

                  // Free slot
                  reg_UPDATE_PREDICTION_TABLE [i][bottom]._state = UPDATE_PREDICTION_STATE_EMPTY;
                  // Update pointer
                  reg_UPT_BOTTOM [i] = (bottom+1)%_param->_size_upt_queue[i];
                }
            }
	  }

	// ===================================================================
	// =====[ PREDICT ]===================================================
	// ===================================================================
        
        // An ifetch_unit compute next cycle and have an branch : predict_val is set
        //   * Alloc new entry -> new status is "wait decod"
        //   * Save input (to restore in miss or error)
        //   * Update pointer

	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  if (PORT_READ(in_PREDICT_VAL[i]) and internal_PREDICT_ACK [i])
	    {
	      Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_PREDICT_CONTEXT_ID [i]):0;
	      uint32_t   top     = internal_PREDICT_UPDATE_PREDICTION_ID [i];

	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * PREDICT[%d] - Accepted",i);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * context : %d",context);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * top     : %d",top);

#ifdef DEBUG_TEST
              if (reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._state != UPDATE_FETCH_PREDICTION_STATE_EMPTY)
                throw ERRORMORPHEO(FUNCTION,_("Predict : invalid state."));
#endif

              log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UFPT [%d][%d].state <- UPDATE_FETCH_PREDICTION_STATE_WAIT_DECOD (predict)",context,top);
 	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._state        = UPDATE_FETCH_PREDICTION_STATE_WAIT_DECOD;

              Tbranch_condition_t condition = PORT_READ(in_PREDICT_BTB_CONDITION [i]);

	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._condition    = condition;
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._address_src  = PORT_READ(in_PREDICT_BTB_ADDRESS_SRC  [i]);
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._address_dest = PORT_READ(in_PREDICT_BTB_ADDRESS_DEST [i]);
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._last_take    = PORT_READ(in_PREDICT_BTB_LAST_TAKE    [i]);
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._is_accurate  = PORT_READ(in_PREDICT_BTB_IS_ACCURATE  [i]);
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._history      = (_param->_have_port_history)?PORT_READ(in_PREDICT_DIR_HISTORY [i]):0;
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._address_ras  = PORT_READ(in_PREDICT_RAS_ADDRESS      [i]);
	      reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._index_ras    = PORT_READ(in_PREDICT_RAS_INDEX        [i]);

              reg_UFPT_TOP     [context] = (top+1)%_param->_size_ufpt_queue [context];
//            reg_UFPT_UPDATE  [context] = reg_UFPT_TOP [context];
              if (need_update(condition))
                reg_UFPT_NB_NEED_UPDATE [context] ++;
	    }

	// ===================================================================
	// =====[ DECOD ]=====================================================
	// ===================================================================


        // An decod is detected by decod stage
        //   1) Hit prediction : The instruction bundle have a branch predicted in ifetch stage and it is this branch
        //      * Update state, wait_decod -> wait_end
        //      * Pop ufpt -> push upt
        //      * Update accurate register : if the predict stage have tagged this branch as not accurate, stop decod
        //   2) Miss           : The instruction bundle have a branch but it is not predicted
        //      * Flush ufpt
        //      * decod information is write in upt

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  if (PORT_READ(in_DECOD_VAL[i]) and internal_DECOD_ACK [i])
	    {
	      Tcontext_t          context       = (_param->_have_port_context_id)?PORT_READ(in_DECOD_CONTEXT_ID [i]):0;
	      Tcontrol_t          miss_ifetch   = PORT_READ(in_DECOD_MISS_IFETCH [i]);
	      Tcontrol_t          miss_decod    = PORT_READ(in_DECOD_MISS_DECOD  [i]);
              uint32_t            upt_ptr_write = internal_DECOD_UPT_PTR_WRITE [i];
              Tbranch_condition_t condition  ;
              Tcontrol_t          is_accurate;

              log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * DECOD[%d] - Accepted",i);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * context       : %d",context);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * miss_ifetch   : %d",miss_ifetch);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * miss_decod    : %d",miss_decod);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * upt_ptr_write : %d",upt_ptr_write);
	      
              if (miss_ifetch or miss_decod)
		{
                  // Have a miss !!!

                  // Flush UPFT

                  // It's to accelerate miss speculation
                  if (reg_UFPT_NB_NEED_UPDATE [context] == 0)
                    {
                      // No entry need prediction, flush all entry -> Reset
                      for (uint32_t j=0; j<_param->_size_ufpt_queue[context]; ++j)
                        reg_UPDATE_FETCH_PREDICTION_TABLE [context][j]._state = UPDATE_FETCH_PREDICTION_STATE_EMPTY;
                      reg_UFPT_BOTTOM [context] = 0;
                      reg_UFPT_TOP    [context] = 0;
//                    reg_UFPT_UPDATE [context] = 0;
                    }
                  else
                    {
                      reg_UFPT_UPDATE [context] = reg_UFPT_TOP [context];

#ifdef DEBUG_TEST
                      if (reg_EVENT_STATE [context] == EVENT_STATE_OK)
                        throw ERRORMORPHEO(FUNCTION,_("Decod : invalid event state."));
#endif
                      
                      // Change state
                      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * EVENT [%d] <- EVENT_STATE_FLUSH_UFPT (decod - miss)",context);
                      
                      reg_EVENT_STATE [context] = EVENT_STATE_FLUSH_UFPT;
                    }

                  // Push upt (from decod interface)
                  condition   = PORT_READ(in_DECOD_BTB_CONDITION [i]);
                  is_accurate = PORT_READ(in_DECOD_IS_ACCURATE   [i]);

                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._condition         = condition;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._address_src       = PORT_READ(in_DECOD_BTB_ADDRESS_SRC  [i]);
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._address_dest      = PORT_READ(in_DECOD_BTB_ADDRESS_DEST [i]);
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._last_take         = PORT_READ(in_DECOD_BTB_LAST_TAKE    [i]);
//                reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._good_take;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._is_accurate       = is_accurate;
//                reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._history           = ; // static prediction
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._address_ras       = PORT_READ(in_DECOD_RAS_ADDRESS [i]);
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._index_ras         = PORT_READ(in_DECOD_RAS_INDEX   [i]);
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._ifetch_prediction = false; // static prediction
		}
	      else
		{
		  // Normal case : branch is previous predicated, change state of branch
                  uint32_t ufpt_ptr_read = (_param->_have_port_depth)?PORT_READ(in_DECOD_UPDATE_PREDICTION_ID [i]):0;

                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * ufpt_ptr_read : %d",ufpt_ptr_read);

#ifdef DEBUG_TEST
                  if (reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._state != UPDATE_FETCH_PREDICTION_STATE_WAIT_DECOD)
                    throw ERRORMORPHEO(FUNCTION,_("Decod : invalid ufpt state."));
#endif
                  // Change state
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UFPT [%d][%d].state <- UPDATE_FETCH_PREDICTION_STATE_END (decod - hit)",context,ufpt_ptr_read);
                  reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._state = UPDATE_FETCH_PREDICTION_STATE_END;

                  // Push upt (from Pop ufpt)
                  condition   = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._condition;
                  is_accurate = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._is_accurate;

                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._condition         = condition;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._address_src       = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._address_src ;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._address_dest      = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._address_dest;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._last_take         = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._last_take   ;
//                reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._good_take;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._is_accurate       = is_accurate;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._history           = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._history     ;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._address_ras       = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._address_ras ;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._index_ras         = reg_UPDATE_FETCH_PREDICTION_TABLE [context][ufpt_ptr_read]._index_ras   ;
                  reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._ifetch_prediction = true; // prediction from ifetch

                  // Update pointer
                  if (need_update(condition))
                    {
                      reg_UFPT_NB_NEED_UPDATE [context] --;
                    }
		}

              // All case !!!

#ifdef DEBUG_TEST
              if (reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._state != UPDATE_PREDICTION_STATE_EMPTY)
                throw ERRORMORPHEO(FUNCTION,_("Decod : invalid upt state."));
#endif
              
              // Change state
              log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UPT  [%d][%d].state <- UPDATE_PREDICTION_STATE_WAIT_END (decod - hit)",context,upt_ptr_write);
              reg_UPDATE_PREDICTION_TABLE [context][upt_ptr_write]._state = UPDATE_PREDICTION_STATE_WAIT_END;
              
              // Write new accurate 
#ifdef DEBUG_TEST
              if (not reg_IS_ACCURATE [context]  and not is_accurate)
                throw ERRORMORPHEO(FUNCTION,_("Decod : invalid accurate flag."));
#endif
              reg_IS_ACCURATE [context] = is_accurate;
              
              // Update pointer
              reg_UPT_TOP     [context] = (upt_ptr_write+1)%_param->_size_upt_queue [context];
//            reg_UPT_UPDATE  [context] = reg_UPT_TOP [context];
              if (need_update(condition))
                {
                  reg_UPT_NB_NEED_UPDATE  [context] ++;
                }
	    }

	// ===================================================================
	// =====[ BRANCH_COMPLETE ]===========================================
	// ===================================================================
        
        // The branch is complete
        //   * Hit  prediction : 
        //     * update status
        //   * Miss prediction :
	for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
	  if (PORT_READ(in_BRANCH_COMPLETE_VAL[i]) and internal_BRANCH_COMPLETE_ACK [i])
	    {
	      Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_BRANCH_COMPLETE_CONTEXT_ID [i]):0;
	      Tdepth_t   depth   = (_param->_have_port_depth     )?PORT_READ(in_BRANCH_COMPLETE_DEPTH      [i]):0;

	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * BRANCH_COMPLETE[%d] - Accepted",i);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * context : %d",context);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * depth   : %d",depth);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * miss    : %d",internal_BRANCH_COMPLETE_MISS_PREDICTION [i]);
	      
	      if (internal_BRANCH_COMPLETE_MISS_PREDICTION [i])
		{
		  // Miss case
// //                breakpoint("Branch_complete and miss ...");

//                   log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * state [%d][%d] <- UPDATE_PREDICTION_STATE_EVENT (branch_complete)",context,depth);
// 		  reg_UPDATE_PREDICTION_TABLE [context][depth]._state = UPDATE_PREDICTION_STATE_EVENT;

// 		  // Another prediction (prediction with depth higer)
// 		  Tdepth_t top                = reg_TOP [context];
// 		  uint32_t nb_elt_miss        = ((top> depth)?top:(top+_param->_size_queue[context]))-depth;
// 		  uint32_t nb_elt_need_update = 1;
// 		  for (uint32_t j=1; j<nb_elt_miss; j++)
// 		    {
// 		      uint32_t k=(depth+j)%_param->_size_queue[context];
		      
// 		      // Ifetch have make a prediction and it's a miss
// 		      // When ifetch predict :
// 		      //   * btb is not change       -> needn't update
// 		      //   * direction is not change -> needn't update
// 		      //   * ras have change         -> need    update

// 		      Tbranch_condition_t cond = reg_UPDATE_PREDICTION_TABLE [context][k]._condition;
// 		      if ((cond == BRANCH_CONDITION_NONE_WITH_WRITE_STACK) or
// 			  (cond == BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK) or
// 			  (cond == BRANCH_CONDITION_READ_STACK))
// 			{
//                           log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * state [%d][%d] <- UPDATE_PREDICTION_STATE_KO (branch_complete, ifetch miss, update ras)",context,k);

// 			  nb_elt_need_update ++;
// 			  reg_UPDATE_PREDICTION_TABLE [context][k]._state = UPDATE_PREDICTION_STATE_KO;
// 			}
// 		      else
// 			{
//                           log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * state [%d][%d] <- UPDATE_PREDICTION_STATE_END (branch_complete, ifetch miss, don't update ras)",context,k);

// 			  reg_UPDATE_PREDICTION_TABLE [context][k]._state = UPDATE_PREDICTION_STATE_END;
// 			}
// 		    }
// 		  reg_NB_ELT_NEED_UPDATE [context] += nb_elt_need_update;

// 		  // Update pointer :
// 		  reg_TOP                [context]  = depth;
// 		  reg_NB_ELT             [context] -= nb_elt_miss;
// 	      reg_UPDATE_PREDICTION_TABLE [context][depth]._address_dest = internal_BRANCH_COMPLETE_ADDRESS_DEST [i];

		}
	      else
		{
                  // Hit case

#ifdef DEBUG_TEST
                  if (reg_UPDATE_PREDICTION_TABLE [context][depth]._state != UPDATE_PREDICTION_STATE_WAIT_END)
                    throw ERRORMORPHEO(FUNCTION,_("Branch complete : invalid upt state."));
#endif
                    
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UPT  [%d][%d].state <- UPDATE_PREDICTION_STATE_OK (branch_complete, ifetch hit)",context,depth);
                  reg_UPDATE_PREDICTION_TABLE [context][depth]._state = UPDATE_PREDICTION_STATE_OK;
		}

	      // In all case : update good_take
	      reg_UPDATE_PREDICTION_TABLE [context][depth]._good_take = internal_BRANCH_COMPLETE_TAKE [i];
            }

	// ===================================================================
	// =====[ UPDATE ]====================================================
	// ===================================================================
	for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	  if ((internal_UPDATE_VAL[i] and PORT_READ(in_UPDATE_ACK [i])) or
              (internal_UPDATE_VAL_WITHOUT_ACK [i]))
	    {
	      Tcontext_t context = internal_UPDATE_CONTEXT_ID [i];
	      Tdepth_t   depth   = internal_UPDATE_DEPTH      [i];
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * UPDATE[%d] - Accepted",i);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * context : %d",context);
	      log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * depth   : %d",depth);

              if (internal_UPDATE_FROM_UFPT [i])
                {
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * Update Fetch Prediction Table");
                  
                  // Change state
#ifdef DEBUG_TEST
                  if (reg_UPDATE_FETCH_PREDICTION_TABLE [context][depth]._state != UPDATE_FETCH_PREDICTION_STATE_EVENT)
                    throw ERRORMORPHEO(FUNCTION,_("Update : invalid ufpt state."));
#endif

                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UFPT [%d][%d].state <- UPDATE_FETCH_PREDICTION_STATE_END (update)",context,depth);

                  reg_UPDATE_FETCH_PREDICTION_TABLE [context][depth]._state = UPDATE_FETCH_PREDICTION_STATE_END;

                  // Update pointer
                  reg_UFPT_UPDATE [context] = (depth==0)?(_param->_size_ufpt_queue[context]-1):(depth-1);

                  // Free a register that need update ?
                  if (need_update(reg_UPDATE_FETCH_PREDICTION_TABLE [context][depth]._condition))
                    reg_UFPT_NB_NEED_UPDATE [context] --;
                }
              else
                {
                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * Update Prediction Table");
                  
                  // Change state
#ifdef DEBUG_TEST
                  if ((reg_UPDATE_PREDICTION_TABLE [context][depth]._state != UPDATE_PREDICTION_STATE_OK   ) and
                      (reg_UPDATE_PREDICTION_TABLE [context][depth]._state != UPDATE_PREDICTION_STATE_KO   ) and
                      (reg_UPDATE_PREDICTION_TABLE [context][depth]._state != UPDATE_PREDICTION_STATE_EVENT))
                    throw ERRORMORPHEO(FUNCTION,_("Update : invalid upt state."));
#endif

                  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * UPT  [%d][%d].state <- UPDATE_PREDICTION_STATE_END (update)",context,depth);

                  reg_UPDATE_PREDICTION_TABLE [context][depth]._state = UPDATE_PREDICTION_STATE_END;

                  // Update pointer
                  if (internal_UPDATE_RAS [i])
                    reg_UPT_UPDATE [context] = (depth==0)?(_param->_size_upt_queue[context]-1):(depth-1);
                  else
                    reg_UPT_UPDATE [context] = (depth+1)%_param->_size_upt_queue[context];

                  // Free a register that need update ?
                  if (need_update(reg_UPDATE_PREDICTION_TABLE [context][depth]._condition))
                    reg_UPT_NB_NEED_UPDATE [context] --;
                  // Free the branch with no accurate ?
                  if (reg_UPDATE_PREDICTION_TABLE [context][depth]._is_accurate == false)
                    reg_IS_ACCURATE [i] = true;
                }
	    }
	
	// Round robin
	reg_UPDATE_PRIORITY = (reg_UPDATE_PRIORITY+1)%_param->_nb_context;

// 	// ===================================================================
// 	// =====[ BRANCH_EVENT ]==============================================
// 	// ===================================================================
// 	for (uint32_t i=0; i<_param->_nb_context; i++)
// 	  if (internal_BRANCH_EVENT_VAL [i] and PORT_READ(in_BRANCH_EVENT_ACK [i]))
//             {
//               Tdepth_t depth = internal_BRANCH_EVENT_DEPTH [i];

//               if (reg_UPDATE_PREDICTION_TABLE [i][depth]._state == UPDATE_PREDICTION_STATE_EVENT)
//                 {
//                   log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * state [%d][%d] <- UPDATE_PREDICTION_STATE_KO (branch_event)",i,depth);
                  
//                   reg_UPDATE_PREDICTION_TABLE [i][depth]._state = UPDATE_PREDICTION_STATE_KO;
//                 }
//               else
//                 {
// #ifdef DEBUG_TEST
//                   if (reg_UPDATE_PREDICTION_TABLE [i][depth]._state == UPDATE_PREDICTION_STATE_WAITEND_AND_EVENT)
//                     throw ERRORMORPHEO(FUNCTION,_("Branche event : invalid state"));
// #endif
              
//                   log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * state [%d][%d] <- UPDATE_PREDICTION_STATE_WAITEND (branch_event)",i,depth);
                  
//                   reg_UPDATE_PREDICTION_TABLE [i][depth]._state = UPDATE_PREDICTION_STATE_WAITEND;
//                 }
//             }

#if (DEBUG >= DEBUG_TRACE)
    log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * Dump Update_Prediction_Table");
    log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_UPDATE_PRIORITY       : %d",reg_UPDATE_PRIORITY);
    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_IS_ACCURATE           : %d",reg_IS_ACCURATE        [i]);
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_EVENT_STATE           : %s"  ,toString(reg_EVENT_STATE [i]).c_str());
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_EVENT_RAS_CORRUPTED   : %d"  ,reg_EVENT_RAS_CORRUPTED   [i]);
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_EVENT_ADDRESS_SRC     : %.8x",reg_EVENT_ADDRESS_SRC     [i]);
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_EVENT_ADDRESS_SRC_VAL : %d"  ,reg_EVENT_ADDRESS_SRC_VAL [i]);
        log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * reg_EVENT_ADDRESS_DEST    : %.8x",reg_EVENT_ADDRESS_DEST    [i]);

	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * Update_Fetch_Prediction_Table   [%d]",i);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UFPT_BOTTOM         : %d",reg_UFPT_BOTTOM         [i]);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UFPT_TOP            : %d",reg_UFPT_TOP            [i]);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UFPT_NB_NEED_UPDATE : %d",reg_UFPT_NB_NEED_UPDATE [i]);
	for (uint32_t j=0; j<_param->_size_ufpt_queue[i]; j++)
	  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"        [%d] %.4d, %.8x %.8x, %.1d   %.1d, %.8d %.8x %.4d - %s",
                     j,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._condition,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._address_src,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._address_dest,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._last_take,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._is_accurate,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._history,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._address_ras,
                     reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._index_ras,
                     toString(reg_UPDATE_FETCH_PREDICTION_TABLE [i][j]._state).c_str()
                     );

	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"    * Update_Prediction_Table   [%d]",i);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UPT_BOTTOM          : %d",reg_UPT_BOTTOM         [i]);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UPT_TOP             : %d",reg_UPT_TOP            [i]);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UPT_UPDATE          : %d",reg_UPT_UPDATE         [i]);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"      * reg_UPT_NB_NEED_UPDATE  : %d",reg_UPT_NB_NEED_UPDATE [i]);
	for (uint32_t j=0; j<_param->_size_upt_queue[i]; j++)
	  log_printf(TRACE,Update_Prediction_Table,FUNCTION,"        [%d] %.4d, %.8x %.8x, %.1d %.1d %.1d, %.8d %.8x %.4d - %s",
                     j,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._condition,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._address_src,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._address_dest,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._last_take,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._good_take,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._is_accurate,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._history,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._address_ras,
                     reg_UPDATE_PREDICTION_TABLE [i][j]._index_ras,
                     toString(reg_UPDATE_PREDICTION_TABLE [i][j]._state).c_str()
                     );
      }
#endif
      }


#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif
    
    log_end(Update_Prediction_Table,FUNCTION);
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
