#ifdef STATISTICS
/*
 * $Id: Commit_unit_statistics_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::statistics_allocation"
  void Commit_unit::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Commit_unit,FUNCTION);

    _stat = new Stat (static_cast<std::string>(_name),
		      "Commit_unit",
		      param_statistics);

    _stat_nb_inst_insert                = new counter_t * [_param->_nb_rename_unit];
    _stat_nb_inst_retire                = new counter_t * [_param->_nb_rename_unit];
    _stat_bank_nb_inst                  = new counter_t * [_param->_nb_bank];
    
    {
      std::string sum_nb_inst_insert = "";
      std::string sum_nb_inst_retire = "";

      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	{
	  _stat_nb_inst_insert [i] = _stat->create_variable("nb_inst_insert_"+toString(i));
	  _stat_nb_inst_retire [i] = _stat->create_variable("nb_inst_retire_"+toString(i));
	  
	  _stat->create_expr_average_by_cycle("average_use_interface_insert_"+toString(i), "nb_inst_insert_"+toString(i), "", toString(_("Average instruction by cycle on insert interface (rename_unit %d)"),i));
	  _stat->create_expr_average_by_cycle("average_use_interface_retire_"+toString(i), "nb_inst_retire_"+toString(i), "", toString(_("Average instruction by cycle on retire interface (rename_unit %d)"),i));
	  _stat->create_expr_percent         ("percent_use_interface_insert_"+toString(i) , "average_use_interface_insert_"+toString(i), toString(_param->_nb_inst_insert [i]), toString(_("Percent usage of insert interface (rename_unit %d)"),i));
	  _stat->create_expr_percent         ("percent_use_interface_retire_"+toString(i) , "average_use_interface_retire_"+toString(i), toString(_param->_nb_inst_retire [i]), toString(_("Percent usage of retire interface (rename_unit %d)"),i));

	  if (i == 0)
            {
              sum_nb_inst_insert = "nb_inst_insert_"+toString(i);
              sum_nb_inst_retire = "nb_inst_retire_"+toString(i);
            }
          else
            {
              sum_nb_inst_insert = "+ nb_inst_insert_"+toString(i) + " " +sum_nb_inst_insert;
              sum_nb_inst_retire = "+ nb_inst_retire_"+toString(i) + " " +sum_nb_inst_retire;
            }
	}

      _stat->create_expr_average_by_cycle("average_inst_insert", sum_nb_inst_insert, "", _("Average instruction insert by cycle"));
      _stat->create_expr_average_by_cycle("average_inst_retire", sum_nb_inst_retire, "", _("Average instruction retire by cycle"));
    }

    _stat_nb_inst_commit = _stat->create_variable("nb_inst_commit");
    _stat->create_expr_average_by_cycle("average_use_interface_commit","nb_inst_commit", "", _("Average instruction by cycle on commit interface"));
    _stat->create_expr_percent         ("percent_use_interface_commit", "average_use_interface_commit", toString(_param->_nb_inst_commit), _("Percent usage of commit interface"));

    _stat_nb_inst_commit_conflit_access = _stat->create_variable("nb_inst_commit_conflit_access");
    _stat->create_expr_average_by_cycle("average_use_interface_commit_conflit_access","nb_inst_commit_conflit_access", "", _("Average access conflit by cycle on commit interface"));
    _stat->create_expr_percent         ("percent_use_interface_commit_conflit_access","average_use_interface_commit_conflit_access", "average_use_interface_commit", _("Percent access conflit on commit interface"));

    // bank/queue occupation
    {
      std::string sum_bank_nb_inst = "";
      for (uint32_t i=0; i<_param->_nb_bank; i++)
        {
          _stat_bank_nb_inst [i] = _stat->create_variable("bank_nb_inst_"+toString(i));
          
          _stat->create_expr_average_by_cycle("average_occupation_bank_"+toString(i), "bank_nb_inst_"+toString(i), "", toString(_("Average instruction by cycle (bank %d)"),i));
          _stat->create_expr_percent         ("percent_occupation_bank_"+toString(i), "average_occupation_bank_"+toString(i), toString(_param->_size_bank), toString(_("Percent occupation of bank (bank %d)"),i));
          
          if (i == 0)
            sum_bank_nb_inst = "bank_nb_inst_"+toString(i);
          else
            sum_bank_nb_inst = "+ bank_nb_inst_"+toString(i) + " " +sum_bank_nb_inst;
        }
      
      _stat->create_expr_average_by_cycle("average_occupation_bank", sum_bank_nb_inst, "", _("Average instruction by cycle (all bank)"));
      _stat->create_expr_percent         ("percent_occupation_bank" , "average_occupation_bank", toString(_param->_size_queue), _("Percent occupation of Re-Order-Buffer (all bank)"));
    }


    log_end(Commit_unit,FUNCTION);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
