/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  256
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/Max.h"
#include "Behavioural/include/Allocation.h"
#include <list>

class request_t
{
public : Tcontext_t   _front_end_id         ;
public : Tcontext_t   _context_id           ;
public : Ttype_t      _type                 ;
public : Toperation_t _operation            ;
public : Tlsq_ptr_t   _store_queue_ptr_write;
public : Tlsq_ptr_t   _load_queue_ptr_write ;
  
public : request_t (Tcontext_t   front_end_id         ,
		    Tcontext_t   context_id           ,
		    Ttype_t      type                 ,
		    Toperation_t operation            ,
		    Tlsq_ptr_t   store_queue_ptr_write,
		    Tlsq_ptr_t   load_queue_ptr_write )
  {
    _front_end_id          = front_end_id         ;
    _context_id            = context_id           ;
    _type                  = type                 ;
    _operation             = operation            ;
    _store_queue_ptr_write = store_queue_ptr_write;
    _load_queue_ptr_write  = load_queue_ptr_write ;
  }  
};

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Load_Store_pointer_unit * _Load_Store_pointer_unit = new Load_Store_pointer_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_INSERT_VAL                  ," in_INSERT_VAL                  ",Tcontrol_t  ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_ACK                  ,"out_INSERT_ACK                  ",Tcontrol_t  ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_FRONT_END_ID         ," in_INSERT_FRONT_END_ID         ",Tcontext_t  ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_CONTEXT_ID           ," in_INSERT_CONTEXT_ID           ",Tcontext_t  ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_TYPE                 ," in_INSERT_TYPE                 ",Ttype_t     ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_OPERATION            ," in_INSERT_OPERATION            ",Toperation_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STORE_QUEUE_PTR_WRITE,"out_INSERT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t  ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_QUEUE_PTR_WRITE ,"out_INSERT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t  ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RETIRE_VAL                  ," in_RETIRE_VAL                  ",Tcontrol_t  ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK                  ,"out_RETIRE_ACK                  ",Tcontrol_t  ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_FRONT_END_ID         ," in_RETIRE_FRONT_END_ID         ",Tcontext_t  ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_CONTEXT_ID           ," in_RETIRE_CONTEXT_ID           ",Tcontext_t  ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_TYPE                 ," in_RETIRE_TYPE                 ",Ttype_t     ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_OPERATION            ," in_RETIRE_OPERATION            ",Toperation_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_USE_STORE_QUEUE      ," in_RETIRE_USE_STORE_QUEUE      ",Tcontrol_t  ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_USE_LOAD_QUEUE       ," in_RETIRE_USE_LOAD_QUEUE       ",Tcontrol_t  ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_STORE_QUEUE_PTR_WRITE," in_RETIRE_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t  ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_LOAD_QUEUE_PTR_WRITE ," in_RETIRE_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t  ,_param->_nb_inst_retire);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Load_Store_pointer_unit.\n"),name.c_str());

  (*(_Load_Store_pointer_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Load_Store_pointer_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_INSERT_VAL                  ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit,out_INSERT_ACK                  ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_INSERT_FRONT_END_ID         ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_INSERT_CONTEXT_ID           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_INSERT_TYPE                 ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_INSERT_OPERATION            ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit,out_INSERT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_insert);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit,out_INSERT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_VAL                  ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit,out_RETIRE_ACK                  ,_param->_nb_inst_retire);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_FRONT_END_ID         ,_param->_nb_inst_retire);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_CONTEXT_ID           ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_TYPE                 ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_OPERATION            ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_USE_STORE_QUEUE      ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_USE_LOAD_QUEUE       ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Load_Store_pointer_unit, in_RETIRE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_insert = 75;
  const  int32_t percent_transaction_retire = 75;
  
  Ttype_t      type     [2];
  type [0] = TYPE_MEMORY;
  type [1] = TYPE_ALU;

  Toperation_t operation[2];
  operation [0] = OPERATION_MEMORY_LOAD_8_Z;
  operation [1] = OPERATION_MEMORY_STORE_32;
  
  list<request_t> rob;
  list<request_t>::iterator it;

  Tlsq_ptr_t _STORE_QUEUE_PTR_WRITE [_param->_nb_load_store_queue];
  bool       _STORE_QUEUE_USE       [_param->_nb_load_store_queue][max<uint32_t>(_param->_size_store_queue,_param->_nb_load_store_queue)];
  Tlsq_ptr_t _STORE_QUEUE_NB_USE    [_param->_nb_load_store_queue];
  Tlsq_ptr_t _LOAD_QUEUE_PTR_WRITE  [_param->_nb_load_store_queue];
  bool       _LOAD_QUEUE_USE        [_param->_nb_load_store_queue][max<uint32_t>(_param->_size_load_queue,_param->_nb_load_store_queue)];

  for (uint32_t i=0; i<_param->_nb_load_store_queue; i++)
    {
      _STORE_QUEUE_PTR_WRITE [i] = 0;
      _STORE_QUEUE_NB_USE    [i] = 0;
      _LOAD_QUEUE_PTR_WRITE  [i] = 0;

      for (uint32_t j=0; j<max<uint32_t>(_param->_size_store_queue,_param->_nb_load_store_queue); j++)
	_STORE_QUEUE_USE       [i][j] = false;
      for (uint32_t j=0; j<max<uint32_t>(_param->_size_load_queue,_param->_nb_load_store_queue); j++)
	_LOAD_QUEUE_USE        [i][j] = false;
    }

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  in_INSERT_VAL          [i] ->write((rand()%100)<percent_transaction_insert);
	  Tcontext_t front_end_id = rand()%_param->_nb_front_end;
	  in_INSERT_FRONT_END_ID [i] ->write(front_end_id);
	  in_INSERT_CONTEXT_ID   [i] ->write(rand()%_param->_nb_context[front_end_id]);
	  in_INSERT_TYPE         [i] ->write(type     [rand()%2]);
	  in_INSERT_OPERATION    [i] ->write(operation[rand()%2]);
	}
      
      it = rob.begin();
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  in_RETIRE_VAL          [i] ->write(((rand()%100)<percent_transaction_retire) and (i< rob.size()));
	  
	  if (i< rob.size())
	    {
	      in_RETIRE_FRONT_END_ID          [i]->write(it->_front_end_id         );
	      in_RETIRE_CONTEXT_ID            [i]->write(it->_context_id           );
// 	      in_RETIRE_TYPE                  [i]->write(it->_type                 );
// 	      in_RETIRE_OPERATION             [i]->write(it->_operation            );
 	      in_RETIRE_USE_STORE_QUEUE       [i]->write((it->_type == TYPE_MEMORY) and     is_operation_memory_store(it->_operation));
 	      in_RETIRE_USE_LOAD_QUEUE        [i]->write((it->_type == TYPE_MEMORY) and not is_operation_memory_store(it->_operation));
	      in_RETIRE_STORE_QUEUE_PTR_WRITE [i]->write(it->_store_queue_ptr_write);
	      in_RETIRE_LOAD_QUEUE_PTR_WRITE  [i]->write(it->_load_queue_ptr_write );
	      
	      it++;
	    }
	}
      
      SC_START(0);

      it = rob.begin();
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  bool pop = false;
	  if (in_RETIRE_VAL[i]->read())
	    {
	      if (not (in_RETIRE_USE_STORE_QUEUE [i]->read() or
		       in_RETIRE_USE_LOAD_QUEUE  [i]->read()))
		TEST(Tcontrol_t, out_RETIRE_ACK[i]->read(),true);
	      
	      if (out_RETIRE_ACK[i]->read())
		{
		  pop = true;

		  LABEL("RETIRE[%d] Transaction accepted",i);
		  if (it->_type == TYPE_MEMORY)
		    {
		      LABEL(" * Type MEMORY");
		      if (is_operation_memory_store(it->_operation))
			{
			  LABEL("   * Operation STORE");
			  uint32_t lsq = _param->_link_load_store_unit_with_thread[it->_front_end_id][it->_context_id];
			  uint32_t ptr = it->_store_queue_ptr_write;
			  
			  LABEL("     * lsq : %d",lsq);
			  LABEL("     * ptr : %d",ptr);

			  _STORE_QUEUE_NB_USE    [lsq]      --;
			  _STORE_QUEUE_USE       [lsq][ptr] = false;
			}
		      else
			{
			  LABEL("   * Operation LOAD");
			  uint32_t lsq = _param->_link_load_store_unit_with_thread[it->_front_end_id][it->_context_id];
			  uint32_t ptr = it->_load_queue_ptr_write;

			  LABEL("     * lsq : %d",lsq);
			  LABEL("     * ptr : %d",ptr);
			  
			  _LOAD_QUEUE_USE       [lsq][ptr] = false;
			}
		    }
		  it = rob.erase(it);
		}
	    }

	  if ((pop == false) and (i< rob.size()))
	    it++;
	}

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	if (in_INSERT_VAL[i]->read())
	  {
	    if (in_INSERT_TYPE [i]->read() != TYPE_MEMORY)
	      TEST(Tcontrol_t, out_INSERT_ACK[i]->read(),true);

	    if (out_INSERT_ACK[i]->read())
	      {
		rob.push_back(request_t( in_INSERT_FRONT_END_ID          [i]->read(),
					 in_INSERT_CONTEXT_ID            [i]->read(),
					 in_INSERT_TYPE                  [i]->read(),
					 in_INSERT_OPERATION             [i]->read(),
					out_INSERT_STORE_QUEUE_PTR_WRITE [i]->read(),
					out_INSERT_LOAD_QUEUE_PTR_WRITE  [i]->read()));

		LABEL("INSERT[%d] Transaction accepted",i);

		if (in_INSERT_TYPE [i]->read() == TYPE_MEMORY)
		  {
		    LABEL(" * Type MEMORY");
		    if (is_operation_memory_store(in_INSERT_OPERATION [i]->read()))
		      {
			LABEL("   * Operation STORE");
			uint32_t lsq = _param->_link_load_store_unit_with_thread[in_INSERT_FRONT_END_ID[i]->read()][in_INSERT_CONTEXT_ID[i]->read()];
			uint32_t ptr = _STORE_QUEUE_PTR_WRITE [lsq];

			LABEL("     * lsq : %d",lsq);
			LABEL("     * ptr : %d",ptr);
			
			TEST(bool      , _STORE_QUEUE_USE       [lsq][ptr], false);
			TEST(Tlsq_ptr_t, out_INSERT_STORE_QUEUE_PTR_WRITE [i]->read(),ptr                         );
			TEST(Tlsq_ptr_t, out_INSERT_LOAD_QUEUE_PTR_WRITE  [i]->read(),_LOAD_QUEUE_PTR_WRITE  [lsq]);
			TEST(bool      ,static_cast<uint32_t>(_STORE_QUEUE_NB_USE [lsq]+1)<_param->_size_store_queue[lsq], true);
			
			_STORE_QUEUE_PTR_WRITE [lsq]      = (ptr+1)%_param->_size_store_queue[lsq];
			_STORE_QUEUE_NB_USE    [lsq]      ++;
			_STORE_QUEUE_USE       [lsq][ptr] = true;
		      }
		    else
		      {
			LABEL("   * Operation LOAD");
			uint32_t lsq = _param->_link_load_store_unit_with_thread[in_INSERT_FRONT_END_ID[i]->read()][in_INSERT_CONTEXT_ID[i]->read()];
			uint32_t ptr = _LOAD_QUEUE_PTR_WRITE [lsq];
			
			LABEL("     * lsq : %d",lsq);
			LABEL("     * ptr : %d",ptr);

			TEST(bool      , _LOAD_QUEUE_USE       [lsq][ptr], false);
			TEST(Tlsq_ptr_t, out_INSERT_STORE_QUEUE_PTR_WRITE [i]->read(),_STORE_QUEUE_PTR_WRITE  [lsq]);
			TEST(Tlsq_ptr_t, out_INSERT_LOAD_QUEUE_PTR_WRITE  [i]->read(),ptr                         );
			
			_LOAD_QUEUE_PTR_WRITE [lsq]      = (ptr+1)%_param->_size_load_queue[lsq];
			_LOAD_QUEUE_USE       [lsq][ptr] = true;
		      }
		  }
	      }
	  }


    for (uint32_t i=0; i<_param->_nb_load_store_queue; i++)
      {
	std::string str;

	LABEL("LOAD_STORE_QUEUE [%d]",i);

	LABEL(" * STORE_QUEUE_PTR_WRITE : %d",_STORE_QUEUE_PTR_WRITE [i]);
	LABEL(" * STORE_QUEUE_NB_USE    : %d",_STORE_QUEUE_NB_USE    [i]);

	str = "";
	for (uint32_t j=0; j<_param->_size_store_queue[i]; j++)
	  str += toString(_STORE_QUEUE_USE [i][j]) + " ";
	LABEL(" * %s",str.c_str());
	
	LABEL(" * LOAD_QUEUE_PTR_WRITE  : %d",_LOAD_QUEUE_PTR_WRITE [i]);

	str = "";
	for (uint32_t j=0; j<_param->_size_load_queue[i]; j++)
	  str += toString(_LOAD_QUEUE_USE [i][j]) + " ";
	LABEL(" * %s",str.c_str());
      }


      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_INSERT_VAL                  ;
  delete [] out_INSERT_ACK                  ;
  delete []  in_INSERT_FRONT_END_ID         ;
  delete []  in_INSERT_CONTEXT_ID           ;
  delete []  in_INSERT_TYPE                 ;
  delete []  in_INSERT_OPERATION            ;
  delete [] out_INSERT_STORE_QUEUE_PTR_WRITE;
  delete [] out_INSERT_LOAD_QUEUE_PTR_WRITE ;
  delete []  in_RETIRE_VAL                  ;
  delete [] out_RETIRE_ACK                  ;
  delete []  in_RETIRE_FRONT_END_ID         ;
  delete []  in_RETIRE_CONTEXT_ID           ;
//   delete []  in_RETIRE_TYPE                 ;
//   delete []  in_RETIRE_OPERATION            ;
  delete []  in_RETIRE_USE_STORE_QUEUE      ;
  delete []  in_RETIRE_USE_LOAD_QUEUE       ;
  delete []  in_RETIRE_STORE_QUEUE_PTR_WRITE;
  delete []  in_RETIRE_LOAD_QUEUE_PTR_WRITE ;
  
#endif

  delete _Load_Store_pointer_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
