#include "Behavioural/include/Identification.h"

namespace morpheo {
namespace behavioural {
  
  uint32_t get_nb_thread (uint32_t nb_context ,
			  uint32_t nb_front_end ,
			  uint32_t nb_ooo_engine )
  {
    return (nb_ooo_engine *
	    nb_front_end  *
	    nb_context) ;
  }
  
  Tcontext_t get_num_thread (Tcontext_t num_context_id   , uint32_t size_context_id   ,
			     Tcontext_t num_front_end_id , uint32_t size_front_end_id ,
			     Tcontext_t num_ooo_engine_id, uint32_t size_ooo_engine_id)
  {
    return ((num_ooo_engine_id << (size_context_id + size_front_end_id)) |
	    (num_front_end_id  << (size_context_id)) |
	    (num_context_id));
  }

  Tcontext_t get_num_context (Tcontext_t num_thread        ,
			      uint32_t   size_context_id   ,
			      uint32_t   size_front_end_id ,
			      uint32_t   size_ooo_engine_id)
  {
    return range<Tcontext_t>(num_thread, size_context_id);
  }

  Tcontext_t get_num_front_end (Tcontext_t num_thread        ,
				uint32_t   size_context_id   ,
				uint32_t   size_front_end_id ,
				uint32_t   size_ooo_engine_id)
  {
    return range<Tcontext_t>(num_thread>>size_context_id, size_front_end_id);
  }

  Tcontext_t get_num_ooo_engine (Tcontext_t num_thread        ,
				 uint32_t   size_context_id   ,
				 uint32_t   size_front_end_id ,
				 uint32_t   size_ooo_engine_id)
  {
    return range<Tcontext_t>(num_thread>>(size_context_id+size_front_end_id), size_ooo_engine_id);
  }

}; // end namespace behavioural
}; // end namespace morpheo              
