#ifndef Morpheo_ToBase2_h
#define Morpheo_ToBase2_h

/*
 * $Id: ToBase2.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include <sstream>

namespace morpheo              {

  template<typename T> inline std::string toBase2 (const T& value, const uint32_t & size)
  {
    std::ostringstream res;
    T mask = 1<<(size-1);
    
    while (mask != 0)
      {
	res  << ((value&mask)?'1':'0');
	mask >>= 1;
      }

    return res.str();
  }

  inline std::string toBase2 (const bool    & value)
  {
    return toBase2<bool   >  (value, 1);
  }

  inline std::string toBase2 (const uint8_t & value, const uint32_t & size)
  {
    return toBase2<uint8_t>  (value, size);
  }

  inline std::string toBase2 (const uint16_t& value, const uint32_t & size)
  {
    return toBase2<uint16_t> (value, size);
  }

  inline std::string toBase2 (const uint32_t& value, const uint32_t & size)
  {
    return toBase2<uint32_t> (value, size);
  }

  inline std::string toBase2 (const uint64_t& value, const uint32_t & size)
  {
    return toBase2<uint64_t> (value, size);
  }


}; // end namespace morpheo              

#endif
