#ifdef SYSTEMC
/*
 * $Id: Issue_queue_genMoore.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::genMoore"
  void Issue_queue::genMoore (void)
  {
    log_begin(Issue_queue,FUNCTION);
    log_function(Issue_queue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_bank; i++)
      internal_BANK_OUT_VAL [i] = false;

    std::list<generic::priority::select_t> * select = _priority_out->select(); // same select for all issue

    uint32_t num_bank_offset = 0;
    for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
      {
// 	log_printf(TRACE,Issue_queue,FUNCTION,"  * ISSUE_OUT [%d]",i);
	Tcontrol_t val      = false;
	uint32_t   num_bank = 0;

	// find a non empty bank
	for (std::list<generic::priority::select_t>::iterator it=select->begin();
	     it!=select->end();
	     it++)
	  {
	    num_bank=num_bank_offset+it->grp;
	   
// 	    log_printf(TRACE,Issue_queue,FUNCTION,"    * Bank [%d]",num_bank);
	    
	    if (not _issue_queue [num_bank].empty())
	      {
// 		log_printf(TRACE,Issue_queue,FUNCTION,"      * Not Empty !!!");
		val = true;

		internal_BANK_OUT_NUM_INST [num_bank] = i;
		break; // quit scearch loop
	      }
	  }

	PORT_WRITE(out_ISSUE_OUT_VAL [i], val);

	if (val)
	  {
	    // have find a bank with a data
	    internal_BANK_OUT_VAL [num_bank] = true;
	
	    entry_t* entry = _issue_queue [num_bank].front();
	    
	    if (_param->_have_port_context_id)
	    PORT_WRITE(out_ISSUE_OUT_CONTEXT_ID            [i], entry->_context_id           );
	    if (_param->_have_port_front_end_id)
	    PORT_WRITE(out_ISSUE_OUT_FRONT_END_ID          [i], entry->_front_end_id         );
	    if (_param->_have_port_rob_ptr  )
	    PORT_WRITE(out_ISSUE_OUT_PACKET_ID             [i], entry->_packet_id            );
	    PORT_WRITE(out_ISSUE_OUT_OPERATION             [i], entry->_operation            );
	    PORT_WRITE(out_ISSUE_OUT_TYPE                  [i], entry->_type                 );
	    PORT_WRITE(out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE [i], entry->_store_queue_ptr_write);
	    if (_param->_have_port_load_queue_ptr)
	    PORT_WRITE(out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE  [i], entry->_load_queue_ptr_write );
	    PORT_WRITE(out_ISSUE_OUT_HAS_IMMEDIAT          [i], entry->_has_immediat         );
	    PORT_WRITE(out_ISSUE_OUT_IMMEDIAT              [i], entry->_immediat             );
	    PORT_WRITE(out_ISSUE_OUT_READ_RA               [i], entry->_read_ra              );
	    PORT_WRITE(out_ISSUE_OUT_NUM_REG_RA            [i], entry->_num_reg_ra           );
	    PORT_WRITE(out_ISSUE_OUT_READ_RB               [i], entry->_read_rb              );
	    PORT_WRITE(out_ISSUE_OUT_NUM_REG_RB            [i], entry->_num_reg_rb           );
	    PORT_WRITE(out_ISSUE_OUT_READ_RC               [i], entry->_read_rc              );
	    PORT_WRITE(out_ISSUE_OUT_NUM_REG_RC            [i], entry->_num_reg_rc           );
	    PORT_WRITE(out_ISSUE_OUT_WRITE_RD              [i], entry->_write_rd             );
	    PORT_WRITE(out_ISSUE_OUT_NUM_REG_RD            [i], entry->_num_reg_rd           );
	    PORT_WRITE(out_ISSUE_OUT_WRITE_RE              [i], entry->_write_re             );
	    PORT_WRITE(out_ISSUE_OUT_NUM_REG_RE            [i], entry->_num_reg_re           );
	  }

	num_bank_offset += _param->_nb_bank_select_out;
      }

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
