/*
 *
 * [desc.]
 */
#include "Tools/Viewer/Parser/include/parser.h"

namespace morpheo{
namespace tools{
namespace viewer{
namespace parser{

  int Parse::open_file_param(string name){
    /*!! name of entity top level!!*/
    QString s,s2;

    s.append(QString::fromStdString(name));

    s2.append(QString::fromStdString(name));
    
    QFile file2(s.append(".gen"));

    QFile file(s2.append(".cfg"));

    
    if( !file2.open( QIODevice::ReadOnly ) )
       {
	 cerr << "Failed to load file. File not found\n";
	 return -1;
       }

    QDomDocument doc2( "pos" );
     if( !doc2.setContent( &file2 ) )
      {
	cerr <<  "Failed to load file.Not Xml File\n";
	file2.close();
	return -1;
      }
     file2.close();
     QDomElement root2 = doc2.documentElement();
     if( root2.tagName() != "parameters" )
       {
	 cerr <<"Invalid file.\n";
	 return -1;
       }
     else
       {
         #ifdef DBUG_PARSE
	 cout << "parameters limit" <<endl;
         #endif
	 	 	 
	 parser_limitparam(root2.firstChild());    
	 
       }
    

     if( !file.open( QIODevice::ReadOnly ) )
       {
	 cerr << "Failed to load file. File not found.\n";
	 cerr << "search temporary file if exists.\n";
	 file.setFileName (s2.append("~"));
	 if( !file.open( QIODevice::ReadOnly ) )
	   {
	     cerr << "Failed to load temporary file. Create a default configuration.\n";
	     createParam();
	     return 0;
	   }
       
	 
       }

     QDomDocument doc( "gen2" );
     if( !doc.setContent( &file ) )
      {
	cerr <<  "Failed to load file.Not Xml File\n";
	file.close();
	return -1;
      }
     file.close();
     QDomElement root = doc.documentElement();
     if( root.tagName() != "cpu" && \
	 strcmp((root.attribute("name","").toStdString()).c_str(),name.c_str()))
       {
	 cout <<"Invalid file.\n";
	 return -1;
       }
     else
       {
         #ifdef DBUG_PARSE
	 cout << "parameters" <<endl;
         #endif
	 
	 parser_param(root.firstChild(),0);    
	 
       }

     return 0;


   }


};//end parser
};//end viewer
};//end tools
};//end morpheo

