/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Parameters.h"
#include "Common/include/Max.h"
namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::Parameters"
  Parameters::Parameters (uint32_t    nb_execute_unit              ,
			  uint32_t  * nb_execute_unit_port         ,//[nb_execute_unit]
			  uint32_t    nb_write_unit                ,
			  uint32_t    nb_context                   ,
			  uint32_t    nb_front_end                 ,
			  uint32_t    nb_ooo_engine                ,
			  uint32_t    nb_packet                    ,
			  uint32_t    size_general_data            ,
			  uint32_t    size_special_data            ,
			  uint32_t    nb_general_register          ,
			  uint32_t    nb_special_register          ,
			  Tpriority_t priority                     ,
			  bool    *** table_routing                ,//[nb_execute_unit][nb_execute_unit_port][nb_write_unit]
			  bool     ** table_thread                 ,//[nb_write_unit][nb_thread]                            
                          bool        is_toplevel                  )
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    _nb_execute_unit         = nb_execute_unit     ;
    _nb_execute_unit_port    = nb_execute_unit_port;
    _nb_write_unit           = nb_write_unit       ;
    _nb_context              = nb_context          ;
    _nb_front_end            = nb_front_end        ;
    _nb_ooo_engine           = nb_ooo_engine       ;
    _nb_packet               = nb_packet           ;
    _nb_general_register     = nb_general_register ;
    _nb_special_register     = nb_special_register ;
    _priority                = priority            ;
    _table_routing           = table_routing       ;
    _table_thread            = table_thread        ;

    _max_nb_execute_unit_port= max<uint32_t>(_nb_execute_unit_port, _nb_execute_unit);

    _nb_thread               = get_nb_thread (nb_context, nb_front_end, nb_ooo_engine);

    test();

    if (is_toplevel)
      {
        _size_context_id         = log2(nb_context         );
        _size_front_end_id       = log2(nb_front_end       );
        _size_ooo_engine_id      = log2(nb_ooo_engine      );
        _size_rob_ptr            = log2(nb_packet          );
        _size_general_register   = log2(nb_general_register);
        _size_special_register   = log2(nb_special_register);
        _size_general_data       = size_general_data  ;
        _size_special_data       = size_special_data  ;
        
        _have_port_context_id    = _size_context_id    > 0;
        _have_port_front_end_id  = _size_front_end_id  > 0;
        _have_port_ooo_engine_id = _size_ooo_engine_id > 0;
        _have_port_rob_ptr       = _size_rob_ptr       > 0;

        copy();
      }

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Execution_unit_to_Write_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)  
//   {
//     log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

//     test();
//     log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
