/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/SelfTest/include/test.h"
#include "Common/include/Max.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                              (uint32_t         )\n"));
  err (_(" * nb_context     [nb_front_end]             (uint32_t         )\n"));
  err (_(" * nb_icache_port                            (uint32_t         )\n"));
  err (_(" * size_address                              (uint32_t         )\n"));
  err (_(" * nb_instruction [nb_front_end][nb_context] (uint32_t         )\n"));
  err (_(" * size_packet_id [nb_front_end][nb_context] (uint32_t         )\n"));
  err (_(" * table_routing  [nb_front_end][nb_context] (uint32_t         )\n"));
  err (_(" * priority                                  (Tpriority_t      )\n"));
  err (_(" * load_balancing                            (Tload_balancing_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t             _nb_front_end           = fromString<uint32_t         >(argv[x++]);

  if (argc <= static_cast<int>(2+NB_PARAMS+_nb_front_end))
    usage (argc, argv);

  uint32_t             _sum_nb_context         = 0;
  uint32_t           * _nb_context             = new uint32_t [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _nb_context [i] = fromString<uint32_t>(argv[x++]);
      _sum_nb_context += _nb_context [i];
    }

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_front_end+3*_sum_nb_context))
    usage (argc, argv);
      
  uint32_t             _nb_icache_port         = fromString<uint32_t         >(argv[x++]);
  uint32_t             _size_address           = fromString<uint32_t         >(argv[x++]);

  uint32_t          ** _nb_instruction         = new uint32_t * [_nb_front_end];
  uint32_t          ** _size_packet_id         = new uint32_t * [_nb_front_end];
  uint32_t          ** _table_routing          = new uint32_t * [_nb_front_end];

  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _nb_instruction [i] = new uint32_t [_nb_context[i]];
      _size_packet_id [i] = new uint32_t [_nb_context[i]];
      _table_routing  [i] = new uint32_t [_nb_context[i]];
    }

  for (uint32_t i=0; i<_nb_front_end; i++)
    for (uint32_t j=0; j<_nb_context [i]; j++)
      _nb_instruction [i][j] = fromString<uint32_t>(argv[x++]);

  for (uint32_t i=0; i<_nb_front_end; i++)
    for (uint32_t j=0; j<_nb_context [i]; j++)
      _size_packet_id [i][j] = fromString<uint32_t>(argv[x++]);
  
  for (uint32_t i=0; i<_nb_front_end; i++)
    for (uint32_t j=0; j<_nb_context [i]; j++)
      _table_routing  [i][j] = fromString<uint32_t>(argv[x++]);
  
  Tpriority_t          _priority               = fromString<Tpriority_t      >(argv[x++]);
  Tload_balancing_t    _load_balancing         = fromString<Tload_balancing_t>(argv[x++]);

  uint32_t             _size_icache_thread_id  = log2(_nb_front_end) + log2(max<uint32_t>(_nb_context,_nb_front_end));;
  uint32_t             _size_icache_packet_id  = max<uint32_t>(_size_packet_id,_nb_front_end, _nb_context);

  uint32_t             _nb_thread              = 0;
  uint32_t          ** _translate_context_to_thread = new uint32_t * [_nb_front_end];

  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _translate_context_to_thread [i] = new uint32_t [_nb_context[i]];
      for (uint32_t j=0; j<_nb_context[i]; ++j)
        _translate_context_to_thread [i][j] = _nb_thread ++;
    }

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::icache_access::Parameters * param = new morpheo::behavioural::core::icache_access::Parameters
	(_nb_thread                  ,
         _nb_front_end               ,
	 _nb_context                 ,
	 _nb_icache_port             ,
	 _size_address               ,
         _size_icache_thread_id      ,
         _size_icache_packet_id      ,
	 _nb_instruction             ,
	 _size_packet_id             ,
	 _table_routing              ,
	 _priority                   ,
	 _load_balancing             ,
         _translate_context_to_thread
         );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Icache_Access : no error");
      else
	TEST_KO("Icache_Access : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_context;
  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      delete [] _nb_instruction [i];
      delete [] _size_packet_id [i];
      delete [] _table_routing  [i];
      delete [] _translate_context_to_thread [i];
    }
  delete [] _nb_instruction;
  delete [] _size_packet_id;
  delete [] _table_routing ;
  delete [] _translate_context_to_thread;

  return (_return);
}
