#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"
#include "Behavioural/include/Parameters.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : Tpredictor_t _predictor_scheme          ;
  public : uint32_t     _nb_inst_predict           ;
  public : uint32_t     _nb_inst_update            ;
//public : uint32_t     _size_address              ;
  public : bool         _have_bht               [3];
  public : uint32_t     _bht_size_shifter       [3];
  public : uint32_t     _bht_nb_shifter         [3];
  public : bool         _have_pht               [3];
  public : uint32_t     _pht_size_counter       [3];
  public : uint32_t     _pht_nb_counter         [3];
  public : uint32_t     _pht_size_address_share [3];

  public : uint32_t     _size_history;

  public : bool         _have_component_meta_predictor;
  public : bool         _have_port_history;

  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Parameters * _param_glue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (Tpredictor_t predictor_scheme          ,
			uint32_t     nb_inst_predict           ,
			uint32_t     nb_inst_update            ,
			uint32_t     size_address              ,
			bool         have_bht               [3],
			uint32_t     bht_size_shifter       [3],
			uint32_t     bht_nb_shifter         [3],
			bool         have_pht               [3],
			uint32_t     pht_size_counter       [3],
			uint32_t     pht_nb_counter         [3],
			uint32_t     pht_size_address_share [3],
                        bool         is_toplevel=false
                        );

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::Parameters & x);
  };

}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
