/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


#undef  FUNCTION
#define FUNCTION "Reexecute_unit::Parameters"
  Parameters::Parameters (uint32_t            size_context_id         ,
			  uint32_t            size_front_end_id       ,
			  uint32_t            size_packet_id          ,
			  uint32_t            size_queue              ,
			  uint32_t            nb_execute_loop         ,
			  uint32_t          * nb_inst_execute         ,
			  uint32_t            nb_inst_commit          ,
			  uint32_t            nb_inst_reexecute       ,
			  uint32_t            nb_execute_loop_select  ,
			  Tpriority_t         priority_execute_loop   ,
			  Tload_balancing_t   load_balancing          ,
			  uint32_t            size_general_register_id,
			  uint32_t            size_special_register_id,
			  uint32_t            size_general_data       ,
			  uint32_t            size_special_data       ,
			  uint32_t            size_store_queue_ptr    ,
			  uint32_t            size_load_queue_ptr     ,
                          bool                is_toplevel)
  {
    log_begin(Reexecute_unit,FUNCTION);

//  _size_context_id          = size_context_id         ;
//  _size_front_end_id        = size_front_end_id       ;
//  _size_packet_id           = size_packet_id          ;
    _size_queue               = size_queue              ;
    _nb_execute_loop          = nb_execute_loop         ;
    _nb_inst_execute          = nb_inst_execute         ;
    _nb_inst_commit           = nb_inst_commit          ;
    _nb_inst_reexecute        = nb_inst_reexecute       ;
    _nb_execute_loop_select   = nb_execute_loop_select  ;
    _priority_execute_loop    = priority_execute_loop   ;
    _load_balancing           = load_balancing          ;
//  _size_general_register_id = size_general_register_id;
//  _size_special_register_id = size_special_register_id;
//  _size_general_data        = size_general_data       ;
//  _size_special_data        = size_special_data       ;
//  _size_store_queue_ptr     = size_store_queue_ptr    ;
//  _size_load_queue_ptr      = size_load_queue_ptr     ;

    _max_nb_inst_execute      = max<uint32_t>(_nb_inst_execute, _nb_execute_loop);
    _nb_bank                  = _nb_inst_reexecute;
    _size_bank                = _size_queue / _nb_bank;

//  _have_port_context_id     = _size_context_id     > 0;
//  _have_port_front_end_id   = _size_front_end_id   > 0;
//  _have_port_packet_id      = _size_packet_id      > 0;
//  _have_port_load_queue_ptr = _size_load_queue_ptr > 0;

    test();

    if (is_toplevel)
      {
        _size_context_id          = size_context_id         ;
        _size_front_end_id        = size_front_end_id       ;
        _size_rob_ptr             = size_packet_id          ;
        _size_general_register    = size_general_register_id;
        _size_special_register    = size_special_register_id;
        _size_general_data        = size_general_data       ;
        _size_special_data        = size_special_data       ;
        _size_store_queue_ptr     = size_store_queue_ptr    ;
        _size_load_queue_ptr      = size_load_queue_ptr     ;
        
        _have_port_context_id     = _size_context_id     > 0;
        _have_port_front_end_id   = _size_front_end_id   > 0;
        _have_port_rob_ptr        = _size_rob_ptr        > 0;
        _have_port_load_queue_ptr = _size_load_queue_ptr > 0;

        copy();
      }

    log_end(Reexecute_unit,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Reexecute_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Reexecute_unit,FUNCTION);
//     test();
//     log_end(Reexecute_unit,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Reexecute_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Reexecute_unit,FUNCTION);
    log_end(Reexecute_unit,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Reexecute_unit::copy"
  void Parameters::copy (void) 
  {
    log_begin(Reexecute_unit,FUNCTION);
    log_end(Reexecute_unit,FUNCTION);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
