#ifdef VHDL
/*
 * $Id: Victim_Pseudo_LRU_vhdl_declaration.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {


  void Victim_Pseudo_LRU::vhdl_declaration (Vhdl * & vhdl)
  {
    vhdl->set_type ("Ttable", "array (" + toString(_param->_size_table-1) + " downto 0) of "+std_logic(_param->_nb_entity-1));


    vhdl->set_signal ("reg_TABLE", "Ttable");
    for (uint32_t i=0; i<_param->_nb_access; i++)
      {
	vhdl->set_signal ("access_entry_"+toString(i)+"     ",std_logic(_param->_nb_entity-1));
	vhdl->set_signal ("access_next_entry_"+toString(i)+"",std_logic(_param->_nb_entity-1));
	vhdl->set_signal ("access_entity_"+toString(i)+"    ",std_logic(static_cast<uint32_t>(log2(_param->_nb_entity))));
      }

    for (uint32_t i=0; i<_param->_nb_update; i++)
      {
	vhdl->set_signal ("update_next_entry_"+toString(i)+"",std_logic(_param->_nb_entity-1));
      }
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
