#include "Behavioural/include/SPR_access_mode.h"

namespace morpheo {
namespace behavioural {

  bool SPR_access_mode::exist (spr_address_t address)
  {
    return exist(address._group, address._register);
  }
  
  bool SPR_access_mode::exist (uint32_t num_group, uint32_t num_reg)
  {
    if (not valid(num_group, num_reg))
      return false;

    spr_access_mode_t mode = _spr_generic [num_group][num_reg];

    return ((mode._supervisor_access_mode != SPR_ACCESS_MODE_NONE) or
	    (mode._user_access_mode       != SPR_ACCESS_MODE_NONE));
  }

}; // end namespace behavioural
}; // end namespace morpheo              

