/*
 * $Id: Types.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Common/include/Translation.h"

namespace morpheo {
namespace behavioural {

#undef  FUNCTION
#define FUNCTION "instruction_information"
  instruction_t instruction_information (uint32_t instruction)
  {
    switch (instruction)
      {
      case INSTRUCTION_L_ADD       : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_ADD             ,ORBIS32,1);
      case INSTRUCTION_L_ADDC      : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_ADD             ,ORBIS32,1);
      case INSTRUCTION_L_ADDI      : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_ADD             ,ORBIS32,1);
      case INSTRUCTION_L_ADDIC     : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_ADD             ,ORBIS32,1);
      case INSTRUCTION_L_AND       : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_AND             ,ORBIS32,1);
      case INSTRUCTION_L_ANDI      : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_AND             ,ORBIS32,1);
      case INSTRUCTION_L_BF        : return instruction_t (TYPE_BRANCH ,OPERATION_BRANCH_L_TEST_F       ,ORBIS32,1);
      case INSTRUCTION_L_BNF       : return instruction_t (TYPE_BRANCH ,OPERATION_BRANCH_L_TEST_NF      ,ORBIS32,1);
      case INSTRUCTION_L_CMOV      : return instruction_t (TYPE_MOVE   ,OPERATION_MOVE_L_CMOV           ,ORBIS32,2);
      case INSTRUCTION_L_CSYNC     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_CSYNC       ,ORBIS32,2);
      case INSTRUCTION_L_CUST1     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_1            ,ORBIS32,2);
      case INSTRUCTION_L_CUST2     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_2            ,ORBIS32,2);
      case INSTRUCTION_L_CUST3     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_3            ,ORBIS32,2);
      case INSTRUCTION_L_CUST4     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_4            ,ORBIS32,2);
      case INSTRUCTION_L_CUST5     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_5            ,ORBIS32,2);
      case INSTRUCTION_L_CUST6     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_6            ,ORBIS32,2);
      case INSTRUCTION_L_CUST7     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_7            ,ORBIS32,2);
      case INSTRUCTION_L_CUST8     : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_L_8            ,ORBIS32,2);
      case INSTRUCTION_L_DIV       : return instruction_t (TYPE_DIV    ,OPERATION_DIV_L_DIV             ,ORBIS32,2);
      case INSTRUCTION_L_DIVU      : return instruction_t (TYPE_DIV    ,OPERATION_DIV_L_DIVU            ,ORBIS32,2);
      case INSTRUCTION_L_EXTBS     : return instruction_t (TYPE_EXTEND ,OPERATION_EXTEND_L_EXTEND_S     ,ORBIS32,2);
      case INSTRUCTION_L_EXTBZ     : return instruction_t (TYPE_EXTEND ,OPERATION_EXTEND_L_EXTEND_Z     ,ORBIS32,2);
      case INSTRUCTION_L_EXTHS     : return instruction_t (TYPE_EXTEND ,OPERATION_EXTEND_L_EXTEND_S     ,ORBIS32,2);
      case INSTRUCTION_L_EXTHZ     : return instruction_t (TYPE_EXTEND ,OPERATION_EXTEND_L_EXTEND_Z     ,ORBIS32,2);
      case INSTRUCTION_L_EXTWS     : return instruction_t (TYPE_EXTEND ,OPERATION_EXTEND_L_EXTEND_S     ,ORBIS64,2);
      case INSTRUCTION_L_EXTWZ     : return instruction_t (TYPE_EXTEND ,OPERATION_EXTEND_L_EXTEND_Z     ,ORBIS64,2);
      case INSTRUCTION_L_FF1       : return instruction_t (TYPE_FIND   ,OPERATION_FIND_L_FF1            ,ORBIS32,2);
      case INSTRUCTION_L_FL1       : return instruction_t (TYPE_FIND   ,OPERATION_FIND_L_FL1            ,ORBIS32,2);
      case INSTRUCTION_L_J         : return instruction_t (TYPE_BRANCH ,OPERATION_BRANCH_NONE           ,ORBIS32,1);
      case INSTRUCTION_L_JAL       : return instruction_t (TYPE_BRANCH ,OPERATION_BRANCH_L_JALR         ,ORBIS32,1);
      case INSTRUCTION_L_JALR      : return instruction_t (TYPE_BRANCH ,OPERATION_BRANCH_L_JALR         ,ORBIS32,1);
      case INSTRUCTION_L_JR        : return instruction_t (TYPE_BRANCH ,OPERATION_BRANCH_L_JALR         ,ORBIS32,1);
      case INSTRUCTION_L_LBS       : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_8_S       ,ORBIS32,1);
      case INSTRUCTION_L_LBZ       : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_8_Z       ,ORBIS32,1);
      case INSTRUCTION_L_LD        : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_64_S      ,ORBIS64,1);
      case INSTRUCTION_L_LHS       : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_16_S      ,ORBIS32,1);
      case INSTRUCTION_L_LHZ       : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_16_Z      ,ORBIS32,1);
      case INSTRUCTION_L_LWS       : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_32_S      ,ORBIS32,1);
      case INSTRUCTION_L_LWZ       : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_LOAD_32_Z      ,ORBIS32,1);
      case INSTRUCTION_L_MAC       : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC         ,ORBIS32,2);
      case INSTRUCTION_L_MACI      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC         ,ORBIS32,2);
      case INSTRUCTION_L_MACRC     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MACRC       ,ORBIS32,2);
      case INSTRUCTION_L_MFSPR     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MFSPR       ,ORBIS32,1);
      case INSTRUCTION_L_MOVHI     : return instruction_t (TYPE_MOVE   ,OPERATION_MOVE_L_MOVHI          ,ORBIS32,1);
      case INSTRUCTION_L_MSB       : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MSB         ,ORBIS32,2);
      case INSTRUCTION_L_MSYNC     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MSYNC       ,ORBIS32,2);
      case INSTRUCTION_L_MTSPR     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_MTSPR       ,ORBIS32,1);
      case INSTRUCTION_L_MUL       : return instruction_t (TYPE_MUL    ,OPERATION_MUL_L_MUL             ,ORBIS32,1);
      case INSTRUCTION_L_MULI      : return instruction_t (TYPE_MUL    ,OPERATION_MUL_L_MUL             ,ORBIS32,1);
      case INSTRUCTION_L_MULU      : return instruction_t (TYPE_MUL    ,OPERATION_MUL_L_MULU            ,ORBIS32,1);
      case INSTRUCTION_L_NOP       : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORBIS32,1);
      case INSTRUCTION_L_OR        : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_OR              ,ORBIS32,1);
      case INSTRUCTION_L_ORI       : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_OR              ,ORBIS32,1);
      case INSTRUCTION_L_PSYNC     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_PSYNC       ,ORBIS32,2);
      case INSTRUCTION_L_RFE       : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_RFE         ,ORBIS32,1);
      case INSTRUCTION_L_ROR       : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_ROR           ,ORBIS32,2);
      case INSTRUCTION_L_RORI      : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_ROR           ,ORBIS32,2);
      case INSTRUCTION_L_SB        : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_STORE_8        ,ORBIS32,1);
      case INSTRUCTION_L_SD        : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_STORE_64       ,ORBIS64,1);
      case INSTRUCTION_L_SFEQ      : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFEQ           ,ORBIS32,1);
      case INSTRUCTION_L_SFEQI     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFEQ           ,ORBIS32,1);
      case INSTRUCTION_L_SFGES     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGES          ,ORBIS32,1);
      case INSTRUCTION_L_SFGESI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGES          ,ORBIS32,2);
      case INSTRUCTION_L_SFGEU     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGEU          ,ORBIS32,1);
      case INSTRUCTION_L_SFGEUI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGEU          ,ORBIS32,2);
      case INSTRUCTION_L_SFGTS     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGTS          ,ORBIS32,1);
      case INSTRUCTION_L_SFGTSI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGTS          ,ORBIS32,2);
      case INSTRUCTION_L_SFGTU     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGTU          ,ORBIS32,1);
      case INSTRUCTION_L_SFGTUI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFGTU          ,ORBIS32,2);
      case INSTRUCTION_L_SFLES     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLES          ,ORBIS32,1);
      case INSTRUCTION_L_SFLESI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLES          ,ORBIS32,2);
      case INSTRUCTION_L_SFLEU     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLEU          ,ORBIS32,1);
      case INSTRUCTION_L_SFLEUI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLEU          ,ORBIS32,2);
      case INSTRUCTION_L_SFLTS     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLTS          ,ORBIS32,1);
      case INSTRUCTION_L_SFLTSI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLTS          ,ORBIS32,2);
      case INSTRUCTION_L_SFLTU     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLTU          ,ORBIS32,1);
      case INSTRUCTION_L_SFLTUI    : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFLTU          ,ORBIS32,2);
      case INSTRUCTION_L_SFNE      : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFNE           ,ORBIS32,1);
      case INSTRUCTION_L_SFNEI     : return instruction_t (TYPE_TEST   ,OPERATION_TEST_L_SFNE           ,ORBIS32,2);
      case INSTRUCTION_L_SH        : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_STORE_16       ,ORBIS32,1);
      case INSTRUCTION_L_SLL       : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_SLL           ,ORBIS32,1);
      case INSTRUCTION_L_SLLI      : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_SLL           ,ORBIS32,1);
      case INSTRUCTION_L_SRA       : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_SRA           ,ORBIS32,1);
      case INSTRUCTION_L_SRAI      : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_SRA           ,ORBIS32,1);
      case INSTRUCTION_L_SRL       : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_SRL           ,ORBIS32,1);
      case INSTRUCTION_L_SRLI      : return instruction_t (TYPE_SHIFT  ,OPERATION_SHIFT_L_SRL           ,ORBIS32,1);
      case INSTRUCTION_L_SUB       : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_SUB             ,ORBIS32,1);
      case INSTRUCTION_L_SW        : return instruction_t (TYPE_MEMORY ,OPERATION_MEMORY_STORE_32       ,ORBIS32,1);
      case INSTRUCTION_L_SYS       : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_SYS         ,ORBIS32,1);
      case INSTRUCTION_L_TRAP      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_TRAP        ,ORBIS32,2);
      case INSTRUCTION_L_XOR       : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_XOR             ,ORBIS32,1);
      case INSTRUCTION_L_XORI      : return instruction_t (TYPE_ALU    ,OPERATION_ALU_L_XOR             ,ORBIS32,1);
                                                                                                                       
      case INSTRUCTION_LF_ADD_D    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_ADD_S    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_CUST1_D  : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_LF_1_D         ,ORFPX64,2);
      case INSTRUCTION_LF_CUST1_S  : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_LF_1_S         ,ORFPX32,2);
      case INSTRUCTION_LF_DIV_D    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,2);
      case INSTRUCTION_LF_DIV_S    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,2);
      case INSTRUCTION_LF_FTOI_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_FTOI_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_ITOF_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_ITOF_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_MADD_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,2);
      case INSTRUCTION_LF_MADD_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,2);
      case INSTRUCTION_LF_MUL_D    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_MUL_S    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_REM_D    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,2);
      case INSTRUCTION_LF_REM_S    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,2);
      case INSTRUCTION_LF_SFEQ_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SFEQ_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_SFGE_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SFGE_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_SFGT_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SFGT_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_SFLE_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SFLE_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_SFLT_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SFLT_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_SFNE_D   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SFNE_S   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
      case INSTRUCTION_LF_SUB_D    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX64,1);
      case INSTRUCTION_LF_SUB_S    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORFPX32,1);
                                                                                                                       
      case INSTRUCTION_LV_ADD_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADD_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADDS_B   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADDS_H   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADDU_B   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADDU_H   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADDUS_B  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ADDUS_H  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_EQ_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_EQ_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_GE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_GE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_GT_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_GT_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_LE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_LE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_LT_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_LT_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_NE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ALL_NE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_AND      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_EQ_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_EQ_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_GE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_GE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_GT_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_GT_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_LE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_LE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_LT_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_LT_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_NE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_ANY_NE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_AVG_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_AVG_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_EQ_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_EQ_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_GE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_GE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_GT_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_GT_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_LE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_LE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_LT_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_LT_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_NE_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CMP_NE_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_CUST1    : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_LV_1           ,ORVDX64,2);
      case INSTRUCTION_LV_CUST2    : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_LV_2           ,ORVDX64,2);
      case INSTRUCTION_LV_CUST3    : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_LV_3           ,ORVDX64,2);
      case INSTRUCTION_LV_CUST4    : return instruction_t (TYPE_CUSTOM ,OPERATION_CUSTOM_LV_4           ,ORVDX64,2);
      case INSTRUCTION_LV_MADDS_H  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MAX_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MAX_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MERGE_B  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MERGE_H  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MIN_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MIN_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MSUBS_H  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_MULS_H   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,2);
      case INSTRUCTION_LV_NAND     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_NOR      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_OR       : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PACK_B   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PACK_H   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PACKS_B  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PACKS_H  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PACKUS_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PACKUS_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_PERM_N   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_RL_B     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_RL_H     : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SLL      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SLL_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SLL_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SRA_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SRA_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SRL      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SRL_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SRL_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUB_B    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUB_H    : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUBS_B   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUBS_H   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUBU_B   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUBU_H   : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUBUS_B  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_SUBUS_H  : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_UNPACK_B : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_UNPACK_H : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);
      case INSTRUCTION_LV_XOR      : return instruction_t (TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP         ,ORVDX64,1);

      default                      : throw (ERRORMORPHEO (FUNCTION,_("Unknow instruction")));
      }
  };

#undef  FUNCTION
#define FUNCTION "instruction_size_data"
  uint32_t instruction_size_data (uint32_t instruction)
  {
    ISA subset = instruction_information(instruction)._isa_subset;

    switch(subset)
      {
      case ORBIS32 :
      case ORFPX32 : return 32;
      case ORBIS64 :
      case ORFPX64 :
      case ORVDX64 : return 64;
      default : throw (ERRORMORPHEO (FUNCTION,_("Unknow subset")));
      }
  }

}; // end namespace behavioural
}; // end namespace morpheo              
