#ifndef Morpheo_Debug_h
#define Morpheo_Debug_h

/*
 * $Id: Debug.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * function to help the debugging :
 *
 *  - debug_tab
 *  - log_printf
 *  - log_begin
 *  - log_end
 *  - log_function
 *  - msg_print
 *  - breakpoint
 *
 *  Debug's Level :
 *  - None    : print elementary information
 *  - Info    : print basic information
 *  - Trace   : trace internal variable
 *  - Func    : trace call and return function
 *  - All     : print all information
 */

#include "Common/include/Message.h"
#include "Behavioural/include/Debug_component.h"
#include <systemc.h>
#include <stdio.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include <string>

namespace morpheo {

enum _debug_verbosity 
  {
    DEBUG_NONE ,
    DEBUG_INFO ,
    DEBUG_TRACE,
    DEBUG_FUNC ,
    DEBUG_ALL
  };

std::string debug_tab     (void);
void        debug_tab_inc (void);
void        debug_tab_dec (void);

#ifdef DEBUG
# define log_printf(level, component, func, str... )			\
  do									\
    {									\
      if ((DEBUG == DEBUG_ALL ) or					\
	  (DEBUG_ ## level == DEBUG_NONE) or				\
	  (( DEBUG_ ## level     <= DEBUG) and				\
	   ( DEBUG_ ## component == true )) )				\
	{								\
	  if (DEBUG_ ## level <= DEBUG_INFO)				\
	    {								\
              msg("%s ",MSG_INFORMATION);                               \
	    }								\
          else                                                          \
	    {								\
              msg("%s ",MSG_DEBUG);                                     \
	    }								\
                                                                        \
	  if (DEBUG >= DEBUG_FUNC)					\
	    {								\
	      msg("%s",debug_tab().c_str());		                \
	    }								\
	  if (DEBUG >= DEBUG_ALL )					\
	    {								\
	      switch (DEBUG_ ## level)					\
		{							\
		case DEBUG_NONE  : msg(_("(none       ) ")); break;	\
		case DEBUG_INFO  : msg(_("(information) ")); break;	\
		case DEBUG_TRACE : msg(_("(trace      ) ")); break;	\
		case DEBUG_FUNC  : msg(_("(function   ) ")); break;	\
		case DEBUG_ALL   : msg(_("(all        ) ")); break;	\
		default          : msg(_("(undefine   ) ")); break;	\
		}							\
	    }								\
	  if (DEBUG >= DEBUG_FUNC)					\
	    {								\
	      msg(  "<%s> " ,func);			        	\
	      msg(_("In file %s, "),__FILE__);		        	\
	      msg(_("at line %d " ),__LINE__);		        	\
	      msg(  ": " );				        	\
	    }						        	\
	  msg(str);					        	\
	  msg("\n");					        	\
	}								\
    } while(0)

# define log_begin(component, func)					\
  do									\
    {									\
      debug_tab_inc ();							\
      log_printf(FUNC,component,func,_("Begin"));                       \
    } while(0)

# define log_end(component, func)					\
  do									\
    {									\
      log_printf(FUNC,component,func,_("End"));				\
      debug_tab_dec ();							\
    } while(0)

#else
# define log_printf(level, component, func, str... )			\
  do									\
    {									\
    } while(0)

# define log_begin(component, func)					\
  do									\
    {									\
    } while(0)

# define log_end(component, func)					\
  do									\
    {									\
    } while(0)

#endif // DEBUG

# define log_function(component,func,name)                              \
  do									\
    {									\
      log_printf(TRACE,component,func,_("[%d] %s.%s"),static_cast<uint32_t>(sc_simulation_time()),name,func); \
    } while(0)


#define msg_printf(type,str...)                                         \
  do                                                                    \
    {                                                                   \
      msg("%s ",MSG_ ## type);                                          \
      msg(str);								\
      msg("\n");							\
    } while(0)


#define breakpoint(str...)						\
  do									\
    {									\
      fprintf(stdout,_("%s "),MSG_BREAKPOINT);                                     \
      fprintf(stdout,_("Breakpoint in file %s, line %d.\n"),__FILE__,__LINE__);    \
      fprintf(stdout,_("%s "),MSG_NONE);                                           \
      fprintf(stdout,str);								\
      fprintf(stdout,_("\n"));                                                     \
      fprintf(stdout,_("%s "),MSG_NONE);                                           \
      fprintf(stdout,_("Enter any key to continue\n"));                            \
      getchar();							\
    } while(0)

#ifdef DEBUG_TEST
#define TEST_PTR(x)							\
  do									\
    {									\
      if (x == NULL)							\
	err(_("File %s, Line %d, this pointeur is null\n"),__FILE__,__LINE__); \
    }									\
  while (0)
#else
#define TEST_PTR(x)	 \
  do			 \
    {			 \
    }			 \
  while (0)
#endif

}; // end namespace morpheo
#endif // !DEBUG_H
