#ifdef LOG_FILE
/*
 * $Id: Message.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Common/include/Environment.h"
#include "Common/include/ToString.h"
#include "Common/include/ErrorMorpheo.h"
#include <sys/types.h>
#include <unistd.h>

namespace morpheo {

static bool log_initialized;
FILE * log_stream;

#undef  FUNCTION
#define FUNCTION "log_init"
void log_init (void)
{
  if (not log_initialized)
    {
      log_initialized = true;

      directory();
      
      std::string filename = MORPHEO_LOG+"/Morpheo_"+toString<pid_t>(getpid())+".log";

      log_stream = fopen (filename.c_str(), "w");

      if (log_stream==NULL)
        {
          fprintf(stderr,_("%s Error create log file \"%s\", take the standard output.\n"),MSG_ERROR,filename.c_str());
          log_stream = stdout;
        }
      else
        {
          fprintf(stdout,_("%s Create log file \"%s\".\n"),MSG_INFORMATION,filename.c_str());
        }
    }
}

}; // end namespace morpheo
#endif
