#include "func_mm.h"

void mm_algo1 ( unsigned int    size_matrix 
	       ,unsigned int ** matrix_a
	       ,unsigned int ** matrix_b
	       ,unsigned int ** matrix_d)
{
  unsigned int index_i, index_j, index_k;
 
  for (index_i = 0; index_i < size_matrix; index_i ++)
    for (index_j = 0; index_j < size_matrix; index_j ++)
      {
	matrix_d [index_i][index_j] = 0;
	
	for (index_k = 0; index_k < size_matrix; index_k ++)
	  matrix_d [index_i][index_j] += matrix_a[index_i][index_k] * matrix_b[index_k][index_j];
      }
}

int mm(unsigned int size_matrix, unsigned int algo)
{
  unsigned int matrix_a [size_matrix][size_matrix];
  unsigned int matrix_b [size_matrix][size_matrix];
  unsigned int matrix_d [size_matrix][size_matrix];
  unsigned int sum , sum_ok;
  unsigned int index_i, index_j;
  
  /*
   * PHASE 1 : Initialisation
   */

  /* Flush matrix_d */
  for (index_i = 0; index_i < size_matrix; index_i ++)
    for (index_j = 0; index_j < size_matrix; index_j ++)
      {
	matrix_a [index_i][index_j] = index_i+1;
	matrix_b [index_i][index_j] = index_i+1;
	matrix_d [index_i][index_j] = 0;
      }

  sum = (size_matrix*(size_matrix+1))>>1;
  /*
        sum = (N*(N+1))/2;
    ici sum = (4*5)/2 = 10

              ( 1  1  1  1  )
              ( 2  2  2  2  )
	      ( 3  3  3  3  )
	      ( 4  4  4  4  )
    ( 1 1 1 1 ) 10 10 10 10 -> 1*sum
    ( 2 2 2 2 ) 20 20 20 20 -> 2*sum
    ( 3 3 3 3 ) 30 30 30 30 -> 3*sum
    ( 4 4 4 4 ) 40 40 40 40 -> 4*sum
  */

  /*
   * PHASE 2 : Execution
   */

  switch (algo)
    {
    case 1 :
      {
	/* mthode classique */

	unsigned int index_i, index_j, index_k;
	
	for (index_i=0;index_i<size_matrix;index_i++)
	  for (index_j=0;index_j<size_matrix;index_j++)
	    {
	      matrix_d [index_i][index_j] = 0;
	      
	      for (index_k=0;index_k<size_matrix;index_k++)
		matrix_d [index_i][index_j] += matrix_a[index_i][index_k] * matrix_b[index_k][index_j];
	    }

	//mm_algo1(size_matrix, matrix_a, matrix_b, matrix_d);
	break;
      }
    default :break;
    }/* end switch algo */
  
  /*
   * PHASE 3 : Test
   */

  sum_ok = 0;

  for (index_i=0;index_i<size_matrix;index_i++)
    {
      unsigned int row_sum = (index_i+1)*sum;

      for (index_j=0;index_j<size_matrix;index_j++)
	if ((matrix_a[index_i][index_j] == index_i+1) &&
	    (matrix_b[index_i][index_j] == index_i+1) &&
	    (matrix_d[index_i][index_j] == row_sum)
	    )
	  sum_ok ++;
    }
  
  return (sum_ok == (size_matrix * size_matrix) );
}
