#ifndef morpheo_Type
#define morpheo_Type

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>

namespace morpheo              {

#ifdef SYSTEMC

// Definition of type
#if ( defined(SC_CLOCK) || defined(SC_INTERNAL) || defined(SC_SIGNAL) || defined(SC_REGISTER) || defined(SC_IN) || defined(SC_OUT) )
#  error "A type is already defined"
#endif

#if ( defined(PORT_READ)     || defined(PORT_WRITE)     )
#  error "Action is already defined"
#endif
#if ( defined(INTERNAL_READ) || defined(INTERNAL_WRITE) )
#  error "Action is already defined"
#endif
#if ( defined(SIGNAL_READ)   || defined(SIGNAL_WRITE) )
#  error "Action is already defined"
#endif
#if ( defined(REGISTER_READ) || defined(REGISTER_WRITE) )
#  error "Action is already defined"
#endif

#define SC_CLOCK                 sc_in_clk       
#define SC_INTERNAL(type)        type
#define SC_SIGNAL(type)          sc_signal<type >
#define SC_REGISTER(type)        sc_signal<type >
#define SC_IN(type)              sc_in    <type >
#define SC_OUT(type)             sc_out   <type >
			         
#define PORT_READ(sig)           sig->read()
#define PORT_WRITE(sig,val)      sig->write(val)
#define INTERNAL_READ(sig)       (*sig)
#define INTERNAL_WRITE(sig,val)  (*sig) = val
#define SIGNAL_READ(sig)         sig->read()
#define SIGNAL_WRITE(sig,val)    sig->write(val)
#define REGISTER_READ(sig)       sig->read()
#define REGISTER_WRITE(sig,val)  sig->write(val)

#endif  
}; // end namespace morpheo              

#endif
