/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::Parameters"
  Parameters::Parameters (uint32_t   nb_context,
			  uint32_t   nb_decod_unit,
			  uint32_t   nb_inst_branch_complete,
			  uint32_t * size_depth,                
			  uint32_t   size_address,
			  uint32_t * size_nb_inst_decod,           
			  uint32_t   size_nb_inst_commit,          
			  uint32_t * link_context_to_decod_unit,
                          bool       is_toplevel)
  {
    log_begin(Context_State,FUNCTION);

    _nb_context                    = nb_context                   ;
    _nb_decod_unit                 = nb_decod_unit                ;
    _nb_inst_branch_complete       = nb_inst_branch_complete      ;
    _array_size_depth              = size_depth                   ;
//  _size_address                  = size_address                 ;
//  _size_nb_inst_decod            = size_nb_inst_decod           ;
//  _size_nb_inst_commit           = size_nb_inst_commit          ;
    _link_context_to_decod_unit    = link_context_to_decod_unit   ;

    test();

    if (is_toplevel)
      {
        _size_context_id               = log2(_nb_context);
        _size_depth                    = log2(max<uint32_t>(size_depth,_nb_context));
        _size_instruction_address      = size_address;
        _size_nb_inst_decod            = max<uint32_t>(size_nb_inst_decod,_nb_decod_unit);
        _size_nb_inst_commit           = size_nb_inst_commit;

        _have_port_context_id          = (_size_context_id>0);
        _have_port_depth               = (_size_depth > 0);

        copy ();
      }
    
    log_end(Context_State,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Context_State::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Context_State,FUNCTION);
//     test();
//     log_end(Context_State,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Context_State::~Parameters"
  Parameters::~Parameters () 
  {
    log_begin(Context_State,FUNCTION);
    log_end(Context_State,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Context_State::copy"
  void Parameters::copy (void) 
  {
    log_begin(Context_State,FUNCTION);
    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
