/*
 * $Id: Interface_get_signal.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"


namespace morpheo              {
namespace behavioural          {

  std::string Interface::get_signal (void)
  {
    log_printf(FUNC,Behavioural,"get_signal","Begin");

    uint32_t               depth          = 0;
    std::string                 separator      = ",\n";
    bool                   last_separator = false;


    std::list<Signal*>::iterator i    = _list_signal->begin();
    bool                         empty = _list_signal->empty();

    std::string                 tab   = std::string(depth,'\t');
    std::ostringstream          text;

    if (not empty)
      {
	// First
	if (i != _list_signal->end())
	  {
	    text << tab << **i;
	    ++i;
	  }
	
	while (i != _list_signal->end())
	  {
	    text << separator;
	    text << tab << **i;
	    ++i;
	  }
	if (last_separator)
	  text << separator;
      }

    log_printf(FUNC,Behavioural,"get_signal","End");

    return text.str();
  };

#ifdef VHDL
#  ifdef VHDL_TESTBENCH

#undef  FUNCTION
#define FUNCTION "Interface::get_signal"
  void Interface::get_signal (std::list<std::string> * & list_signal)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    if (not _list_signal->empty())
      {
	std::list<Signal*>::iterator i = _list_signal->begin();
	
	while (i != _list_signal->end())
	  {
	    (*i)->get_name_vhdl (list_signal);
	    ++i;
	  }
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
#  endif
#endif

#undef  FUNCTION
#define FUNCTION "Interface::get_signal_list"
  std::list<Signal *> * Interface::get_signal_list (void)
    {
      log_printf(FUNC,Behavioural,FUNCTION,"Begin");
      std::list<Signal *> * _return = _list_signal;
      log_printf(FUNC,Behavioural,FUNCTION,"End");

      return _return;
    }

}; // end namespace behavioural          
}; // end namespace morpheo              
