/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  256
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_translation_unit_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Register_translation_unit_Glue * _Register_translation_unit_Glue = new Register_translation_unit_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_VAL    ," in_INSERT_RENAME_VAL    ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RENAME_ACK    ,"out_INSERT_RENAME_ACK    ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_INSERT_VAL    ,"out_INSERT_INSERT_VAL    ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_INSERT_ACK    ," in_INSERT_INSERT_ACK    ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RAT_INSERT_VAL,"out_INSERT_RAT_INSERT_VAL",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RAT_RENAME_ACK," in_INSERT_RAT_RENAME_ACK",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RAT_INSERT_ACK," in_INSERT_RAT_INSERT_ACK",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_FREE_LIST_VAL ,"out_INSERT_FREE_LIST_VAL ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_FREE_LIST_ACK ," in_INSERT_FREE_LIST_ACK ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_VAL ,"out_INSERT_STAT_LIST_VAL ",Tcontrol_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_STAT_LIST_ACK ," in_INSERT_STAT_LIST_ACK ",Tcontrol_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_READ_RA           ," in_INSERT_DEPENDENCY_CHECKING_READ_RA           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY    ," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_READ_RB           ," in_INSERT_DEPENDENCY_CHECKING_READ_RB           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY    ," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_READ_RC           ," in_INSERT_DEPENDENCY_CHECKING_READ_RC           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY    ," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_WRITE_RD          ," in_INSERT_DEPENDENCY_CHECKING_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG    ," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_WRITE_RE          ," in_INSERT_DEPENDENCY_CHECKING_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG    ," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW," in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_READ_RA                     ,"out_INSERT_STAT_LIST_READ_RA                     ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RA_PHY              ,"out_INSERT_STAT_LIST_NUM_REG_RA_PHY              ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_READ_RB                     ,"out_INSERT_STAT_LIST_READ_RB                     ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RB_PHY              ,"out_INSERT_STAT_LIST_NUM_REG_RB_PHY              ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_READ_RC                     ,"out_INSERT_STAT_LIST_READ_RC                     ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RC_PHY              ,"out_INSERT_STAT_LIST_NUM_REG_RC_PHY              ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_WRITE_RD                    ,"out_INSERT_STAT_LIST_WRITE_RD                    ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW          ,"out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW          ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_WRITE_RE                    ,"out_INSERT_STAT_LIST_WRITE_RE                    ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW          ,"out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW          ",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL(out_INSERT_RAT_WRITE_RD                          ,"out_INSERT_RAT_WRITE_RD                          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RD_LOG                    ,"out_INSERT_RAT_NUM_REG_RD_LOG                    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RD_PHY_NEW                ,"out_INSERT_RAT_NUM_REG_RD_PHY_NEW                ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RAT_WRITE_RE                          ,"out_INSERT_RAT_WRITE_RE                          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RE_LOG                    ,"out_INSERT_RAT_NUM_REG_RE_LOG                    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RE_PHY_NEW                ,"out_INSERT_RAT_NUM_REG_RE_PHY_NEW                ",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL(out_INSERT_READ_RA                               ,"out_INSERT_READ_RA                               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RA_PHY                        ,"out_INSERT_NUM_REG_RA_PHY                        ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RB                               ,"out_INSERT_READ_RB                               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RB_PHY                        ,"out_INSERT_NUM_REG_RB_PHY                        ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RC                               ,"out_INSERT_READ_RC                               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RC_PHY                        ,"out_INSERT_NUM_REG_RC_PHY                        ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_WRITE_RD                              ,"out_INSERT_WRITE_RD                              ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_LOG                        ,"out_INSERT_NUM_REG_RD_LOG                        ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_OLD                    ,"out_INSERT_NUM_REG_RD_PHY_OLD                    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_NEW                    ,"out_INSERT_NUM_REG_RD_PHY_NEW                    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_WRITE_RE                              ,"out_INSERT_WRITE_RE                              ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_LOG                        ,"out_INSERT_NUM_REG_RE_LOG                        ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_OLD                    ,"out_INSERT_NUM_REG_RE_PHY_OLD                    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW                    ,"out_INSERT_NUM_REG_RE_PHY_NEW                    ",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL( in_RETIRE_VAL           ," in_RETIRE_VAL           ",Tcontrol_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK           ,"out_RETIRE_ACK           ",Tcontrol_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_RAT_VAL       ,"out_RETIRE_RAT_VAL       ",Tcontrol_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_RAT_ACK       ," in_RETIRE_RAT_ACK       ",Tcontrol_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_STAT_LIST_VAL ,"out_RETIRE_STAT_LIST_VAL ",Tcontrol_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_STAT_LIST_ACK ," in_RETIRE_STAT_LIST_ACK ",Tcontrol_t,_param->_nb_inst_retire);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Register_translation_unit_Glue.\n"),name.c_str());

  (*(_Register_translation_unit_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Register_translation_unit_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_RENAME_VAL    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RENAME_ACK    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_INSERT_VAL    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_INSERT_ACK    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_INSERT_VAL,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_RAT_RENAME_ACK,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_RAT_INSERT_ACK,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_FREE_LIST_VAL ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_FREE_LIST_ACK ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_VAL ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_STAT_LIST_ACK ,_param->_nb_inst_insert);
  
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_READ_RA           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_READ_RB           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_READ_RC           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_WRITE_RD          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_WRITE_RE          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_READ_RA                     ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_NUM_REG_RA_PHY              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_READ_RB                     ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_NUM_REG_RB_PHY              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_READ_RC                     ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_NUM_REG_RC_PHY              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_WRITE_RD                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_WRITE_RE                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW          ,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_WRITE_RD                          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_NUM_REG_RD_LOG                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_NUM_REG_RD_PHY_NEW                ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_WRITE_RE                          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_NUM_REG_RE_LOG                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_RAT_NUM_REG_RE_PHY_NEW                ,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_READ_RA                               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RA_PHY                        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_READ_RB                               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RB_PHY                        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_READ_RC                               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RC_PHY                        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_WRITE_RD                              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RD_LOG                        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RD_PHY_OLD                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RD_PHY_NEW                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_WRITE_RE                              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RE_LOG                        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RE_PHY_OLD                    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_INSERT_NUM_REG_RE_PHY_NEW                    ,_param->_nb_inst_insert);
  
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_RETIRE_VAL          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_RETIRE_ACK          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_RETIRE_RAT_VAL      ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_RETIRE_RAT_ACK      ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue,out_RETIRE_STAT_LIST_VAL,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit_Glue, in_RETIRE_STAT_LIST_ACK,_param->_nb_inst_retire);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_inst_insert;i++)
	{
	  in_INSERT_RENAME_VAL    [i]->write(rand()%2);
	  in_INSERT_INSERT_ACK    [i]->write(rand()%2);
	  in_INSERT_RAT_RENAME_ACK[i]->write(rand()%2);
	  in_INSERT_RAT_INSERT_ACK[i]->write(rand()%2);
	  in_INSERT_FREE_LIST_ACK [i]->write(rand()%2);
	  in_INSERT_STAT_LIST_ACK [i]->write(rand()%2);
	}
      
      for (uint32_t i=0; i<_param->_nb_inst_retire;i++)
	{
	  in_RETIRE_VAL           [i]->write(rand()%2);
	  in_RETIRE_RAT_ACK       [i]->write(rand()%2);
	  in_RETIRE_STAT_LIST_ACK [i]->write(rand()%2);
	}

      SC_START(0);

      for (uint32_t i=0; i<_param->_nb_inst_insert;i++)
	{
	  TEST(Tcontrol_t,out_INSERT_RENAME_ACK     [i]->read(),(in_INSERT_INSERT_ACK     [i]->read() and
								 in_INSERT_RAT_RENAME_ACK [i]->read() and
								 in_INSERT_RAT_INSERT_ACK [i]->read() and
								 in_INSERT_FREE_LIST_ACK  [i]->read() and
								 in_INSERT_STAT_LIST_ACK  [i]->read() ));
	  TEST(Tcontrol_t,out_INSERT_INSERT_VAL     [i]->read(),(in_INSERT_RENAME_VAL     [i]->read() and
								 in_INSERT_RAT_RENAME_ACK [i]->read() and
								 in_INSERT_RAT_INSERT_ACK [i]->read() and
								 in_INSERT_FREE_LIST_ACK  [i]->read() and
								 in_INSERT_STAT_LIST_ACK  [i]->read() ));
	  TEST(Tcontrol_t,out_INSERT_RAT_INSERT_VAL [i]->read(),(in_INSERT_RENAME_VAL     [i]->read() and
								 in_INSERT_INSERT_ACK     [i]->read() and
								 in_INSERT_RAT_RENAME_ACK [i]->read() and
								 in_INSERT_FREE_LIST_ACK  [i]->read() and
								 in_INSERT_STAT_LIST_ACK  [i]->read() ));
	  TEST(Tcontrol_t,out_INSERT_FREE_LIST_VAL  [i]->read(),(in_INSERT_RENAME_VAL     [i]->read() and
								 in_INSERT_INSERT_ACK     [i]->read() and
								 in_INSERT_RAT_RENAME_ACK [i]->read() and
								 in_INSERT_RAT_INSERT_ACK [i]->read() and
								 in_INSERT_STAT_LIST_ACK  [i]->read() ));
	  TEST(Tcontrol_t,out_INSERT_STAT_LIST_VAL  [i]->read(),(in_INSERT_RENAME_VAL     [i]->read() and
								 in_INSERT_INSERT_ACK     [i]->read() and
								 in_INSERT_RAT_RENAME_ACK [i]->read() and
								 in_INSERT_RAT_INSERT_ACK [i]->read() and
								 in_INSERT_FREE_LIST_ACK  [i]->read() ));
	}
      
      for (uint32_t i=0; i<_param->_nb_inst_retire;i++)
	{
	  TEST(Tcontrol_t,out_RETIRE_ACK           [i]->read(),(in_RETIRE_RAT_ACK       [i]->read() and
								in_RETIRE_STAT_LIST_ACK [i]->read()));
	  TEST(Tcontrol_t,out_RETIRE_RAT_VAL       [i]->read(),(in_RETIRE_VAL           [i]->read() and
								in_RETIRE_STAT_LIST_ACK [i]->read()));
	  TEST(Tcontrol_t,out_RETIRE_STAT_LIST_VAL [i]->read(),(in_RETIRE_VAL           [i]->read() and
								in_RETIRE_RAT_ACK       [i]->read()));
	}

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_INSERT_RENAME_VAL    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RENAME_ACK    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_INSERT_VAL    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_INSERT_ACK    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RAT_INSERT_VAL,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RAT_RENAME_ACK,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RAT_INSERT_ACK,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_FREE_LIST_VAL ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_FREE_LIST_ACK ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_VAL ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_STAT_LIST_ACK ,_param->_nb_inst_insert);
  
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_READ_RA           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_READ_RB           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_READ_RC           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_WRITE_RD          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_WRITE_RE          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW,_param->_nb_inst_insert);

  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_READ_RA                     ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RA_PHY              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_READ_RB                     ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RB_PHY              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_READ_RC                     ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RC_PHY              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_WRITE_RD                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_WRITE_RE                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW          ,_param->_nb_inst_insert);

  DELETE1_SC_SIGNAL(out_INSERT_RAT_WRITE_RD                          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RD_LOG                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RD_PHY_NEW                ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RAT_WRITE_RE                          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RE_LOG                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RAT_NUM_REG_RE_PHY_NEW                ,_param->_nb_inst_insert);

  DELETE1_SC_SIGNAL(out_INSERT_READ_RA                               ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RA_PHY                        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_READ_RB                               ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RB_PHY                        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_READ_RC                               ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RC_PHY                        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_WRITE_RD                              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RD_LOG                        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_OLD                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_NEW                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_WRITE_RE                              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_LOG                        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_OLD                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW                    ,_param->_nb_inst_insert);
  
  DELETE1_SC_SIGNAL( in_RETIRE_VAL          ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_ACK          ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_RAT_VAL      ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_RAT_ACK      ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_STAT_LIST_VAL,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_STAT_LIST_ACK,_param->_nb_inst_retire);

#endif

  delete _Register_translation_unit_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
