#ifdef VHDL

/*
 * $Id: Vhdl_generate_file_model.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Environment.h"
#include <sstream>
#include <fstream>

namespace morpheo              {
namespace behavioural          {

  void Vhdl::generate_file_model(void)
  {
    log_printf(FUNC,Behavioural,"generate_file_model","Begin");

    directory();

    std::string filename = MORPHEO_VHDL + "/" + _name + ".vhdl";
    
    msg_printf(INFORMATION,_("Generate file \"%s\"."),filename.c_str());

    log_printf(TRACE,Behavioural,"generate_file_model","declaration");
    std::ofstream file;

    log_printf(TRACE,Behavioural,"generate_file_model","open file");
    file.open(filename.c_str(),std::ios::out | std::ios::trunc);

    log_printf(TRACE,Behavioural,"generate_file_model","get model");
    file << get_model (0,filename,_name,"behavioural");
    file.close();

    log_printf(FUNC,Behavioural,"generate_file_model","End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
