/*
 * $Id: Context_State_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {



#undef  FUNCTION
#define FUNCTION "Context_State::allocation"
  void Context_State::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Context_State,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Context_State"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_event", IN,SOUTH, "branch_event", _param->_nb_context);
      
      ALLOC1_VALACK_IN ( in_BRANCH_EVENT_VAL                   ,VAL);
      ALLOC1_VALACK_OUT(out_BRANCH_EVENT_ACK                   ,ACK);
//    ALLOC1_SIGNAL_IN ( in_BRANCH_EVENT_CONTEXT_ID            ,"context_id"             ,Tcontext_t         ,_param->_size_context_id);
//    ALLOC1_SIGNAL_IN ( in_BRANCH_EVENT_DEPTH                 ,"depth"                  ,Tdepth_t           ,_param->_size_depth);
//    ALLOC1_SIGNAL_IN ( in_BRANCH_EVENT_MISS_PREDICTION       ,"miss_prediction"        ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_BRANCH_EVENT_ADDRESS_SRC           ,"address_src"            ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_BRANCH_EVENT_ADDRESS_DEST          ,"address_dest"           ,Taddress_t         ,_param->_size_instruction_address);
    }

    // ~~~~~[ Interface : "decod_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("decod_event",IN ,SOUTH, _("Decod Interface"), _param->_nb_decod_unit);

      ALLOC1_VALACK_IN ( in_DECOD_EVENT_VAL                    ,VAL);
      ALLOC1_VALACK_OUT(out_DECOD_EVENT_ACK                    ,ACK);
      ALLOC1_SIGNAL_IN ( in_DECOD_EVENT_CONTEXT_ID             ,"context_id"             ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_DECOD_EVENT_DEPTH                  ,"depth"                  ,Tdepth_t           ,_param->_size_depth);
      ALLOC1_SIGNAL_IN ( in_DECOD_EVENT_TYPE                   ,"type"                   ,Tevent_type_t      ,_param->_size_event_type);
      ALLOC1_SIGNAL_IN ( in_DECOD_EVENT_IS_DELAY_SLOT          ,"is_delay_slot"          ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_EVENT_ADDRESS                ,"address"                ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_DECOD_EVENT_ADDRESS_EPCR           ,"address_epcr"           ,Taddress_t         ,_param->_size_instruction_address);
    }

    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("commit_event",IN ,EAST, _("Interface with the Re Order Buffer"));

      ALLOC_VALACK_IN  ( in_COMMIT_EVENT_VAL                   ,VAL);
      ALLOC_VALACK_OUT (out_COMMIT_EVENT_ACK                   ,ACK);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_CONTEXT_ID            ,"context_id"      ,Tcontext_t         ,_param->_size_context_id);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_DEPTH                 ,"depth"           ,Tdepth_t           ,_param->_size_depth);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_TYPE                  ,"type"            ,Tevent_type_t      ,_param->_size_event_type);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_IS_DELAY_SLOT         ,"is_delay_slot"   ,Tcontrol_t         ,1);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_ADDRESS               ,"address"         ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_ADDRESS_EPCR          ,"address_epcr"    ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_ADDRESS_EEAR_VAL      ,"address_eear_val",Tcontrol_t         ,1);
      ALLOC_SIGNAL_IN  ( in_COMMIT_EVENT_ADDRESS_EEAR          ,"address_eear"    ,Taddress_t         ,_param->_size_instruction_address);
    }

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_complete",IN ,NORTH, _("Interface with the prediction_unit."), _param->_nb_inst_branch_complete);

      ALLOC1_VALACK_IN ( in_BRANCH_COMPLETE_VAL                ,VAL);
      ALLOC1_VALACK_OUT(out_BRANCH_COMPLETE_ACK                ,ACK);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_CONTEXT_ID         ,"context_id"     ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_DEPTH              ,"depth"          ,Tdepth_t           ,_param->_size_depth);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_MISS_PREDICTION    ,"miss_prediction",Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_TAKE               ,"take"           ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_ADDRESS_SRC        ,"address_src"    ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_ADDRESS_DEST       ,"address_dest"   ,Taddress_t         ,_param->_size_instruction_address);
    }

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("nb_inst",IN ,EAST, _("Interface to count in fligt present instruction."),_param->_nb_context);

      ALLOC1_SIGNAL_IN ( in_NB_INST_DECOD_ALL                  ,"decod_all" ,Tcounter_t         ,_param->_size_nb_inst_decod);
      ALLOC1_SIGNAL_IN ( in_NB_INST_COMMIT_ALL                 ,"commit_all",Tcounter_t         ,_param->_size_nb_inst_commit);
      ALLOC1_SIGNAL_IN ( in_NB_INST_COMMIT_MEM                 ,"commit_mem",Tcounter_t         ,_param->_size_nb_inst_commit);
    }

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("event",OUT,WEST, _("An event occure : change PC address."), _param->_nb_context);
      
      ALLOC1_VALACK_OUT(out_EVENT_VAL                          ,VAL);
      ALLOC1_VALACK_IN ( in_EVENT_ACK                          ,ACK);
      ALLOC1_SIGNAL_OUT(out_EVENT_ADDRESS                      ,"address"         ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_EVENT_ADDRESS_NEXT                 ,"address_next"    ,Taddress_t        ,_param->_size_instruction_address); 
      ALLOC1_SIGNAL_OUT(out_EVENT_ADDRESS_NEXT_VAL             ,"address_next_val",Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_EVENT_IS_DS_TAKE                   ,"is_ds_take"      ,Tcontrol_t        ,1);
    }

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("spr_event",OUT,WEST, _("An exception occure : write \"exception PC\"."), _param->_nb_context);

      ALLOC1_VALACK_OUT(out_SPR_EVENT_VAL                      ,VAL);
      ALLOC1_VALACK_IN ( in_SPR_EVENT_ACK                      ,ACK);
      ALLOC1_SIGNAL_OUT(out_SPR_EVENT_EPCR                     ,"epcr"     ,Taddress_t, _param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_SPR_EVENT_EEAR                     ,"eear"     ,Taddress_t, _param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_SPR_EVENT_EEAR_WEN                 ,"eear_wen" ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_SPR_EVENT_SR_DSX                   ,"sr_dsx"   ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_SPR_EVENT_SR_TO_ESR                ,"sr_to_esr",Tcontrol_t,1);
    }

    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("context",OUT,SOUTH, _("To decod."), _param->_nb_context);
      
      ALLOC1_SIGNAL_OUT(out_CONTEXT_DECOD_ENABLE               ,"decod_enable",Tcontrol_t,1);
    }

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("depth",IN ,NORTH, _("From prediction_unit."), _param->_nb_context);
      
      ALLOC1_SIGNAL_IN ( in_DEPTH_MIN                          ,"min" ,Tdepth_t,_param->_size_depth);
    }


    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
    {
      ALLOC1_INTERFACE("spr",IN,EAST,_("Interface with the special registerFile"),_param->_nb_context);
      
      ALLOC1_SIGNAL_IN ( in_SPR_SR_IEE                         ,"SR_IEE",Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_SPR_SR_EPH                         ,"SR_EPH",Tcontrol_t,1);
    }

    // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("interrupt",IN,NORTH,_("Interrupt Exception"),_param->_nb_context);

      ALLOC1_SIGNAL_IN ( in_INTERRUPT_ENABLE                   ,"ENABLE",Tcontrol_t,1);
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
     // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
        
     reg_STATE                  = new context_state_t [_param->_nb_context];
     reg_EVENT_ADDRESS          = new Taddress_t      [_param->_nb_context];
     reg_EVENT_ADDRESS_EPCR     = new Taddress_t      [_param->_nb_context]; 
     reg_EVENT_ADDRESS_EPCR_VAL = new Tcontrol_t      [_param->_nb_context];
     reg_EVENT_ADDRESS_EEAR     = new Taddress_t      [_param->_nb_context]; 
     reg_EVENT_ADDRESS_EEAR_VAL = new Tcontrol_t      [_param->_nb_context];
     reg_EVENT_IS_DELAY_SLOT    = new Tcontrol_t      [_param->_nb_context];
     reg_EVENT_IS_DS_TAKE       = new Tcontrol_t      [_param->_nb_context];
     reg_EVENT_DEPTH            = new Tdepth_t        [_param->_nb_context];
     reg_INTERRUPT_ENABLE       = new Tcontrol_t      [_param->_nb_context];
        
     // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     internal_BRANCH_EVENT_ACK    = new Tcontrol_t [_param->_nb_context];
     internal_DECOD_EVENT_ACK     = new Tcontrol_t [_param->_nb_decod_unit];
     internal_BRANCH_COMPLETE_ACK = new Tcontrol_t [_param->_nb_inst_branch_complete];
     internal_EVENT_VAL           = new Tcontrol_t [_param->_nb_context];
     internal_SPR_EVENT_VAL       = new Tcontrol_t [_param->_nb_context];
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
