/*
 * $Id: Return_Address_Stack_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {

#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::allocation"
  void Return_Address_Stack::allocation (
#ifdef STATISTICS
                                         morpheo::behavioural::Parameters_Statistics * param_statistics
#else
                                         void
#endif
                                         )
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Return_Address_Stack"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict", IN, SOUTH, "predict's interface", _param->_nb_inst_predict);

      ALLOC1_VALACK_IN ( in_PREDICT_VAL         ,VAL);
      ALLOC1_VALACK_OUT(out_PREDICT_ACK         ,ACK);
      ALLOC1_SIGNAL_IN ( in_PREDICT_CONTEXT_ID  ,"context_id"  ,Tcontext_t,_param->_size_context_id); 
      ALLOC1_SIGNAL_OUT(out_PREDICT_HIT         ,"hit"         ,Tcontrol_t,1); 
      ALLOC1_SIGNAL_IN ( in_PREDICT_PUSH        ,"push"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_ADDRESS_PUSH,"address_push",Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_POP ,"address_pop" ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_PREDICT_INDEX       ,"index"       ,Tptr_t    ,_param->_size_index);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("decod", IN, SOUTH, "decod's interface", _param->_nb_inst_decod);

      ALLOC1_VALACK_IN ( in_DECOD_VAL            ,VAL);
      ALLOC1_VALACK_OUT(out_DECOD_ACK            ,ACK);
      ALLOC1_SIGNAL_IN ( in_DECOD_CONTEXT_ID     ,"context_id"     ,Tcontext_t,_param->_size_context_id); 
      ALLOC1_SIGNAL_OUT(out_DECOD_HIT            ,"hit"            ,Tcontrol_t,1); 
      ALLOC1_SIGNAL_IN ( in_DECOD_PUSH           ,"push"           ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_ADDRESS_PUSH   ,"address_push"   ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_DECOD_ADDRESS_POP    ,"address_pop"    ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_DECOD_INDEX          ,"index"          ,Tptr_t    ,_param->_size_index);
      ALLOC1_SIGNAL_IN ( in_DECOD_MISS_PREDICTION,"miss_prediction",Tcontrol_t,1);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("update", IN, SOUTH, "update's interface", _param->_nb_inst_update);

      ALLOC1_VALACK_IN ( in_UPDATE_VAL              ,VAL);
      ALLOC1_VALACK_OUT(out_UPDATE_ACK              ,ACK);
      ALLOC1_SIGNAL_IN ( in_UPDATE_CONTEXT_ID       ,"context_id"       ,Tcontext_t,_param->_size_context_id); 
      ALLOC1_SIGNAL_IN ( in_UPDATE_PUSH             ,"push"             ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS          ,"address"          ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_UPDATE_INDEX            ,"index"            ,Tptr_t    ,_param->_size_index);
      ALLOC1_SIGNAL_IN ( in_UPDATE_MISS_PREDICTION  ,"miss_prediction"  ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_PREDICTION_IFETCH,"prediction_ifetch",Tcontrol_t,1);
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    reg_stack = new ras_entry_t * [_param->_nb_context];
    for (uint32_t i=0; i<_param->_nb_context; i++)
      reg_stack [i] = new ras_entry_t [_param->_size_queue [i]];

    reg_TOP              = new Tptr_t     [_param->_nb_context];
    reg_BOTTOM           = new Tptr_t     [_param->_nb_context];
    reg_NB_ELT           = new Tptr_t     [_param->_nb_context];

    reg_PREDICT_TOP      = new Tptr_t     [_param->_nb_context];
    reg_PREDICT_BOTTOM   = new Tptr_t     [_param->_nb_context];
    reg_PREDICT_NB_ELT   = new Tptr_t     [_param->_nb_context];

    internal_PREDICT_ACK = new Tcontrol_t [_param->_nb_inst_predict];
    internal_PREDICT_HIT = new Tcontrol_t [_param->_nb_inst_predict];
    internal_DECOD_ACK   = new Tcontrol_t [_param->_nb_inst_decod  ];
    internal_DECOD_HIT   = new Tcontrol_t [_param->_nb_inst_decod  ];
    internal_UPDATE_ACK  = new Tcontrol_t [_param->_nb_inst_update ];
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
