/*
 * $id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  8
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

typedef struct
{
  uint32_t            ufpt_ptr    ;
  uint32_t            upt_ptr     ;

  Tcontext_t          context     ;
  Taddress_t          address_src ;
  Taddress_t          address_dest;
  Taddress_t          address_good;
  Tbranch_condition_t condition   ;
  Tcontrol_t          take        ;
  Tcontrol_t          take_good   ;
  Tcontrol_t          flag        ;
  Tcontrol_t          is_accurate ;
  Thistory_t          history     ;
  Taddress_t          ras_address ;
  Tptr_t              ras_index   ;
  Tcontrol_t          miss_ifetch ;
  Tcontrol_t          miss_decod  ;
  Tcontrol_t          miss_commit ;
} request_t;

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );
    
  Update_Prediction_Table * _Update_Prediction_Table = new Update_Prediction_Table 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_PREDICT_VAL                    ," in_PREDICT_VAL                    ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK                    ,"out_PREDICT_ACK                    ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_CONTEXT_ID             ," in_PREDICT_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_SRC        ," in_PREDICT_BTB_ADDRESS_SRC        ",Taddress_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_DEST       ," in_PREDICT_BTB_ADDRESS_DEST       ",Taddress_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_CONDITION          ," in_PREDICT_BTB_CONDITION          ",Tbranch_condition_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_LAST_TAKE          ," in_PREDICT_BTB_LAST_TAKE          ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_IS_ACCURATE        ," in_PREDICT_BTB_IS_ACCURATE        ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_DIR_HISTORY            ," in_PREDICT_DIR_HISTORY            ",Thistory_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_ADDRESS            ," in_PREDICT_RAS_ADDRESS            ",Taddress_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_INDEX              ," in_PREDICT_RAS_INDEX              ",Tptr_t             ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPDATE_PREDICTION_ID   ,"out_PREDICT_UPDATE_PREDICTION_ID   ",Tprediction_ptr_t  ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_DECOD_VAL                      ," in_DECOD_VAL                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ACK                      ,"out_DECOD_ACK                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_CONTEXT_ID               ," in_DECOD_CONTEXT_ID               ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_ADDRESS_SRC          ," in_DECOD_BTB_ADDRESS_SRC          ",Taddress_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_ADDRESS_DEST         ," in_DECOD_BTB_ADDRESS_DEST         ",Taddress_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_CONDITION            ," in_DECOD_BTB_CONDITION            ",Tbranch_condition_t,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_LAST_TAKE            ," in_DECOD_BTB_LAST_TAKE            ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_ADDRESS              ," in_DECOD_RAS_ADDRESS              ",Taddress_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_INDEX                ," in_DECOD_RAS_INDEX                ",Tptr_t             ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_MISS_IFETCH              ," in_DECOD_MISS_IFETCH              ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_MISS_DECOD               ," in_DECOD_MISS_DECOD               ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_UPDATE_PREDICTION_ID     ," in_DECOD_UPDATE_PREDICTION_ID     ",Tprediction_ptr_t  ,_param->_nb_inst_decod);
//ALLOC1_SC_SIGNAL(out_DECOD_DEPTH                    ,"out_DECOD_DEPTH                    ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_IS_ACCURATE              ," in_DECOD_IS_ACCURATE              ",Tcontrol_t         ,_param->_nb_inst_decod);

  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ," in_BRANCH_COMPLETE_VAL            ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,"out_BRANCH_COMPLETE_ACK            ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ," in_BRANCH_COMPLETE_CONTEXT_ID     ",Tcontext_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ," in_BRANCH_COMPLETE_DEPTH          ",Tdepth_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ," in_BRANCH_COMPLETE_ADDRESS        ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_FLAG           ," in_BRANCH_COMPLETE_FLAG           ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,"out_BRANCH_COMPLETE_MISS_PREDICTION",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_TAKE           ,"out_BRANCH_COMPLETE_TAKE           ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_SRC    ,"out_BRANCH_COMPLETE_ADDRESS_SRC    ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_DEST   ,"out_BRANCH_COMPLETE_ADDRESS_DEST   ",Taddress_t         ,_param->_nb_inst_branch_complete);

  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_VAL            ,"out_BRANCH_EVENT_VAL            ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_ACK            ," in_BRANCH_EVENT_ACK            ",Tcontrol_t         ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_CONTEXT_ID     ," in_BRANCH_EVENT_CONTEXT_ID     ",Tcontext_t         ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_DEPTH          ," in_BRANCH_EVENT_DEPTH          ",Tdepth_t           ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_MISS_PREDICTION,"out_BRANCH_EVENT_MISS_PREDICTION",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_ADDRESS_SRC    ,"out_BRANCH_EVENT_ADDRESS_SRC    ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_ADDRESS_DEST   ,"out_BRANCH_EVENT_ADDRESS_DEST   ",Taddress_t         ,_param->_nb_context);

  ALLOC1_SC_SIGNAL(out_UPDATE_VAL                     ,"out_UPDATE_VAL                     ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ACK                     ," in_UPDATE_ACK                     ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_CONTEXT_ID              ,"out_UPDATE_CONTEXT_ID              ",Tcontext_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_MISS_PREDICTION         ,"out_UPDATE_MISS_PREDICTION         ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIRECTION_GOOD          ,"out_UPDATE_DIRECTION_GOOD          ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_VAL                 ,"out_UPDATE_BTB_VAL                 ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_SRC         ,"out_UPDATE_BTB_ADDRESS_SRC         ",Taddress_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_DEST        ,"out_UPDATE_BTB_ADDRESS_DEST        ",Taddress_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_CONDITION           ,"out_UPDATE_BTB_CONDITION           ",Tbranch_condition_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIR_VAL                 ,"out_UPDATE_DIR_VAL                 ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIR_HISTORY             ,"out_UPDATE_DIR_HISTORY             ",Thistory_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_VAL                 ,"out_UPDATE_RAS_VAL                 ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_PUSH                ,"out_UPDATE_RAS_PUSH                ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_ADDRESS             ,"out_UPDATE_RAS_ADDRESS             ",Taddress_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_INDEX               ,"out_UPDATE_RAS_INDEX               ",Tptr_t             ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_PREDICTION_IFETCH   ,"out_UPDATE_RAS_PREDICTION_IFETCH   ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_DEPTH_CURRENT                  ,"out_DEPTH_CURRENT                  ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_MIN                      ,"out_DEPTH_MIN                      ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_MAX                      ,"out_DEPTH_MAX                      ",Tdepth_t           ,_param->_nb_context);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Update_Prediction_Table.\n"),name.c_str());

  (*(_Update_Prediction_Table->in_CLOCK))        (*(in_CLOCK));
  (*(_Update_Prediction_Table->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_VAL                    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_PREDICT_ACK                    ,_param->_nb_inst_predict);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_CONTEXT_ID             ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_ADDRESS_SRC        ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_ADDRESS_DEST       ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_CONDITION          ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_LAST_TAKE          ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_IS_ACCURATE        ,_param->_nb_inst_predict);
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_DIR_HISTORY            ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_RAS_ADDRESS            ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_RAS_INDEX              ,_param->_nb_inst_predict);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_PREDICT_UPDATE_PREDICTION_ID   ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_VAL                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DECOD_ACK                      ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_CONTEXT_ID               ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_ADDRESS_SRC          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_ADDRESS_DEST         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_CONDITION            ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_LAST_TAKE            ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_RAS_ADDRESS              ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_RAS_INDEX                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_MISS_IFETCH              ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_MISS_DECOD               ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_UPDATE_PREDICTION_ID     ,_param->_nb_inst_decod);
//if (_param->_have_port_depth)
//INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DECOD_DEPTH                    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_IS_ACCURATE              ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_FLAG           ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete);

  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_EVENT_VAL            ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_EVENT_ACK            ,_param->_nb_context);
//   if (_param->_have_port_context_id)
//   INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_EVENT_CONTEXT_ID     ,_param->_nb_context);
//   if (_param->_have_port_depth)
//   INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_EVENT_DEPTH          ,_param->_nb_context);
//   INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_EVENT_ADDRESS        ,_param->_nb_context);
//   INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_EVENT_MISS_PREDICTION,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_EVENT_ADDRESS_SRC    ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_EVENT_ADDRESS_DEST   ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_VAL                     ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_UPDATE_ACK                     ,_param->_nb_inst_update);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_CONTEXT_ID              ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_MISS_PREDICTION         ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_DIRECTION_GOOD          ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_VAL                 ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_ADDRESS_SRC         ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_ADDRESS_DEST        ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_CONDITION           ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_DIR_VAL                 ,_param->_nb_inst_update);
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_DIR_HISTORY             ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_VAL                 ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_PUSH                ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_ADDRESS             ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_INDEX               ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_PREDICTION_IFETCH   ,_param->_nb_inst_update);
  if (_param->_have_port_depth)
    {
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DEPTH_CURRENT                  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DEPTH_MIN                      ,_param->_nb_context);
    }
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DEPTH_MAX                      ,_param->_nb_context);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_predict         = 75;
  const  int32_t percent_transaction_decod           = 75;
  const  int32_t percent_transaction_branch_complete = 75;
  const  int32_t percent_transaction_update          = 75;



  std::list<request_t> ufpt;
  std::list<request_t> upt;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  Tdepth_t ufpt_bottom [_param->_nb_context];
  Tdepth_t ufpt_top    [_param->_nb_context];

  Tdepth_t upt_bottom  [_param->_nb_context];
  Tdepth_t upt_top     [_param->_nb_context];

  for (uint32_t i=0; i<_param->_nb_context; ++i)
    {
      ufpt_bottom [i] = 0;
      ufpt_top    [i] = 0;
      upt_bottom  [i] = 0;
      upt_top     [i] = 0;
    }

  for (uint32_t i=0; i<_param->_nb_context; ++i)
    {
      TEST(Tdepth_t,out_DEPTH_CURRENT [i]->read(),upt_top    [i]);
      TEST(Tdepth_t,out_DEPTH_MIN     [i]->read(),upt_bottom [i]);
      TEST(Tdepth_t,out_DEPTH_MAX     [i]->read(),upt_top    [i]);
    }

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_inst_predict; ++i)
        in_PREDICT_VAL         [i]->write(0);
      for (uint32_t i=0; i<_param->_nb_inst_decod; ++i)
        in_DECOD_VAL           [i]->write(0);
      for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
        in_BRANCH_COMPLETE_VAL [i]->write(0);
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        in_BRANCH_EVENT_ACK    [i]->write(0);
      for (uint32_t i=0; i<_param->_nb_inst_update; ++i)
        in_UPDATE_ACK          [i]->write(0);

      //---------------------------------------------------------------------
      //---------------------------------------------------------------------
      // COMMON CASE
      //---------------------------------------------------------------------
      //---------------------------------------------------------------------
      if (1)
      {
	uint32_t context = rand() % _param->_nb_context;

	{
          LABEL("PREDICT - fill the queue");
	  uint32_t port = rand() % _param->_nb_inst_predict;

          LABEL("  * context : %d",context);
          LABEL("  * port    : %d",port);
	  
	  for (uint32_t i=0; i<_param->_size_ufpt_queue[context]; i++)
	    {
              request_t request;
              request.context          = context;
              request.address_src      = 0xdeadbeef+i;
              request.address_dest     = 0x21071981+i;                                   
              request.address_good     = request.address_dest;
              request.condition        = BRANCH_CONDITION_FLAG_SET;                      
              request.take             = 1;                                              
              request.take_good        = 1;                                              
              request.flag             = (request.condition == BRANCH_CONDITION_FLAG_SET)?request.take_good:(not request.take_good);
              request.is_accurate      = true;
              request.miss_ifetch      = false;
              request.miss_decod       = false;
              request.miss_commit      = false;
              request.history          = i;                                              
              request.ras_address      = 0xdeaddead+i;                                   
              request.ras_index        = (0x12345678+i)%_param->_size_ras_index[context];
              request.ufpt_ptr         = ufpt_top [context];
//            request.upt_ptr;

	      bool have_transaction = false;
	      do
		{
		  in_PREDICT_VAL              [port]->write((rand()%100)<percent_transaction_predict);
		  in_PREDICT_CONTEXT_ID       [port]->write(request.context     );
		  in_PREDICT_BTB_ADDRESS_SRC  [port]->write(request.address_src );
		  in_PREDICT_BTB_ADDRESS_DEST [port]->write(request.address_dest);
		  in_PREDICT_BTB_CONDITION    [port]->write(request.condition   );
		  in_PREDICT_BTB_LAST_TAKE    [port]->write(request.take        );
		  in_PREDICT_BTB_IS_ACCURATE  [port]->write(request.is_accurate );
		  in_PREDICT_DIR_HISTORY      [port]->write(request.history     );
		  in_PREDICT_RAS_ADDRESS      [port]->write(request.ras_address );
		  in_PREDICT_RAS_INDEX        [port]->write(request.ras_index   );
		  
		  if (_param->_have_port_depth)
		  TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
                  TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
		      
		  SC_START(0); // fct melay
		  
		  LABEL("PREDICT         [%d] %d - %d (accurate : %d).",
                        port,
                         in_PREDICT_VAL [port]->read(),
                        out_PREDICT_ACK [port]->read(),
                         in_PREDICT_BTB_IS_ACCURATE [port]->read());
		  
		  if (in_PREDICT_VAL [port]->read() and out_PREDICT_ACK [port]->read())
		    {
		      LABEL("PREDICT         [%d] - Transaction accepted",port);
		      have_transaction = true;

                      if (_param->_have_port_depth)
                      TEST(Tprediction_ptr_t,out_PREDICT_UPDATE_PREDICTION_ID [port]->read(),ufpt_top [context]);
                      
                      ufpt_top [context] = (ufpt_top [context]+1)%_param->_size_ufpt_queue[context];
		    }
		  
		  SC_START(1); // transition
		  
		} while (not have_transaction);

              ufpt.push_back(request);

	      in_PREDICT_VAL [port]->write(0);
	    
              if (_param->_have_port_depth)
	      TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
              TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
	    }
	}
	
        {
          LABEL("DECOD");
	  uint32_t port = rand() % _param->_nb_inst_decod;

          LABEL("  * context : %d",context);
          LABEL("  * port    : %d",port);
          
	  for (uint32_t i=0; i<_param->_size_ufpt_queue[context]; i++)
	    {
              request_t request = ufpt.front();

	      bool have_transaction = false;
	      do
		{
		  in_DECOD_VAL                  [port]->write((rand()%100)<percent_transaction_decod);
		  in_DECOD_CONTEXT_ID           [port]->write(request.context     );
		  in_DECOD_BTB_ADDRESS_SRC      [port]->write(request.address_src );
		  in_DECOD_BTB_ADDRESS_DEST     [port]->write(request.address_dest);
		  in_DECOD_BTB_CONDITION        [port]->write(request.condition   );
		  in_DECOD_BTB_LAST_TAKE        [port]->write(request.take        );
		  in_DECOD_RAS_ADDRESS          [port]->write(request.ras_address );
		  in_DECOD_RAS_INDEX            [port]->write(request.ras_index   );
		  in_DECOD_UPDATE_PREDICTION_ID [port]->write(request.ufpt_ptr    );
		  in_DECOD_MISS_IFETCH          [port]->write(request.miss_ifetch );
		  in_DECOD_MISS_DECOD           [port]->write(request.miss_decod  );
		  in_DECOD_IS_ACCURATE          [port]->write(request.is_accurate );

		  SC_START(0); // fct melay
		  
		  LABEL("DECOD           [%d] %d - %d",
                        port,
                         in_PREDICT_VAL [port]->read(),
                        out_PREDICT_ACK [port]->read());
		  
		  if (in_DECOD_VAL [port]->read() and out_DECOD_ACK [port]->read())
		    {
		      LABEL("DECOD          [%d] - Transaction accepted",port);
		      have_transaction = true;

                      request.upt_ptr = upt_top [context];
                      upt.push_back(request);
                      ufpt.pop_front();

                      upt_top [context] = (upt_top [context]+1)%_param->_size_upt_queue[context];
		    }

		  SC_START(1); // transition

                } while (not have_transaction);

	      in_DECOD_VAL              [port]->write(0);
	      
              if (_param->_have_port_depth)
	      TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
              TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
            }
        }

	{
          LABEL("BRANCH_COMPLETE - hit ifetch");
	
	  uint32_t port = rand() % _param->_nb_inst_branch_complete;
	
          LABEL("  * port    : %d",port);
  
          std::list<request_t>::iterator it_upt = upt.begin();

// 	  for (uint32_t i=0; i<_param->_size_ufpt_queue[context]; i++)
	  for (uint32_t i=0; i<upt.size(); i++)
	    {
	      bool have_transaction = false;

	      do
		{
		  in_BRANCH_COMPLETE_VAL        [port]->write((rand()%100)<percent_transaction_branch_complete);
		  in_BRANCH_COMPLETE_CONTEXT_ID [port]->write(it_upt->context     );
		  in_BRANCH_COMPLETE_DEPTH      [port]->write(it_upt->upt_ptr     );
		  in_BRANCH_COMPLETE_ADDRESS    [port]->write(it_upt->address_good);
		  in_BRANCH_COMPLETE_FLAG       [port]->write(it_upt->flag        );

                  if (_param->_have_port_depth)
                  TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
                  TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
		  
		  SC_START(0);
		  
		  LABEL("BRANCH_COMPLETE [%d] %d - %d.",port,in_BRANCH_COMPLETE_VAL [port]->read(),out_BRANCH_COMPLETE_ACK [port]->read());
		  
		  if (in_BRANCH_COMPLETE_VAL [port]->read() and out_BRANCH_COMPLETE_ACK [port]->read())
		    {
		      LABEL("BRANCH_COMPLETE [%d] - Transaction accepted",port);
		      have_transaction = true;
		      
		      TEST(Tcontrol_t,out_BRANCH_COMPLETE_MISS_PREDICTION[port]->read(),it_upt->miss_commit );
		      TEST(Tcontrol_t,out_BRANCH_COMPLETE_TAKE           [port]->read(),it_upt->take_good   );
		      TEST(Taddress_t,out_BRANCH_COMPLETE_ADDRESS_SRC    [port]->read(),it_upt->address_src );
		      TEST(Taddress_t,out_BRANCH_COMPLETE_ADDRESS_DEST   [port]->read(),it_upt->address_good);

                      it_upt ++;
		    }
		  
		  SC_START(1);
		} while (not have_transaction);

	      in_BRANCH_COMPLETE_VAL [port]->write(0);
	      
              if (_param->_have_port_depth)
              TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
              TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
	    }
	}

	{
          LABEL("UPDATE - hit ifetch");
	
	  uint32_t port = 0;
	
          LABEL("  * port    : %d",port);
          std::list<request_t>::iterator it_upt = upt.begin();
  
// 	  for (uint32_t i=0; i<_param->_size_ufpt_queue[context]; i++)
	  for (uint32_t i=0; i<upt.size(); i++)
	    {
              LABEL("Address_src (-1): %.8x (%d)",out_UPDATE_BTB_ADDRESS_SRC [i]->read(),upt.size());

	      bool have_transaction = false;

	      do
		{
                  LABEL("Address_src (0) : %.8x",out_UPDATE_BTB_ADDRESS_SRC [i]->read());

		  in_UPDATE_ACK [port]->write((rand()%100)<percent_transaction_update);

//                   if (_param->_have_port_depth)
//                   TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
//                   TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
		  
                  LABEL("Address_src (1) : %.8x",out_UPDATE_BTB_ADDRESS_SRC [i]->read());
		  SC_START(0);
                  LABEL("Address_src (2) : %.8x",out_UPDATE_BTB_ADDRESS_SRC [i]->read());
		  
		  LABEL("UPDATE [%d] %d - %d.",port,out_UPDATE_VAL [port]->read(),in_UPDATE_ACK [port]->read());
		  
		  if (out_UPDATE_VAL [port]->read() and in_UPDATE_ACK [port]->read())
		    {
		      LABEL("UPDATE [%d] - Transaction accepted",port);
		      have_transaction = true;
		  
                      if (_param->_have_port_context_id)
                      TEST(Tcontext_t         ,out_UPDATE_CONTEXT_ID            [i]->read(),it_upt->context);
                      TEST(Tcontrol_t         ,out_UPDATE_MISS_PREDICTION       [i]->read(),it_upt->miss_commit);
                      TEST(Tcontrol_t         ,out_UPDATE_DIRECTION_GOOD        [i]->read(),it_upt->flag);
                      TEST(Tcontrol_t         ,out_UPDATE_BTB_VAL               [i]->read(),update_btb(it_upt->condition));
                      if (update_btb(it_upt->condition))
                        {
                      TEST(Taddress_t         ,out_UPDATE_BTB_ADDRESS_SRC       [i]->read(),it_upt->address_src);
                      TEST(Taddress_t         ,out_UPDATE_BTB_ADDRESS_DEST      [i]->read(),it_upt->address_dest);
                      TEST(Tbranch_condition_t,out_UPDATE_BTB_CONDITION         [i]->read(),it_upt->condition);
                        }
                      TEST(Tcontrol_t         ,out_UPDATE_DIR_VAL               [i]->read(),update_dir(it_upt->condition));
                      if (update_dir(it_upt->condition))
                      if (_param->_have_port_history)
                      TEST(Thistory_t         ,out_UPDATE_DIR_HISTORY           [i]->read(),it_upt->history);
                      TEST(Tcontrol_t         ,out_UPDATE_RAS_VAL               [i]->read(),update_ras(it_upt->condition));
                      if (update_ras(it_upt->condition))
                        {
                      TEST(Tcontrol_t         ,out_UPDATE_RAS_PUSH              [i]->read(),push_ras  (it_upt->condition));
                      TEST(Taddress_t         ,out_UPDATE_RAS_ADDRESS           [i]->read(),it_upt->ras_address);
                      TEST(Tptr_t             ,out_UPDATE_RAS_INDEX             [i]->read(),it_upt->ras_index);
                      TEST(Tcontrol_t         ,out_UPDATE_RAS_PREDICTION_IFETCH [i]->read(),not it_upt->miss_ifetch);
                        }
                      ++ it_upt;
		    }

		  SC_START(1);
                  LABEL("Address_src (3) : %.8x",out_UPDATE_BTB_ADDRESS_SRC [i]->read());
                  
		} while (not have_transaction);

              LABEL("Address_src (4) : %.8x",out_UPDATE_BTB_ADDRESS_SRC [i]->read());
	      in_UPDATE_ACK [port]->write(0);
              LABEL("Address_src (5) : %.8x",out_UPDATE_BTB_ADDRESS_SRC [i]->read());
//               if (_param->_have_port_depth)
//               TEST(Tdepth_t,out_DEPTH_MIN [context]->read(), upt_bottom [context]);
//               TEST(Tdepth_t,out_DEPTH_MAX [context]->read(), upt_top [context]);
	    }
          upt.clear();
	}

        // Wait Garbage Collector
        {
          upt_bottom [context] = (upt_bottom [context]+_param->_size_ufpt_queue[context])%_param->_size_upt_queue[context];
//        upt_top    [context] = (upt_top    [context]);

          while ((upt_bottom [context] != out_DEPTH_MIN [context]->read()) or
                 (upt_top    [context] != out_DEPTH_MAX [context]->read()))
            SC_START(1);

        }
      }

    }// ITERATION

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete []  in_PREDICT_VAL                 ;
  delete [] out_PREDICT_ACK                 ;
  delete []  in_PREDICT_CONTEXT_ID          ;
  delete []  in_PREDICT_BTB_ADDRESS_SRC     ;
  delete []  in_PREDICT_BTB_ADDRESS_DEST    ;
  delete []  in_PREDICT_BTB_CONDITION       ;
  delete []  in_PREDICT_BTB_LAST_TAKE       ;
  delete []  in_PREDICT_BTB_IS_ACCURATE     ;
  delete []  in_PREDICT_DIR_HISTORY         ;
  delete []  in_PREDICT_RAS_ADDRESS         ;
  delete []  in_PREDICT_RAS_INDEX           ;
  delete [] out_PREDICT_UPDATE_PREDICTION_ID;
  
  // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete []  in_DECOD_VAL                   ;
  delete [] out_DECOD_ACK                   ;
  delete []  in_DECOD_CONTEXT_ID            ;
  delete []  in_DECOD_BTB_ADDRESS_SRC       ;
  delete []  in_DECOD_BTB_ADDRESS_DEST      ;
  delete []  in_DECOD_BTB_CONDITION         ;
  delete []  in_DECOD_BTB_LAST_TAKE         ;
  delete []  in_DECOD_RAS_ADDRESS           ;
  delete []  in_DECOD_RAS_INDEX             ;
  delete []  in_DECOD_MISS_IFETCH           ;
  delete []  in_DECOD_MISS_DECOD            ;
  delete []  in_DECOD_UPDATE_PREDICTION_ID  ;
//delete [] out_DECOD_DEPTH                 ;
  delete []  in_DECOD_IS_ACCURATE           ;
  
  // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete []  in_BRANCH_COMPLETE_VAL            ;
  delete [] out_BRANCH_COMPLETE_ACK            ;
  delete []  in_BRANCH_COMPLETE_CONTEXT_ID     ;
  delete []  in_BRANCH_COMPLETE_DEPTH          ;
  delete []  in_BRANCH_COMPLETE_ADDRESS        ;
  delete []  in_BRANCH_COMPLETE_FLAG           ;
  delete [] out_BRANCH_COMPLETE_MISS_PREDICTION;
  delete [] out_BRANCH_COMPLETE_TAKE           ;
  delete [] out_BRANCH_COMPLETE_ADDRESS_SRC    ;
  delete [] out_BRANCH_COMPLETE_ADDRESS_DEST   ;

  // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete [] out_BRANCH_EVENT_VAL            ;
  delete []  in_BRANCH_EVENT_ACK            ;
//   delete []  in_BRANCH_EVENT_CONTEXT_ID     ;
//   delete []  in_BRANCH_EVENT_DEPTH          ;
//   delete [] out_BRANCH_EVENT_MISS_PREDICTION;
  delete [] out_BRANCH_EVENT_ADDRESS_SRC    ;
  delete [] out_BRANCH_EVENT_ADDRESS_DEST   ;
  
  // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete [] out_UPDATE_VAL                  ;
  delete []  in_UPDATE_ACK                  ;
  delete [] out_UPDATE_CONTEXT_ID           ;
  delete [] out_UPDATE_MISS_PREDICTION      ;
  delete [] out_UPDATE_DIRECTION_GOOD       ;
  delete [] out_UPDATE_BTB_VAL              ;
  delete [] out_UPDATE_BTB_ADDRESS_SRC      ;
  delete [] out_UPDATE_BTB_ADDRESS_DEST     ;
  delete [] out_UPDATE_BTB_CONDITION        ;
  delete [] out_UPDATE_DIR_VAL              ;
  delete [] out_UPDATE_DIR_HISTORY          ;
  delete [] out_UPDATE_RAS_VAL              ;
  delete [] out_UPDATE_RAS_PUSH             ;
  delete [] out_UPDATE_RAS_ADDRESS          ;
  delete [] out_UPDATE_RAS_INDEX            ;
  delete [] out_UPDATE_RAS_PREDICTION_IFETCH;

  // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete [] out_DEPTH_CURRENT;
  delete [] out_DEPTH_MIN;
  delete [] out_DEPTH_MAX;

#endif

  delete _Update_Prediction_Table;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
