#ifndef morpheo_behavioural_generic_shifter_Type_h
#define morpheo_behavioural_generic_shifter_Type_h

/*
 * $Id: Types.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Common/include/ToString.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  typedef enum { without_rotate      ,
		 internal_rotate     ,
		 external_rotate     } rotate_t;

  typedef enum { internal_right_shift,
		 internal_left_shift ,
		 external_direction  } direction_t;

  typedef enum { internal_logic      ,
		 internal_arithmetic ,
		 external_carry      ,
		 external_completion } carry_t;       

  typedef uint32_t     Tdata_t     ;
  typedef uint32_t     Tshift_t    ;
  typedef bool         Tdirection_t;
  typedef bool         Ttype_t     ;
  typedef bool         Tcarry_t    ;

  // A lot of constant
  const   Tdirection_t _right      = false;
  const   Tdirection_t _left       = true ;

  const   Ttype_t      _shift      = false;
  const   Ttype_t      _rotate     = true ;

  const   Tcarry_t     _logic      = false;
  const   Tcarry_t     _arithmetic = true ;

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::generic::shifter::rotate_t>(const morpheo::behavioural::generic::shifter::rotate_t& x)
    {
      switch (x)
	{
	case morpheo::behavioural::generic::shifter::without_rotate            : return "without_rotate" ;
	case morpheo::behavioural::generic::shifter::internal_rotate           : return "internal_rotate";
	case morpheo::behavioural::generic::shifter::external_rotate           : return "external_rotate";     
	default                        : return "";
	}
    };
  
  template<> inline std::string toString<morpheo::behavioural::generic::shifter::direction_t>(const morpheo::behavioural::generic::shifter::direction_t& x) 
  {
    switch (x)
      {
      case morpheo::behavioural::generic::shifter::internal_right_shift      : return "internal_right_shift";
      case morpheo::behavioural::generic::shifter::internal_left_shift       : return "internal_left_shift" ;
      case morpheo::behavioural::generic::shifter::external_direction        : return "external_direction"  ;
      default                        : return "";
      }
  };
  
  template<> inline std::string toString<morpheo::behavioural::generic::shifter::carry_t>(const morpheo::behavioural::generic::shifter::carry_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::generic::shifter::internal_logic            : return "internal_logic"       ;
      case morpheo::behavioural::generic::shifter::internal_arithmetic       : return "internal_arithmetic"  ;
      case morpheo::behavioural::generic::shifter::external_carry            : return "external_carry"       ;
      case morpheo::behavioural::generic::shifter::external_completion       : return "external_completion"  ;
      default                        : return "";
      }
  };
    

}; // end namespace morpheo              

#endif
