#ifdef SYSTEMC
/*
 * $Id: Stat_List_unit_genMealy.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Stat_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


#undef  FUNCTION
#define FUNCTION "Stat_List_unit::genMealy"
  void Stat_List_unit::genMealy (void)
  {
    log_begin(Stat_List_unit,FUNCTION);
    log_function(Stat_List_unit,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
	bool ack = true;

	if (PORT_READ(in_INSERT_READ_RA [i]))
	  {
	    Tgeneral_address_t num_reg = PORT_READ(in_INSERT_NUM_REG_RA_PHY [i]);
	    uint32_t bank = num_reg >> _param->_shift_gpr;
	    uint32_t reg  = num_reg  & _param->_mask_gpr ;
	    ack &= gpr_stat_list [bank][reg].can_insert_read(_param->_max_reader);
	  }

	if (PORT_READ(in_INSERT_READ_RB [i]))
	  {
	    Tgeneral_address_t num_reg = PORT_READ(in_INSERT_NUM_REG_RB_PHY [i]);
	    uint32_t bank = num_reg >> _param->_shift_gpr;
	    uint32_t reg  = num_reg  & _param->_mask_gpr ;
	    ack &= gpr_stat_list [bank][reg].can_insert_read(_param->_max_reader);
	  }

	if (PORT_READ(in_INSERT_READ_RC [i]))
	  {
	    Tgeneral_address_t num_reg = PORT_READ(in_INSERT_NUM_REG_RC_PHY [i]);
	    uint32_t bank = num_reg >> _param->_shift_spr;
	    uint32_t reg  = num_reg  & _param->_mask_spr ;
	    ack &= spr_stat_list [bank][reg].can_insert_read(_param->_max_reader);
	  }

	internal_INSERT_ACK [i] = ack;
	PORT_WRITE(out_INSERT_ACK [i], ack);
      }
    
    log_end(Stat_List_unit,FUNCTION);
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
