#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue_control {

#undef  FUNCTION
#define FUNCTION "Queue_Control::pop"
  void Queue_Control::pop (uint32_t index)
  {
    log_printf(FUNC,Queue_Control,FUNCTION,"Begin");

    uint32_t val = (*_tab)[index];
    _tab->erase (_tab->begin()+index);
    _tab->push_back(val);
    _nb_elt --;
	
    log_printf(FUNC,Queue_Control,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Queue_Control::pop"
  void Queue_Control::pop (void)
  {
    log_printf(FUNC,Queue_Control,FUNCTION,"Begin");

    pop (0);
	
    log_printf(FUNC,Queue_Control,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Queue_Control::pop_ovf"
  void Queue_Control::pop_ovf (uint32_t index)
  {
    log_printf(FUNC,Queue_Control,FUNCTION,"Begin");

    if (empty() or (index >= _nb_elt_max))
      {
	ErrorMorpheo ("<Queue_Control::pop_ovf> Queue Overflow");
      }

    pop(index);
	
    log_printf(FUNC,Queue_Control,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Queue_Control::pop_ovf"
  void Queue_Control::pop_ovf (void)
  {
    log_printf(FUNC,Queue_Control,FUNCTION,"Begin");

    pop_ovf(0);

    log_printf(FUNC,Queue_Control,FUNCTION,"End");
  };


}; // end namespace queue_control
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
