#ifdef VHDL

/*
 * $Id: Vhdl_get_header.cpp 94 2008-12-15 11:04:03Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Behavioural/include/Version.h"
#include <time.h>
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_header"
  std::string Vhdl::get_header(uint32_t depth,
			       std::string   filename)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string text;

    time_t current_time;
    time (&current_time);

    text += "-------------------------------------------------------------------------------\n";
    text += "-- "+toString(_("File : "))            + filename  +"\n";
    text += "-- "+toString(_("Date : "))            + ctime (&current_time );
    text += "-- "+toString(_("Morpheo version : ")) + MORPHEO_HEADER +"\n";
    text += "-- "+toString(_("Comment : "))         + _("it's a autogenerated file, don't modify") +"\n";
    text += "-------------------------------------------------------------------------------\n";
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text;
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
