/*
 * $Id: Functionnal_unit_allocation.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {

#undef  FUNCTION
#define FUNCTION "Functionnal_unit::allocation"
  void Functionnal_unit::allocation (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Functionnal_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }
    // ~~~~~[ Interface : "execute_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     {
      Interface_fifo * interface = _interfaces->set_interface("execute_in"
#ifdef POSITION
							      ,IN
							      ,WEST,
							      "Input of Functionnal Unit"
#endif
							      );

       in_EXECUTE_IN_VAL           = interface->set_signal_valack_in  (VAL);
      out_EXECUTE_IN_ACK           = interface->set_signal_valack_out (ACK);
      if (_param->_have_port_context_id)
       in_EXECUTE_IN_CONTEXT_ID    = interface->set_signal_in <Tcontext_t        > ("context_id"   , _param->_size_context_id   );
      if (_param->_have_port_front_end_id)
       in_EXECUTE_IN_FRONT_END_ID  = interface->set_signal_in <Tcontext_t        > ("front_end_id" , _param->_size_front_end_id );
      if (_param->_have_port_ooo_engine_id)
       in_EXECUTE_IN_OOO_ENGINE_ID = interface->set_signal_in <Tcontext_t        > ("ooo_engine_id", _param->_size_ooo_engine_id);
      if (_param->_have_port_rob_ptr)
       in_EXECUTE_IN_PACKET_ID     = interface->set_signal_in <Tpacket_t         > ("packet_id"    , _param->_size_rob_ptr    );
       in_EXECUTE_IN_OPERATION     = interface->set_signal_in <Toperation_t      > ("operation"    , _param->_size_operation    );
       in_EXECUTE_IN_TYPE          = interface->set_signal_in <Ttype_t           > ("type"         , _param->_size_type         );
       in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE = interface->set_signal_in <Tlsq_ptr_t> ("store_queue_ptr_write",_param->_size_store_queue_ptr);
       if (_param->_have_port_load_queue_ptr)
       in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE  = interface->set_signal_in <Tlsq_ptr_t> ("load_queue_ptr_write" ,_param->_size_load_queue_ptr);
       in_EXECUTE_IN_HAS_IMMEDIAT  = interface->set_signal_in <Tcontrol_t        > ("has_immediat" , 1);
       in_EXECUTE_IN_IMMEDIAT      = interface->set_signal_in <Tgeneral_data_t   > ("immediat"     , _param->_size_general_data);
       in_EXECUTE_IN_DATA_RA       = interface->set_signal_in <Tgeneral_data_t   > ("data_ra"      , _param->_size_general_data);
       in_EXECUTE_IN_DATA_RB       = interface->set_signal_in <Tgeneral_data_t   > ("data_rb"      , _param->_size_general_data);
       in_EXECUTE_IN_DATA_RC       = interface->set_signal_in <Tspecial_data_t   > ("data_rc"      , _param->_size_special_data);
       in_EXECUTE_IN_WRITE_RD      = interface->set_signal_in <Tcontrol_t        > ("write_rd"     , 1);
       in_EXECUTE_IN_NUM_REG_RD    = interface->set_signal_in <Tgeneral_address_t> ("num_reg_rd"   , _param->_size_general_register);
       in_EXECUTE_IN_WRITE_RE      = interface->set_signal_in <Tcontrol_t        > ("write_re"     , 1);
       in_EXECUTE_IN_NUM_REG_RE    = interface->set_signal_in <Tspecial_address_t> ("num_reg_re"   , _param->_size_special_register);
     }
    // ~~~~~[ Interface : "execute_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~     
     {
       Interface_fifo * interface = _interfaces->set_interface("execute_out"
#ifdef POSITION
							       ,IN
							       ,EAST,
							       "Output of Functionnal Unit"
#endif
							       );

       out_EXECUTE_OUT_VAL            = interface->set_signal_valack_out (VAL);
        in_EXECUTE_OUT_ACK            = interface->set_signal_valack_in  (ACK);
       if (_param->_have_port_context_id)
       out_EXECUTE_OUT_CONTEXT_ID     = interface->set_signal_out<Tcontext_t        > ("context_id"   ,_param->_size_context_id   );
       if (_param->_have_port_front_end_id)
       out_EXECUTE_OUT_FRONT_END_ID   = interface->set_signal_out<Tcontext_t        > ("front_end_id" ,_param->_size_front_end_id );
       if (_param->_have_port_ooo_engine_id)
       out_EXECUTE_OUT_OOO_ENGINE_ID  = interface->set_signal_out<Tcontext_t        > ("ooo_engine_id",_param->_size_ooo_engine_id);
       if (_param->_have_port_rob_ptr)
       out_EXECUTE_OUT_PACKET_ID      = interface->set_signal_out<Tpacket_t         > ("packet_id"    ,_param->_size_rob_ptr    );
     //out_EXECUTE_OUT_OPERATION      = interface->set_signal_out<Toperation_t      > ("operation"    ,_param->_size_operation    );
     //out_EXECUTE_OUT_TYPE           = interface->set_signal_out<Ttype_t           > ("type"         ,_param->_size_type         );
       out_EXECUTE_OUT_WRITE_RD       = interface->set_signal_out<Tcontrol_t        > ("write_rd"     ,1);
       out_EXECUTE_OUT_NUM_REG_RD     = interface->set_signal_out<Tgeneral_address_t> ("num_reg_rd"   ,_param->_size_general_register);
       out_EXECUTE_OUT_DATA_RD        = interface->set_signal_out<Tgeneral_data_t   > ("data_rd"      ,_param->_size_general_data);
       out_EXECUTE_OUT_WRITE_RE       = interface->set_signal_out<Tcontrol_t        > ("write_re"     ,1);
       out_EXECUTE_OUT_NUM_REG_RE     = interface->set_signal_out<Tspecial_address_t> ("num_reg_re"   ,_param->_size_special_register);
       out_EXECUTE_OUT_DATA_RE        = interface->set_signal_out<Tspecial_data_t   > ("data_re"      ,_param->_size_special_data);
       out_EXECUTE_OUT_EXCEPTION      = interface->set_signal_out<Texception_t      > ("exception"    ,_param->_size_exception);
       out_EXECUTE_OUT_NO_SEQUENCE    = interface->set_signal_out<Tcontrol_t        > ("no_sequence"  ,1);
       out_EXECUTE_OUT_ADDRESS        = interface->set_signal_out<Taddress_t        > ("address"      ,_param->_size_instruction_address);
     }

     // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     if (usage_is_set(_usage,USE_SYSTEMC))
       {
     _execute_operation_in  = new execute_operation_t;
     _execute_operation_out = new execute_operation_t;
     _execute_param         = new execute_param_t(_param->_size_general_data,
						  _param->_timing);

     _execute_register = new execute_register_t *** [_param->_nb_context];

     for (uint32_t i=0; i<_param->_nb_context; i++)
       {
	 _execute_register [i] = new execute_register_t ** [_param->_nb_front_end];
	 
	 for (uint32_t j=0; j<_param->_nb_front_end; j++)
	   {
	     _execute_register [i][j] = new execute_register_t * [_param->_nb_ooo_engine];
	     
	     for (uint32_t k=0; k<_param->_nb_ooo_engine; k++)
	       {
// 		 uint32_t num_thread = get_num_thread(i,_param->_size_context_id,
// 						      j,_param->_size_front_end_id,
// 						      k,_param->_size_ooo_engine_id);

		 _execute_register [i][j][k] = new execute_register_t;
		 
		 if (_param->_have_groupe_MAC)
		   _execute_register[i][j][k]->implement_group(GROUP_MAC);

		 for (uint32_t x=GROUP_CUSTOM_1; x<GROUP_CUSTOM_8; x++)
		   if ((_param->_get_custom_information())._get_valid_group(x) == true)
		     {
		       uint32_t nb_reg = (_param->_get_custom_information())._get_nb_register(x);
		       _execute_register[i][j][k]->implement_group(x,nb_reg);

		       for (uint32_t y=0; y<nb_reg; y++)
			 _execute_register[i][j][k]->_spr_access_mode->change_mode(x,y,(_param->_get_custom_information())._get_access_mode(x,y));
		     }
	       }
	   }
       }

     _function_execute = new function_execute_t ** [_param->_nb_type];
     
     // Initialisation
     for (uint32_t i=0; i<_param->_nb_type; i++)
       {
	 _function_execute [i] = new function_execute_t * [_param->_nb_operation];
	 
	 for (uint32_t j=0; j<_param->_nb_operation; j++)
	   _function_execute [i][j] = &(operation_unimplemented);
       }

     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_ADD         ]._latence > 0)
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_ADD         ] = &(operation_l_add     );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_ADDC        ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_ADDC        ] = &(operation_l_addc    );
//   if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_SUB         ]._latence > 0) 
//     _function_execute[TYPE_ALU    ][OPERATION_ALU_L_SUB         ] = &(operation_l_sub     );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_AND         ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_AND         ] = &(operation_l_and     );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_OR          ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_OR          ] = &(operation_l_or      );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_XOR         ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_XOR         ] = &(operation_l_xor     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_SLL       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_SLL       ] = &(operation_l_sll     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRA       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRA       ] = &(operation_l_sra     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRL       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRL       ] = &(operation_l_srl     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_ROR       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_ROR       ] = &(operation_l_ror     );
     if (_param->_timing[TYPE_MOVE   ][OPERATION_MOVE_L_MOVHI      ]._latence > 0) 
       _function_execute[TYPE_MOVE   ][OPERATION_MOVE_L_MOVHI      ] = &(operation_l_movhi   );
     if (_param->_timing[TYPE_MOVE   ][OPERATION_MOVE_L_CMOV       ]._latence > 0) 
       _function_execute[TYPE_MOVE   ][OPERATION_MOVE_L_CMOV       ] = &(operation_l_cmov    ); 
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGEU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGEU      ] = &(operation_l_sfgeu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGTU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGTU      ] = &(operation_l_sfgtu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLEU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLEU      ] = &(operation_l_sfleu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLTU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLTU      ] = &(operation_l_sfltu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGES      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGES      ] = &(operation_l_sfges   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGTS      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGTS      ] = &(operation_l_sfgts   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLES      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLES      ] = &(operation_l_sfles   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLTS      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLTS      ] = &(operation_l_sflts   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFEQ       ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFEQ       ] = &(operation_l_sfeq    );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFNE       ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFNE       ] = &(operation_l_sfne    );
//   if (_param->_timing[TYPE_MUL    ][OPERATION_MUL_L_MUL         ]._latence > 0) 
//     _function_execute[TYPE_MUL    ][OPERATION_MUL_L_MUL         ] = &(operation_l_mul     );
//   if (_param->_timing[TYPE_MUL    ][OPERATION_MUL_L_MULU        ]._latence > 0) 
//     _function_execute[TYPE_DIV    ][OPERATION_MUL_L_MULU        ] = &(operation_l_mulu    );
//   if (_param->_timing[TYPE_DIV    ][OPERATION_DIV_L_DIV         ]._latence > 0) 
//     _function_execute[TYPE_DIV    ][OPERATION_DIV_L_DIV         ] = &(operation_l_div     );
//   if (_param->_timing[TYPE_DIV    ][OPERATION_DIV_L_DIVU        ]._latence > 0) 
//     _function_execute[TYPE_DIV    ][OPERATION_DIV_L_DIVU        ] = &(operation_l_divu    );
     if (_param->_timing[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_S ]._latence > 0) 
       _function_execute[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_S ] = &(operation_l_extend_s);
     if (_param->_timing[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_Z ]._latence > 0) 
       _function_execute[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_Z ] = &(operation_l_extend_z);
     if (_param->_timing[TYPE_FIND   ][OPERATION_FIND_L_FF1        ]._latence > 0) 
       _function_execute[TYPE_FIND   ][OPERATION_FIND_L_FF1        ] = &(operation_l_ff1     ); 
     if (_param->_timing[TYPE_FIND   ][OPERATION_FIND_L_FL1        ]._latence > 0) 
       _function_execute[TYPE_FIND   ][OPERATION_FIND_L_FL1        ] = &(operation_l_fl1     ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MFSPR   ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MFSPR   ] = &(operation_l_mfspr   ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MTSPR   ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MTSPR   ] = &(operation_l_mtspr   ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MAC     ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MAC     ] = &(operation_l_mac     ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MACRC   ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MACRC   ] = &(operation_l_macrc   ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MSB     ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MSB     ] = &(operation_l_msb     ); 
     if (_param->_timing[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_F   ]._latence > 0) 
       _function_execute[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_F   ] = &(operation_l_test_f  );
     if (_param->_timing[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_NF  ]._latence > 0) 
       _function_execute[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_NF  ] = &(operation_l_test_nf );
     if (_param->_timing[TYPE_BRANCH ][OPERATION_BRANCH_L_JALR     ]._latence > 0) 
       _function_execute[TYPE_BRANCH ][OPERATION_BRANCH_L_JALR     ] = &(operation_l_jalr    );
       }

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
