/*
 * $Id: Execution_unit_to_Write_unit.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Execution_unit_to_Write_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::Execution_unit_to_Write_unit"
  Execution_unit_to_Write_unit::Execution_unit_to_Write_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

#if DEBUG_Execution_unit_to_Write_unit == true
    log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	    {
	      if (_param->_have_port_context_id)
              sensitive << (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [i][j]));
              if (_param->_have_port_front_end_id)
	      sensitive << (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [i][j]));
              if (_param->_have_port_ooo_engine_id)
	      sensitive << (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [i][j]));
              if (_param->_have_port_rob_ptr  )
	      sensitive << (*(in_EXECUTE_UNIT_OUT_PACKET_ID     [i][j]));
	      
 	      sensitive << (*(in_EXECUTE_UNIT_OUT_VAL           [i][j]))
		      //<< (*(in_EXECUTE_UNIT_OUT_OPERATION     [i][j]))
		      //<< (*(in_EXECUTE_UNIT_OUT_TYPE          [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_WRITE_RD      [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_NUM_REG_RD    [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_DATA_RD       [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_WRITE_RE      [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_NUM_REG_RE    [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_DATA_RE       [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_EXCEPTION     [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_NO_SEQUENCE   [i][j]))
			<< (*(in_EXECUTE_UNIT_OUT_ADDRESS       [i][j]));
	    }
	for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	  sensitive << (*(in_WRITE_UNIT_IN_ACK [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	    {
	      (*(out_EXECUTE_UNIT_OUT_ACK [i][j])) (*(in_EXECUTE_UNIT_OUT_VAL           [i][j]));
	      if (_param->_have_port_context_id)
	      (*(out_EXECUTE_UNIT_OUT_ACK [i][j])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [i][j]));
	      if (_param->_have_port_front_end_id)
	      (*(out_EXECUTE_UNIT_OUT_ACK [i][j])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [i][j]));
	      if (_param->_have_port_ooo_engine_id)
	      (*(out_EXECUTE_UNIT_OUT_ACK [i][j])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [i][j]));

	      for (uint32_t x=0; x<_param->_nb_write_unit; x++)
		(*(out_EXECUTE_UNIT_OUT_ACK [i][j])) (*(in_WRITE_UNIT_IN_ACK [x])); 
	    }

	for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	  {
	    (*(out_WRITE_UNIT_IN_VAL [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    (*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }
	    if (_param->_have_port_front_end_id)
	      {
	    (*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }
	    if (_param->_have_port_ooo_engine_id)
	      {
	    (*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }

	    if (_param->_have_port_rob_ptr  )
	      {
	    (*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_PACKET_ID [x][y]));
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }

// 	    (*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
// 	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
// 	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
// 	      {
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_OPERATION [x][y]));
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
// 		if (_param->_have_port_context_id)
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
// 		if (_param->_have_port_front_end_id)
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
// 		if (_param->_have_port_ooo_engine_id)
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
// 	      }

// 	    (*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
// 	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
// 	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
// 	      {
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_TYPE [x][y]));
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
// 		if (_param->_have_port_context_id)
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
// 		if (_param->_have_port_front_end_id)
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
// 		if (_param->_have_port_ooo_engine_id)
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
// 	      }

	    (*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_WRITE_RD [x][y]));
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_NUM_REG_RD [x][y]));
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_DATA_RD [x][y]));
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_WRITE_RE [x][y]));
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_NUM_REG_RE [x][y]));
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_DATA_RE [x][y]));
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_EXCEPTION [x][y]));
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_NO_SEQUENCE [x][y]));
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      {
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_ADDRESS [x][y]));
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [x][y]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::~Execution_unit_to_Write_unit"
  Execution_unit_to_Write_unit::~Execution_unit_to_Write_unit (void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
