/*
 * $Id: Decod_request.h 95 2008-12-16 16:24:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Common/include/Test.h"
#include <string>
#include <iostream>
#include <list>

  class entry_t
  {
//public : Tcontrol_t          _val                        ;
  public : Tinstruction_t      _instruction                ;
//public : Tcontext_t          _context_id                 ;
  public : Tgeneral_address_t  _address_previous           ;
  public : Tgeneral_address_t  _address                    ;
  public : Tgeneral_address_t  _address_next               ;
  public : Tbranch_state_t     _branch_state               ;
  public : Tprediction_ptr_t   _branch_update_prediction_id;
  public : Tbranch_condition_t _branch_condition           ;
//public : Tcontrol_t          _branch_stack_write         ;
  public : Tcontrol_t          _branch_direction           ;
  public : Tgeneral_address_t  _branch_address_dest        ;
  public : Tdepth_t            _depth                      ;
  public : Ttype_t             _type                       ;
  public : Toperation_t        _operation                  ;
  public : Tcontrol_t          _no_execute                 ;
  public : Tcontrol_t          _is_delay_slot              ;
  public : Tcontrol_t          _has_immediat               ;
  public : Tgeneral_data_t     _immediat                   ;
  public : Tcontrol_t          _read_ra                    ;
  public : Tgeneral_address_t  _num_reg_ra                 ;
  public : Tcontrol_t          _read_rb                    ;
  public : Tgeneral_address_t  _num_reg_rb                 ;
  public : Tcontrol_t          _read_rc                    ;
  public : Tspecial_address_t  _num_reg_rc                 ;
  public : Tcontrol_t          _write_rd                   ;
  public : Tgeneral_address_t  _num_reg_rd                 ;
  public : Tcontrol_t          _write_re                   ;
  public : Tspecial_address_t  _num_reg_re                 ;
  public : Texception_t        _exception_use              ;
  public : Texception_t        _exception_ifetch           ;
  public : Texception_t        _exception_decod            ;
  public : Tevent_type_t       _context_event_type         ;

  public : entry_t (
// 		    Tcontrol_t          val                        ,
		    Tinstruction_t      instruction                ,
// 		    Tcontext_t          context_id                 ,
		    Tgeneral_address_t  address_previous           ,
		    Tgeneral_address_t  address                    ,
		    Tgeneral_address_t  address_next               ,
		    Tbranch_state_t     branch_state               ,
		    Tprediction_ptr_t   branch_update_prediction_id,
		    Tbranch_condition_t branch_condition           ,
// 		    Tcontrol_t          branch_stack_write         ,
		    Tcontrol_t          branch_direction           ,
		    Tgeneral_address_t  branch_address_dest        ,
		    Tdepth_t            depth                      ,
		    Ttype_t             type                       ,
		    Toperation_t        operation                  ,
// 		    Tcontrol_t          no_execute                 ,
		    Tcontrol_t          is_delay_slot              ,
		    Tcontrol_t          has_immediat               ,
		    Tgeneral_data_t     immediat                   ,
		    Tcontrol_t          read_ra                    ,
		    Tgeneral_address_t  num_reg_ra                 ,
		    Tcontrol_t          read_rb                    ,
		    Tgeneral_address_t  num_reg_rb                 ,
		    Tcontrol_t          read_rc                    ,
		    Tspecial_address_t  num_reg_rc                 ,
		    Tcontrol_t          write_rd                   ,
		    Tgeneral_address_t  num_reg_rd                 ,
		    Tcontrol_t          write_re                   ,
		    Tspecial_address_t  num_reg_re                 ,
		    Texception_t        exception_use              ,
//                     Texception_t        exception_ifetch           ,
//                     Texception_t        exception_decod            ,
		    Tevent_type_t       context_event_type         )
    {
//       _val                         = val                        ;
      _instruction                 = instruction                ;
//       _context_id                  = context_id                 ;
      _address_previous            = address_previous           ;
      _address                     = address                    ;
      _address_next                = address_next               ;
      _branch_state                = branch_state               ;
      _branch_update_prediction_id = branch_update_prediction_id;
      _branch_condition            = branch_condition           ;
//       _branch_stack_write          = branch_stack_write         ;
      _branch_direction            = branch_direction           ;
      _branch_address_dest         = branch_address_dest        ;
      _depth                       = depth                      ;
      _type                        = type                       ;
      _operation                   = operation                  ;
      _is_delay_slot               = is_delay_slot              ;
      _has_immediat                = has_immediat               ;
      _immediat                    = immediat                   ;
      _read_ra                     = read_ra                    ;
      _num_reg_ra                  = num_reg_ra                 ;
      _read_rb                     = read_rb                    ;
      _num_reg_rb                  = num_reg_rb                 ;
      _read_rc                     = read_rc                    ;
      _num_reg_rc                  = num_reg_rc                 ;
      _write_rd                    = write_rd                   ;
      _num_reg_rd                  = num_reg_rd                 ;
      _write_re                    = write_re                   ;
      _num_reg_re                  = num_reg_re                 ;
      _exception_use               = exception_use              ;
      _context_event_type          = context_event_type         ;

      _no_execute                  = 0                          ;
      _exception_ifetch            = EXCEPTION_IFETCH_NONE      ;
      _exception_decod             = EXCEPTION_DECOD_NONE       ;
    }
  };


class Decod_request
{
private : list<entry_t> request;

public  :  Decod_request (void)
  {
    uint32_t w;
    uint32_t x = (0x100>>2)-1;
    uint32_t y = (0x100>>2);
    uint32_t z = (0x100>>2)+1;

#define SEQ    do {x=y; y=z; z+=1; LABEL("%.8x - previous : 0x%x (%d), current : 0x%x (%d), next : 0x%x (%d)",request.back()._instruction, x,x,y,y,z,z);} while(0);
#define JMP(j) do {x=y; y=z; z =j; LABEL("%.8x - previous : 0x%x (%d), current : 0x%x (%d), next : 0x%x (%d)",request.back()._instruction, x,x,y,y,z,z);} while(0);

    // ===== l.add	r15, r4 , r8
    request.push_back (entry_t(
    //instruction,address_previous,address,address_next
    0xe1e44000,x,y,z,
    //branch_state,branch_update_prediction_id,branch_condition,branch_stack_write,branch_direction, branch_address_dest
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0,0x0,
    //depth,type,operation,is_delay_slot
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    //has_immediat,immediat,read_ra,reg_ra,read_rb,reg_rb,read_rc,reg_rc,write_rd,reg_rd,write_re,reg_re
    0,0x00000000,1, 4,1, 8,0,0                 ,1,15,1,SPR_LOGIC_SR_CY_OV,
    //exception_use,context_event_type
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addc	r15, r4 , r31
    request.push_back (entry_t(
    0xe1e4f801,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0,0x0, 
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    0,0x00000000,1, 4,1,31,1,SPR_LOGIC_SR_CY_OV,1,15,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addi	r7 , r12, -1
    request.push_back (entry_t(
    0x9cecffff,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    1,0xffffffff,1,12,0, 0,0,0                 ,1,7 ,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addi	r8 , r17, 0
    request.push_back (entry_t(
    0x9d110000,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    1,0x00000000,1,17,0, 0,0,0                 ,1,8 ,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addi	r21, r7 , 1981
    request.push_back (entry_t(
    0x9ea707bd,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    1,0x000007bd,1, 7,0, 0,0,0                 ,1,21,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addic	r7 , r12, -1
    request.push_back (entry_t(
    0xa0ecffff,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    1,0xffffffff,1,12,0, 0,1,SPR_LOGIC_SR_CY_OV,1,7 ,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addic	r8 , r17, 0
    request.push_back (entry_t(
    0xa1110000,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    1,0x00000000,1,17,0, 0,1,SPR_LOGIC_SR_CY_OV,1,8 ,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.addic	r21, r7 , 1981
    request.push_back (entry_t(
    0xa2a707bd,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_ADD,false, 
    1,0x000007bd,1, 7,0, 0,1,SPR_LOGIC_SR_CY_OV,1,21,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.and	r24, r0 , r14
    request.push_back (entry_t(
    0xe3007003,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_AND,false, 
    0,0x0       ,1, 0,1,14,0,0                 ,1,24,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.andi	r24, r4 , 1981
    request.push_back (entry_t(
    0xa70407bd,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_ALU,OPERATION_ALU_L_AND,false, 
    1,0x000007bd,1, 4,0,0 ,0,0                 ,1,24,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.bf 11
    w = y+(11);
    request.push_back (entry_t(
    0x1000000b,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_SET,0, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_F,false, 
    1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.cmov	r30, r10, r20
    request.push_back (entry_t(
    0xe3caa00e,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MOVE,OPERATION_MOVE_L_CMOV,true,
    0,0x0,1,10,1,20,1,SPR_LOGIC_SR_F    ,1,30,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.div r30,r10,r20
    request.push_back (entry_t(
    0xe3caa309,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_DIV,OPERATION_DIV_L_DIV,false,
    0,0x0,1,10,1,20,0,0                 ,1,30,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.bf -9
    w = y+(-9);
    request.push_back (entry_t(
    0x13fffff7,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_SET,1, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_F,false, 
    1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.divu r30,r10,r20
    request.push_back (entry_t(
    0xe3caa30a,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_DIV,OPERATION_DIV_L_DIVU,true,
    0,0x0,1,10,1,20,0,0                 ,1,30,1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.extbs r30,r10
    request.push_back (entry_t(
    0xe3ca004c,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_S,false,
    1,8  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.bnf 11
    w = y+(11);
    request.push_back (entry_t(
    0x0c00000b,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_UNSET,0, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_NF,false, 
    1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.extbz r30,r10
    request.push_back (entry_t(
    0xe3ca00cc,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_Z,true ,
    1,8  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;
    
    // ===== l.exths r30,r10
    request.push_back (entry_t(
    0xe3ca000c,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_S,false,
    1,16 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.bnf -9
    w = y+(-9);
    request.push_back (entry_t(
    0x0ffffff7,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_FLAG_UNSET,1, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_TEST_NF,false, 
    1,w,0, 0,0,0 ,1,SPR_LOGIC_SR_F    ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.exthz r30,r10
    request.push_back (entry_t(
    0xe3ca008c,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_Z,true ,
    1,16 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.extws r30,r10
    request.push_back (entry_t(
    0xe3ca000d,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_S,false,
    1,32 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.extwz r30,r10
    request.push_back (entry_t(
    0xe3ca004d,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_EXTEND,OPERATION_EXTEND_L_EXTEND_Z,false,
    1,32 ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.csync
    request.push_back (entry_t(
    0x23000000,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_CSYNC,false,
    0,0  ,0,0 ,0,0 ,0,0                 ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_CSYNC));
    SEQ;

    // ===== l.ff1 r30,r10
    request.push_back (entry_t(
    0xe3ca000f,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_FIND,OPERATION_FIND_L_FF1,false,
    0,0  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.fl1 r30,r10
    request.push_back (entry_t(
    0xe3ca010f,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_FIND,OPERATION_FIND_L_FL1,false,
    0,0  ,1,10,0,0 ,0,0                 ,1,30,0,0                 ,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.j 1018
    w = y+(1018);
    request.push_back (entry_t(
    0x000003fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,1, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_NONE,false, 
    0,0,0, 0,0,0 ,0,0                 ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.lbs r30,0x3fa(r10)
    request.push_back (entry_t(
    0x93ca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_8_S,true,
    1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.lbz r30,0x3fa(r10)
    request.push_back (entry_t(
    0x8fca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_8_Z,false,
    1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.j -1018
    w = y+(-1018);
    request.push_back (entry_t(
    0x03fffc06,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,1, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_NONE,false, 
    0,0,0, 0,0,0 ,0,0                 ,0,0 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.lhs r30,0x3fa(r10)
    request.push_back (entry_t(
    0x9bca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_16_S,true,
    1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.lhz r30,0x3fa(r10)
    request.push_back (entry_t(
    0x97ca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_16_Z,false,
    1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.jal 1018
    w = y+(1018);
    request.push_back (entry_t(
    0x040003fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITH_WRITE_STACK,1, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
    1,z+1,0, 0,0,0 ,0,0                 ,1,9 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.lws r30,0x3fa(r10)
    request.push_back (entry_t(
    0x8bca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_32_S,true,
    1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.lwz r30,0x3fa(r10)
    request.push_back (entry_t(
    0x87ca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_32_Z,false,
    1,0x3fa,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.jal -1018
    w = y+(-1018);
    request.push_back (entry_t(
    0x07fffc06,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITH_WRITE_STACK,1, w,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
    1,z+1,0, 0,0,0 ,0,0                 ,1,9 ,0,0                 ,
    EXCEPTION_USE_NONE ,EVENT_TYPE_NONE));
    JMP(w);

    // ===== l.ld r30,1018(r10)
    request.push_back (entry_t(
    0x83ca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_64_S,true,
    1,1018,1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.ld r30,-1018(r10)
    request.push_back (entry_t(
    0x83cafc06,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_MEMORY,OPERATION_MEMORY_LOAD_64_S,false,
    1,static_cast<Tgeneral_data_t>(-1018),1,10,0,0 ,0,0,1,30,0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.jalr r20
    request.push_back (entry_t(
    0x4800a000,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK,1, z, // branch_address_dest can be determined if BRANCH_STATE != NONE (also : previous prediction)
    0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
    0,0   ,0,0 ,1,20,0,0,1,9 ,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;
    
    // ===== l.mac r10,r20
    request.push_back (entry_t(
    0xc40aa001,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC,true,
    0,0,1,10,1,20,0,0,0,0,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;
    
    // ===== l.maci r10,1018
    request.push_back (entry_t(
    0x4c0a03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC,false,
    1,1018,1,10,0,0,0,0,0,0,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.maci r10,-1018
    request.push_back (entry_t(
    0x4fea0406,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MAC,false,
    1,static_cast<Tgeneral_data_t>(-1018),1,10,0,0,0,0,0,0,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;
    
    // ===== l.jr r10
    request.push_back (entry_t(
    0x44005000,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_READ_REGISTER_WITHOUT_WRITE_STACK,1, z,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
    0,0   ,0, 0,1,10,0,0,0,0 ,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;
    
    // ===== l.macrc r30
    request.push_back (entry_t(
    0x1bc10000,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MACRC,true,
    0,0,0, 0,0, 0,0,0,1,30,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.mfspr r30,r10,1018
    request.push_back (entry_t(
    0xb7ca03fa,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MFSPR,false,
    1,1018,1,10,0, 0,0,0,1,30,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.mfspr r30,r10,-1018
    request.push_back (entry_t(
    0xb7cafc06,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK,0, 0x0,
    0,TYPE_SPECIAL,OPERATION_SPECIAL_L_MFSPR,false,
    1,0xfc06,1,10,0, 0,0,0,1,30,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.jr r9 
    request.push_back (entry_t(
    0x44004800,x,y,z,
    BRANCH_STATE_NONE,0,BRANCH_CONDITION_READ_STACK,1, z,
    0,TYPE_BRANCH,OPERATION_BRANCH_L_JALR,false,
    0,0   ,0, 0,1,9,0,0,0,0 ,0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;
          
    // ===== l.movhi r30,0x3fa
    request.push_back (entry_t(
    0x1bc003fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_MOVE,OPERATION_MOVE_L_MOVHI,true,
    1,0x3fa,0,0, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;
    
    // ===== l.movhi r30,0xfc06
    request.push_back (entry_t(
    0x1bc0fc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_MOVE,OPERATION_MOVE_L_MOVHI,false,
    1,0xfc06,0,0, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.msb r10,r20
    request.push_back (entry_t(
    0xc40aa002,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_MSB,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.msync
    request.push_back (entry_t(
    0x22000000,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_MSYNC,false,
    0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_MSYNC));
    SEQ;

    // ===== l.mtspr r10,r20,0x3fa
    request.push_back (entry_t(
    0xc00aa3fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_MTSPR,false,
    1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.mtspr r10,r20,0xfc06
    request.push_back (entry_t(
    0xc3eaa406,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_MTSPR,false,
    1,0xfc06, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_SPR_ACCESS));
    SEQ;

    // ===== l.mul r30,r10,r20
    request.push_back (entry_t(
    0xe3caa306,x,y,z,
    0,0,0,0,0,0,
    TYPE_MUL,OPERATION_MUL_L_MUL,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.muli r30,r10,0x3fa
    request.push_back (entry_t(
    0xb3ca03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_MUL,OPERATION_MUL_L_MUL,false,
    1,0x3fa, 1,10, 0,0, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.muli r30,r10,0xfffffc06
    request.push_back (entry_t(
    0xb3cafc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_MUL,OPERATION_MUL_L_MUL,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.mulu r30,r10,r20
    request.push_back (entry_t(
    0xe3caa30b,x,y,z,
    0,0,0,0,0,0,
    TYPE_MUL,OPERATION_MUL_L_MULU,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.nop 0x3fa
    request.push_back (entry_t(
    0x150003fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP,false,
    0,0x3fa, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.nop 0xfc06
    request.push_back (entry_t(
    0x1500fc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_NOP,false,
    0,0xfc06, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.or r30,r10,r20
    request.push_back (entry_t(
    0xe3caa004,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_OR,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.ori r30,r10,0x3fa
    request.push_back (entry_t(
    0xabca03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_OR,false,
    1,0x3fa, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.ori r30,r10,0xfc06
    request.push_back (entry_t(
    0xabcafc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_OR,false,
    1,0xfc06, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.psync
    request.push_back (entry_t(
    0x22800000,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_PSYNC,false,
    0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_PSYNC));
    SEQ;

    // ===== l.ror r30,r10,r20
    request.push_back (entry_t(
    0xe3caa0c8,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_ROR,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.rori r30,r10,0x3f
    request.push_back (entry_t(
    0xbbca00ff,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_ROR,false,
    1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.rori r30,r10,0x1
    request.push_back (entry_t(
    0xbbca00c1,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_ROR,false,
    1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sb 0x3fa(r10),r20
    request.push_back (entry_t(
    0xd80aa3fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_8,false,
    1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sb 0xfffffc06(r10),r20
    request.push_back (entry_t(
    0xdbeaa406,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_8,false,
    1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sd 0x3fa(r10),r20
    request.push_back (entry_t(
    0xd00aa3fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_64,false,
    1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sd 0xfffffc06(r10),r20
    request.push_back (entry_t(
    0xd3eaa406,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_64,false,
    1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sh 0x3fa(r10),r20
    request.push_back (entry_t(
    0xdc0aa3fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_16,false,
    1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sh 0xfffffc06(r10),r20
    request.push_back (entry_t(
    0xdfeaa406,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_16,false,
    1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sw 0x3fa(r10),r20
    request.push_back (entry_t(
    0xd40aa3fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_32,false,
    1,0x3fa, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sw 0xfffffc06(r10),r20
    request.push_back (entry_t(
    0xd7eaa406,x,y,z,
    0,0,0,0,0,0,
    TYPE_MEMORY,OPERATION_MEMORY_STORE_32,false,
    1,0xfffffc06, 1,10, 1,20, 0,0, 0,0, 0,0,
    EXCEPTION_USE_MEMORY_WITH_ALIGNMENT,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sll r30,r10,r20
    request.push_back (entry_t(
    0xe3caa008,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SLL,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.slli r30,r10,0x1
    request.push_back (entry_t(
    0xbbca0001,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SLL,false,
    1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.slli r30,r10,0x3f
    request.push_back (entry_t(
    0xbbca003f,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SLL,false,
    1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sra r30,r10,r20
    request.push_back (entry_t(
    0xe3caa088,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SRA,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.srai r30,r10,0x1
    request.push_back (entry_t(
    0xbbca0081,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SRA,false,
    1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.srai r30,r10,0x3f
    request.push_back (entry_t(
    0xbbca00bf,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SRA,false,
    1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.srl r30,r10,r20
    request.push_back (entry_t(
    0xe3caa048,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SRL,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.srli r30,r10,0x1
    request.push_back (entry_t(
    0xbbca0041,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SRL,false,
    1,0x1, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.srli r30,r10,0x3f
    request.push_back (entry_t(
    0xbbca007f,x,y,z,
    0,0,0,0,0,0,
    TYPE_SHIFT,OPERATION_SHIFT_L_SRL,false,
    1,0x3f, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.xor r30,r10,r20
    request.push_back (entry_t(
    0xe3caa005,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_XOR,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.xori r30,r10,0x3fa
    request.push_back (entry_t(
    0xafca03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_XOR,false,
    1,0x3fa, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.xori r30,r10,0xfffffc06
    request.push_back (entry_t(
    0xafcafc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_XOR,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 1,30, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sub r30,r10,r20
    request.push_back (entry_t(
    0xe3caa002,x,y,z,
    0,0,0,0,0,0,
    TYPE_ALU,OPERATION_ALU_L_SUB,false,
    0,0, 1,10, 1,20, 0,0, 1,30, 1,SPR_LOGIC_SR_CY_OV,
    EXCEPTION_USE_RANGE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sys 0x3fa
    request.push_back (entry_t(
    0x200003fa,x,y,z,
    0,0,0,0,z,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_SYS,false,
    0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_SYSCALL,EVENT_TYPE_EXCEPTION));
    SEQ;

    // ===== l.sys 0xfc06
    request.push_back (entry_t(
    0x2000fc06,x,y,z,
    0,0,0,0,z,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_SYS,false,
    0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_SYSCALL,EVENT_TYPE_EXCEPTION));
    SEQ;

    // ===== l.trap 0x3fa
    request.push_back (entry_t(
    0x210003fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_TRAP,false,
    1,0x3fa, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_TRAP,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.trap 0xfc06
    request.push_back (entry_t(
    0x2100fc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_TRAP,false,
    1,0xfc06, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_TRAP,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.rfe
    request.push_back (entry_t(
    0x24000000,x,y,z,
    0,0,0,0,0,0,
    TYPE_SPECIAL,OPERATION_SPECIAL_L_RFE,false,
    0,0, 0,0, 0,0, 0,0, 0,0, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfeq r10,r20
    request.push_back (entry_t(
    0xe40aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFEQ,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfeqi r10,0x3fa
    request.push_back (entry_t(
    0xbc0a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFEQ,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfeqi r10,0xfffffc06
    request.push_back (entry_t(
    0xbc0afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFEQ,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfne r10,r20
    request.push_back (entry_t(
    0xe42aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFNE,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfnei r10,0x3fa
    request.push_back (entry_t(
    0xbc2a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFNE,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfnei r10,0xfffffc06
    request.push_back (entry_t(
    0xbc2afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFNE,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfges r10,r20
    request.push_back (entry_t(
    0xe56aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGES,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgesi r10,0x3fa
    request.push_back (entry_t(
    0xbd6a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGES,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgesi r10,0xfffffc06
    request.push_back (entry_t(
    0xbd6afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGES,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgeu r10,r20
    request.push_back (entry_t(
    0xe46aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGEU,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgeui r10,0x3fa
    request.push_back (entry_t(
    0xbc6a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGEU,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgeui r10,0xfffffc06
    request.push_back (entry_t(
    0xbc6afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGEU,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgts r10,r20
    request.push_back (entry_t(
    0xe54aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGTS,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgtsi r10,0x3fa
    request.push_back (entry_t(
    0xbd4a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGTS,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgtsi r10,0xfffffc06
    request.push_back (entry_t(
    0xbd4afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGTS,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgtu r10,r20
    request.push_back (entry_t(
    0xe44aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGTU,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgtui r10,0x3fa
    request.push_back (entry_t(
    0xbc4a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGTU,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfgtui r10,0xfffffc06
    request.push_back (entry_t(
    0xbc4afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFGTU,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfles r10,r20
    request.push_back (entry_t(
    0xe5aaa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLES,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sflesi r10,0x3fa
    request.push_back (entry_t(
    0xbdaa03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLES,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sflesi r10,0xfffffc06
    request.push_back (entry_t(
    0xbdaafc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLES,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfleu r10,r20
    request.push_back (entry_t(
    0xe4aaa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLEU,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfleui r10,0x3fa
    request.push_back (entry_t(
    0xbcaa03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLEU,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfleui r10,0xfffffc06
    request.push_back (entry_t(
    0xbcaafc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLEU,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sflts r10,r20
    request.push_back (entry_t(
    0xe58aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLTS,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfltsi r10,0x3fa
    request.push_back (entry_t(
    0xbd8a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLTS,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfltsi r10,0xfffffc06
    request.push_back (entry_t(
    0xbd8afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLTS,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfltu r10,r20
    request.push_back (entry_t(
    0xe48aa000,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLTU,false,
    0,0, 1,10, 1,20, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfltui r10,0x3fa
    request.push_back (entry_t(
    0xbc8a03fa,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLTU,false,
    1,0x3fa, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.sfltui r10,0xfffffc06
    request.push_back (entry_t(
    0xbc8afc06,x,y,z,
    0,0,0,0,0,0,
    TYPE_TEST,OPERATION_TEST_L_SFLTU,false,
    1,0xfffffc06, 1,10, 0,0, 0,0, 0,0, 1,SPR_LOGIC_SR_F,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.cust4 (encrypt)
    request.push_back (entry_t(
    0x7de80000,x,y,z,
    0,0,0,0,0,0,
    TYPE_CUSTOM,OPERATION_CUSTOM_L_4,false,
    0,0x0, 1, 8, 0,0, 0,0, 1,15, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;

    // ===== l.cust8 (decrypt)
    request.push_back (entry_t(
    0xfde80000,x,y,z,
    0,0,0,0,0,0,
    TYPE_CUSTOM,OPERATION_CUSTOM_L_8,false,
    0,0x0, 1, 8, 0,0, 0,0, 1,15, 0,0,
    EXCEPTION_USE_NONE,EVENT_TYPE_NONE));
    SEQ;
  }

public : uint32_t size (void)
  {
    return request.size();
  }
  
public : list<entry_t>::iterator begin (void)
  {
    return request.begin();
  }

public : list<entry_t>::iterator end (void)
  {
    return request.end();
  }

public : entry_t front (void)
  {
    return request.front();
  }

public : void pop_front (void)
  {
    request.pop_front();
  }

};
