/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {


#undef  FUNCTION
#define FUNCTION "Front_end_Glue::Parameters"
  Parameters::Parameters (uint32_t                nb_context                           ,
                          uint32_t                nb_decod_unit                        ,
                          uint32_t              * nb_inst_decod                        ,
                          uint32_t                nb_inst_branch_complete              ,
                          uint32_t              * link_context_to_decod_unit           ,
                          std::vector<uint32_t> * translate_context_id_from_decod_unit ,
                          uint32_t                size_address                         ,
                          uint32_t              * size_depth                           ,
                          uint32_t              * nb_branch_speculated                 ,
                          uint32_t                is_toplevel):
    morpheo::behavioural::Parameters()
  {
    log_begin(Front_end_Glue,FUNCTION);

    _nb_context                           = nb_context                          ;
    _nb_decod_unit                        = nb_decod_unit                       ;
    _nb_inst_decod                        = nb_inst_decod                       ;
    _nb_inst_branch_complete              = nb_inst_branch_complete             ;
    _link_context_to_decod_unit           = link_context_to_decod_unit          ;
    _translate_context_id_from_decod_unit = translate_context_id_from_decod_unit;
    _nb_branch_speculated                 = nb_branch_speculated                ;

    _decod_unit_nb_context                = new uint32_t [_nb_decod_unit];

    for (uint32_t i=0; i<_nb_decod_unit; i++)
      {
        _decod_unit_nb_context           [i] = translate_context_id_from_decod_unit[i].size();
      }

    test();

    if (is_toplevel)
      {
        _size_context_id          = log2(_nb_context);
        _size_instruction_address = size_address;
        _size_depth               = max<uint32_t>(size_depth,_nb_context);
        
        _have_port_context_id     = _size_context_id > 0;
        _have_port_depth          = _size_depth > 0;

        copy ();
      }

    log_end(Front_end_Glue,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Front_end_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Front_end_Glue,FUNCTION);
//     test();
//     log_end(Front_end_Glue,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Front_end_Glue::~Parameters"
  Parameters::~Parameters () 
  {
    log_begin(Front_end_Glue,FUNCTION);

    delete [] _decod_unit_nb_context;

    log_end(Front_end_Glue,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Front_end_Glue::copy"
  void Parameters::copy (void) 
  {
    log_begin(Front_end_Glue,FUNCTION);
    
    log_end(Front_end_Glue,FUNCTION);
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
