#ifndef morpheo_behavioural_core_multi_front_end_front_end_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_Parameters_h

/*
 * $Id: Parameters.h 95 2008-12-16 16:24:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"
#include "Behavioural/Custom/include/Custom.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Parameters.h"

#include <vector> 

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t                _nb_context                           ;
  public : uint32_t                _nb_decod_unit                        ;
//public : uint32_t                _size_general_data                    ;
  public : morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (void);
    // ifetch_unit                                              
  public : uint32_t              * _size_ifetch_queue                    ;//[nb_context]
  public : uint32_t              * _nb_inst_fetch                        ;//[nb_context]
  public : bool                 ** _instruction_implemeted               ;//[nb_context][nb_inst_fetch]
  public : uint32_t              * _link_context_to_decod_unit           ;//[nb_context]
    // decod_unit                                                        
  public : uint32_t              * _size_decod_queue                     ;//[nb_decod_unit]
  public : uint32_t              * _nb_inst_decod                        ;//[nb_decod_unit]
  public : uint32_t              * _nb_context_select                    ;//[nb_decod_unit]
  public : Tpriority_t           * _context_select_priority              ;//[nb_decod_unit]
  public : Tload_balancing_t     * _context_select_load_balancing        ;//[nb_decod_unit]
    // prediction_unit                                                   
  public : uint32_t                _nb_inst_branch_predict               ;
  public : uint32_t                _nb_inst_branch_decod                 ;
  public : uint32_t                _nb_inst_branch_update                ;
  public : uint32_t                _nb_inst_branch_complete              ;
  public : uint32_t                _btb_size_queue                       ;
  public : uint32_t                _btb_associativity                    ;
  public : uint32_t                _btb_size_counter                     ;
  public : Tvictim_t               _btb_victim_scheme                    ;
  public : Tpredictor_t            _dir_predictor_scheme                 ;
  public : bool                    _dir_have_bht               [3]       ;
  public : uint32_t                _dir_bht_size_shifter       [3]       ;
  public : uint32_t                _dir_bht_nb_shifter         [3]       ;
  public : bool                    _dir_have_pht               [3]       ;
  public : uint32_t                _dir_pht_size_counter       [3]       ;
  public : uint32_t                _dir_pht_nb_counter         [3]       ;
  public : uint32_t                _dir_pht_size_address_share [3]       ;
  public : uint32_t              * _ras_size_queue                       ;//[nb_context]
  public : uint32_t              * _upt_size_queue                       ;//[nb_context]
  public : uint32_t              * _ufpt_size_queue                      ;//[nb_context]

    // context_state                                                     
//public : uint32_t                _size_nb_inst_commit                  ;
                                                                         
  public : std::vector<uint32_t> * _translate_context_id_from_decod_unit ;//[nb_decod_unit]
  public : uint32_t              * _decod_unit_nb_context                ;//[nb_decod_unit]
  public : uint32_t             ** _decod_unit_nb_inst_fetch             ;//[nb_decod_unit][decod_unit_nb_context]
  public : uint32_t             ** _decod_unit_nb_branch_speculated      ;//[nb_decod_unit][decod_unit_nb_context]
//public : uint32_t             ** _decod_unit_depth                     ;//[nb_decod_unit][decod_unit_nb_context]
  public : bool                *** _decod_unit_instruction_implemeted    ;//[nb_decod_unit][decod_unit_nb_context][nb_instruction]
  public : uint32_t                _sum_inst_decod                       ;
                                                                         
//public : uint32_t                _size_context_id                      ;
//public : uint32_t                _size_address                         ;
  public : uint32_t              * _array_size_nb_inst_decod             ;//[nb_decod_unit]
  public : uint32_t              * _array_size_depth                     ;//[nb_context]
//public : uint32_t                _max_size_depth                       ;
//public : uint32_t              * _size_ifetch_queue_ptr                ;//[nb_context]
                                                                         
//public : bool                  * _have_port_decod_unit_context_id      ;//[nb_decod_unit]
//public : bool                    _have_port_context_id                 ;
//public : bool                  * _have_port_ifetch_queue_ptr           ;//[nb_context]
//public : bool                  * _have_port_depth                      ;//[nb_context]
//public : bool                    _have_port_max_depth                  ;
//public : bool                  * _have_port_instruction_ptr            ;//[nb_context]
//public : bool                  * _have_port_branch_update_prediction_id;//[nb_context]

  public : behavioural::core::multi_front_end::front_end::ifetch_unit::    Parameters ** _param_ifetch_unit    ;
  public : behavioural::core::multi_front_end::front_end::prediction_unit::Parameters  * _param_prediction_unit;
  public : behavioural::core::multi_front_end::front_end::decod_unit::     Parameters ** _param_decod_unit     ;
  public : behavioural::core::multi_front_end::front_end::context_state::  Parameters  * _param_context_state  ;
  public : behavioural::core::multi_front_end::front_end::front_end_glue:: Parameters  * _param_glue           ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t                nb_context                          ,
                        uint32_t                nb_decod_unit                       ,
                        uint32_t                size_general_data                   ,
                        morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),
                        // ifetch_unit                                              
                        uint32_t              * size_ifetch_queue                   ,
                        uint32_t              * nb_inst_fetch                       ,
                        bool                 ** instruction_implemeted              ,
                        uint32_t              * link_context_to_decod_unit          ,
                        // decod_unit                                              
                        uint32_t              * size_decod_queue                    ,
                        uint32_t              * nb_inst_decod                       ,
                        uint32_t              * nb_context_select                   ,
                        Tpriority_t           * context_select_priority             ,
                        Tload_balancing_t     * context_select_load_balancing       ,
                        // prediction_unit                                                 
                        uint32_t                nb_inst_branch_predict              ,
                        uint32_t                nb_inst_branch_decod                ,
                        uint32_t                nb_inst_branch_update               ,
                        uint32_t                nb_inst_branch_complete             ,
                        uint32_t                btb_size_queue                      ,
                        uint32_t                btb_associativity                   ,
                        uint32_t                btb_size_counter                    ,
                        Tvictim_t               btb_victim_scheme                   ,
                        Tpredictor_t            dir_predictor_scheme                ,
                        bool                  * dir_have_bht                        ,//[3]
                        uint32_t              * dir_bht_size_shifter                ,//[3]
                        uint32_t              * dir_bht_nb_shifter                  ,//[3]
                        bool                  * dir_have_pht                        ,//[3]
                        uint32_t              * dir_pht_size_counter                ,//[3]
                        uint32_t              * dir_pht_nb_counter                  ,//[3]
                        uint32_t              * dir_pht_size_address_share          ,//[3]
                        uint32_t              * ras_size_queue                      ,
                        uint32_t              * upt_size_queue                      ,
                        uint32_t              * ufpt_size_queue                     ,
                        // context_state                                           
                        uint32_t                size_nb_inst_commit                 ,

                        bool                    is_toplevel=false);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::Parameters & x);
  };

}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
