/*
 * $Id: Parameters.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {


#undef  FUNCTION
#define FUNCTION "Rename_select::Parameters"
  Parameters::Parameters (uint32_t          nb_front_end         ,
			  uint32_t *        nb_context           ,
//                           uint32_t          size_front_end_id    ,
//                           uint32_t          size_context_id      ,
			  uint32_t          max_branch_speculated,
			  uint32_t          size_general_data    ,
			  uint32_t          nb_inst_rename       ,
			  uint32_t *        nb_inst_decod        ,
			  uint32_t          nb_front_end_select  ,
			  Tpriority_t       priority             ,
			  Tload_balancing_t load_balancing       ,
                          bool              is_toplevel)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

    _nb_front_end          = nb_front_end         ;
    _nb_context            = nb_context           ;
    _max_branch_speculated = max_branch_speculated;
    _nb_inst_rename        = nb_inst_rename       ;
    _nb_inst_decod         = nb_inst_decod        ;
    _nb_front_end_select   = nb_front_end_select  ;
    _priority              = priority             ;
    _load_balancing        = load_balancing       ;

    _max_nb_inst_decod     = max<uint32_t>(nb_inst_decod,nb_front_end);

    test();

    if (is_toplevel)
      {
        _size_instruction_address = size_general_data-2;
        _size_general_data        = size_general_data    ;
        _size_depth               = log2(max_branch_speculated);
        _size_front_end_id        = log2(_nb_front_end);
        _size_context_id          = log2(max<uint32_t>(_nb_context,_nb_front_end));
                                  
        _have_port_front_end_id   = _size_front_end_id > 0;
        _have_port_context_id     = _size_context_id   > 0;
        _have_port_depth          = _size_depth        > 0;
        
        copy();
      }

    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Rename_select::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Rename_select,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Rename_select,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Rename_select::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");
    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Rename_select::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");
    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
