/*
 * $Id: Configuration.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Configuration.h"
#include "Behavioural/include/Simulation.h"
#include "Common/include/Environment.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Configuration::Configuration"
  Configuration::Configuration (std::string filename_simulator,
                                std::string filename_generator,
                                std::string filename_instance ,
                                behavioural::custom::custom_information_t (*get_custom_information) (void))
  {
    log_begin(Configuration,FUNCTION);

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Simulator configuration
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    _simulator = new Simulator (filename_simulator);

    //--------------------------------------------------
    // Directory
    //--------------------------------------------------
    directory_init (_simulator->getParam("directory_statistics"),
                    _simulator->getParam("directory_vhdl"      ),
                    _simulator->getParam("directory_position"  ),
                    _simulator->getParam("directory_log"       ));

    //--------------------------------------------------
    // Debug & Log File
    //--------------------------------------------------
    debug_init (fromString<debug_verbosity_t>(_simulator->getParam("debug_level")));

    log_init(fromString<bool>(_simulator->getParam("debug_have_log_file")),
             MORPHEO_LOG);

    //--------------------------------------------------
    // Usage
    //--------------------------------------------------
    _usage     = USE_NONE;
    
    if (fromString<bool>(_simulator->getParam("use_systemc")))
      _usage = usage_set(_usage, USE_SYSTEMC);
    if (fromString<bool>(_simulator->getParam("use_vhdl")))
      _usage = usage_set(_usage, USE_VHDL);
    if (fromString<bool>(_simulator->getParam("use_vhdl_testbench")))
      _usage = usage_set(_usage, USE_VHDL_TESTBENCH);
    if (fromString<bool>(_simulator->getParam("use_vhdl_testbench_assert")))
      _usage = usage_set(_usage, USE_VHDL_TESTBENCH_ASSERT);
    if (fromString<bool>(_simulator->getParam("use_position")))
      _usage = usage_set(_usage, USE_POSITION);
    if (fromString<bool>(_simulator->getParam("use_statistics")))
      _usage = usage_set(_usage, USE_STATISTICS);
    if (fromString<bool>(_simulator->getParam("use_information")))
      _usage = usage_set(_usage, USE_INFORMATION);
    if (fromString<bool>(_simulator->getParam("use_header")))
      _usage = usage_set(_usage, USE_HEADER);

    usage_environment (_usage);

    //--------------------------------------------------
    // Header
    //--------------------------------------------------

    if (usage_is_set(_usage,USE_HEADER))
      std::cout << header();

    //--------------------------------------------------
    // Parameters_Statistics
    //--------------------------------------------------
    _param_statistics = new Parameters_Statistics (fromString<uint64_t>(_simulator->getParam("nb_cycle_before_begin")),
                                                   fromString<uint64_t>(_simulator->getParam("period_save")));

    //--------------------------------------------------
    // Simulation condition stop 
    //--------------------------------------------------
    simulation_init (fromString<double>(_simulator->getParam("simulation_nb_cycle")),
                     fromString<double>(_simulator->getParam("simulation_nb_instruction")));


    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Generator configuration + Instance
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    _generator = new Generator (filename_generator);
    _instance  = new Instance  (filename_instance ,
                                _generator,
                                get_custom_information);

    //--------------------------------------------------
    // Name
    //--------------------------------------------------
    _name      = _instance->getName();

    //--------------------------------------------------
    // Parameters
    //--------------------------------------------------
    _param     = _instance->_param;


    log_end(Configuration,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Configuration::~Configuration"
  Configuration::~Configuration () 
  {
    log_begin(Configuration,FUNCTION);

    delete _simulator;
    delete _generator;
    delete _instance;
    delete _param_statistics;

    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
