#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_insert.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_insert"
  void Core_Glue::genMealy_insert (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_execute_loop_nb_ooo_engine[i]; ++j)
        {
          Tcontext_t num_ooo_engine   = _param->_translate_execute_loop_num_ooo_engine [i][j];

          for (uint32_t k=0; k<_param->_execute_loop_nb_inst_insert[i][j]; ++k)
            {
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_VAL        [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_VAL        [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_OOO_ENGINE_ACK          [i][j]   ,PORT_READ(in_INSERT_EXECUTE_LOOP_ACK      [i][j][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RD_USE     [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RD_USE     [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RD_NUM_REG [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RD_NUM_REG [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RE_USE     [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RE_USE     [num_ooo_engine][k]));
              PORT_WRITE(out_INSERT_EXECUTE_LOOP_RE_NUM_REG [i][j][k],PORT_READ(in_INSERT_OOO_ENGINE_RE_NUM_REG [num_ooo_engine][k]));
            }
        }

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
