/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/SelfTest/include/test.h"

#define NB_PARAMS 2

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - size_queue (uint32_t)" << endl
       << " - size_data  (uint32_t)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;
  
  const string   name       =      argv[x++];
  const uint32_t size_queue = atoi(argv[x++]);
  const uint32_t size_data  = atoi(argv[x++]);

  try 
    {
      morpheo::behavioural::generic::queue::Parameters * param = new morpheo::behavioural::generic::queue::Parameters
	(size_queue,
	 size_data
        );
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

