/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Prediction_unit_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {

#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::allocation"
  void Prediction_unit_Glue::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
                                              ,"Prediction_unit_Glue"
#ifdef POSITION
                                              ,COMBINATORY 
#endif
                                              );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
                                                         ,IN
                                                         ,SOUTH,
                                                         "Generalist interface"
#endif
                                                         );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      {
        ALLOC1_INTERFACE("predict",IN,SOUTH,"Interface with ifetch unit",_param->_nb_context);
        
        ALLOC1_VALACK_IN ( in_PREDICT_VAL                        ,VAL);
        ALLOC1_VALACK_OUT(out_PREDICT_ACK                        ,ACK);
        ALLOC1_SIGNAL_IN ( in_PREDICT_PC_PREVIOUS                ,"pc_previous"                ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_PREDICT_PC_CURRENT                 ,"pc_current"                 ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,"pc_current_is_ds_take"      ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_PREDICT_PC_NEXT                    ,"pc_next"                    ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,"pc_next_is_ds_take"         ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_PREDICT_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t ,_param->_size_inst_ifetch_ptr);
        ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state);
        ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth);
      }
      {
        ALLOC2_INTERFACE("predict",IN,SOUTH,"Interface with ifetch unit",_param->_nb_context,_param->_nb_instruction[it1]);
        _ALLOC2_SIGNAL_OUT(out_PREDICT_INSTRUCTION_ENABLE         ,"instruction_enable"         ,Tcontrol_t         ,1,_param->_nb_context,_param->_nb_instruction[it1]);
      }
      
      {
        ALLOC1_INTERFACE("predict_btb",OUT,NORTH,"Interface with ifetch unit",_param->_nb_inst_branch_predict);
        
        ALLOC1_VALACK_OUT(out_PREDICT_BTB_VAL         ,VAL);
        ALLOC1_VALACK_IN ( in_PREDICT_BTB_ACK         ,ACK);
        ALLOC1_SIGNAL_OUT(out_PREDICT_BTB_CONTEXT_ID  ,"context_id"  ,Tcontext_t         ,_param->_size_context_id);
        ALLOC1_SIGNAL_OUT(out_PREDICT_BTB_ADDRESS     ,"address"     ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_HIT         ,"hit"         ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_ADDRESS_SRC ,"address_src" ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_ADDRESS_DEST,"address_dest",Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_CONDITION   ,"condition"   ,Tbranch_condition_t,_param->_size_branch_condition);
//      ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_LAST_TAKE   ,"last_take"   ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_IS_ACCURATE ,"is_accurate" ,Tcontrol_t         ,1);
      }
      
      {
        ALLOC1_INTERFACE("predict_dir",OUT,NORTH,"Interface with ifetch unit",_param->_nb_inst_branch_predict);
        
        ALLOC1_VALACK_OUT(out_PREDICT_DIR_VAL        ,VAL);
        ALLOC1_VALACK_IN ( in_PREDICT_DIR_ACK        ,ACK);
        ALLOC1_SIGNAL_OUT(out_PREDICT_DIR_ADDRESS_SRC,"address_src",Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_PREDICT_DIR_STATIC     ,"static"     ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_OUT(out_PREDICT_DIR_LAST_TAKE  ,"last_take"  ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_IN ( in_PREDICT_DIR_HISTORY    ,"history"    ,Thistory_t         ,_param->_size_history);
        ALLOC1_SIGNAL_IN ( in_PREDICT_DIR_DIRECTION  ,"direction"  ,Tcontrol_t         ,1);
      }
      
      {
        ALLOC1_INTERFACE("predict_ras",OUT,NORTH,"Interface with ifetch unit",_param->_nb_inst_branch_predict);
        
        ALLOC1_VALACK_OUT(out_PREDICT_RAS_VAL         ,VAL);
        ALLOC1_VALACK_IN ( in_PREDICT_RAS_ACK         ,ACK);
        ALLOC1_SIGNAL_OUT(out_PREDICT_RAS_CONTEXT_ID  ,"context_id"  ,Tcontext_t         ,_param->_size_context_id);
        ALLOC1_SIGNAL_IN ( in_PREDICT_RAS_HIT         ,"hit"         ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_PREDICT_RAS_PUSH        ,"push"        ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_PREDICT_RAS_ADDRESS_PUSH,"address_push",Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_PREDICT_RAS_ADDRESS_POP ,"address_pop" ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_IN ( in_PREDICT_RAS_INDEX       ,"index"       ,Tptr_t             ,_param->_size_ras_index);
      }
      
      {
        ALLOC1_INTERFACE("predict_upt",OUT,NORTH,"Interface with ifetch unit",_param->_nb_inst_branch_predict);
        
        ALLOC1_VALACK_OUT(out_PREDICT_UPT_VAL             ,VAL);
        ALLOC1_VALACK_IN ( in_PREDICT_UPT_ACK             ,ACK);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_CONTEXT_ID      ,"context_id"      ,Tcontext_t         ,_param->_size_context_id);
        ALLOC1_SIGNAL_IN ( in_PREDICT_UPT_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_BTB_ADDRESS_SRC ,"btb_address_src" ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_BTB_ADDRESS_DEST,"btb_address_dest",Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_BTB_CONDITION   ,"btb_condition"   ,Tbranch_condition_t,_param->_size_branch_condition);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_BTB_LAST_TAKE   ,"btb_last_take"   ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_BTB_IS_ACCURATE ,"btb_is_accurate" ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_DIR_HISTORY     ,"dir_history"     ,Thistory_t         ,_param->_size_history);
        ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_RAS_ADDRESS     ,"ras_address"     ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_OUT(out_PREDICT_UPT_RAS_INDEX       ,"ras_index"       ,Tptr_t             ,_param->_size_ras_index);
      }
    }
    
    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~            
    {
      {
        ALLOC2_INTERFACE("decod",IN,SOUTH,"Interface with decod unit",_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        
        _ALLOC2_VALACK_IN ( in_DECOD_VAL                        ,VAL,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_VALACK_OUT(out_DECOD_ACK                        ,ACK,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t         ,_param->_size_context_id      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_MATCH_INST_IFETCH_PTR      ,"match_inst_ifetch_ptr"      ,Tcontrol_t         ,1                             ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state    ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_CONDITION           ,"branch_condition"           ,Tbranch_condition_t,_param->_size_branch_condition,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_DIRECTION           ,"branch_direction"           ,Tcontrol_t         ,1                             ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_ADDRESS_SRC                ,"address_src"                ,Taddress_t         ,_param->_size_instruction_address         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
        _ALLOC2_SIGNAL_IN ( in_DECOD_ADDRESS_DEST               ,"address_dest"               ,Taddress_t         ,_param->_size_instruction_address         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
      }

      {
        ALLOC1_INTERFACE("decod_btb",OUT,NORTH,"Interface with decod unit",_param->_nb_inst_branch_decod);

        ALLOC1_VALACK_OUT(out_DECOD_BTB_VAL            ,VAL);
        ALLOC1_VALACK_IN ( in_DECOD_BTB_ACK            ,ACK);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_CONTEXT_ID     ,"context_id"     ,Tcontext_t         ,_param->_size_context_id);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_ADDRESS_SRC    ,"address_src"    ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_ADDRESS_DEST   ,"address_dest"   ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_CONDITION      ,"condition"      ,Tbranch_condition_t,_param->_size_branch_condition);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_LAST_TAKE      ,"last_take"      ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_MISS_PREDICTION,"miss_prediction",Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_DECOD_BTB_IS_ACCURATE    ,"is_accurate"    ,Tcontrol_t         ,1);
      }

      {
        ALLOC1_INTERFACE("decod_ras",OUT,NORTH,"Interface with decod unit",_param->_nb_inst_branch_decod);
                                                                                      
        ALLOC1_VALACK_OUT(out_DECOD_RAS_VAL            ,VAL);
        ALLOC1_VALACK_IN ( in_DECOD_RAS_ACK            ,ACK);
        ALLOC1_SIGNAL_OUT(out_DECOD_RAS_CONTEXT_ID     ,"context_id"     ,Tcontext_t,_param->_size_context_id); 
        ALLOC1_SIGNAL_IN ( in_DECOD_RAS_HIT            ,"hit"            ,Tcontrol_t,1); 
        ALLOC1_SIGNAL_OUT(out_DECOD_RAS_PUSH           ,"push"           ,Tcontrol_t,1);
        ALLOC1_SIGNAL_OUT(out_DECOD_RAS_ADDRESS_PUSH   ,"address_push"   ,Taddress_t,_param->_size_instruction_address);
        ALLOC1_SIGNAL_IN ( in_DECOD_RAS_ADDRESS_POP    ,"address_pop"    ,Taddress_t,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_IN ( in_DECOD_RAS_INDEX          ,"index"          ,Tptr_t    ,_param->_size_ras_index);
        ALLOC1_SIGNAL_OUT(out_DECOD_RAS_MISS_PREDICTION,"miss_prediction",Tcontrol_t,1);
      }

      {
        ALLOC1_INTERFACE("decod_upt",OUT,NORTH,"Interface with decod unit",_param->_nb_inst_branch_decod);
                                                                                      
        ALLOC1_VALACK_OUT(out_DECOD_UPT_VAL                 ,VAL);
        ALLOC1_VALACK_IN ( in_DECOD_UPT_ACK                 ,ACK);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_CONTEXT_ID          ,"context_id"          ,Tcontext_t         ,_param->_size_context_id);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_BTB_ADDRESS_SRC     ,"btb_address_src"     ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_BTB_ADDRESS_DEST    ,"btb_address_dest"    ,Taddress_t         ,_param->_size_instruction_address);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_BTB_CONDITION       ,"btb_condition"       ,Tbranch_condition_t,_param->_size_branch_condition);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_BTB_LAST_TAKE       ,"btb_last_take"       ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_RAS_ADDRESS         ,"ras_address"         ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_OUT(out_DECOD_UPT_RAS_INDEX           ,"ras_index"           ,Tptr_t             ,_param->_size_ras_index);
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_MISS_IFETCH         ,"miss_ifetch"         ,Tcontrol_t         ,1); 
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_MISS_DECOD          ,"miss_decod"          ,Tcontrol_t         ,1); 
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_UPDATE_PREDICTION_ID,"update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth    );
        ALLOC1_SIGNAL_OUT(out_DECOD_UPT_IS_ACCURATE         ,"is_accurate"         ,Tcontrol_t         ,1); 
      }
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~           
    {
      {
        ALLOC1_INTERFACE("update_btb",OUT,SOUTH,"Interface with update unit",_param->_nb_inst_branch_update);

        ALLOC1_VALACK_OUT(out_UPDATE_BTB_VAL                  ,VAL);
        ALLOC1_VALACK_IN ( in_UPDATE_BTB_ACK                  ,ACK);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_CONTEXT_ID           ,"context_id"           ,Tcontext_t         ,_param->_size_context_id);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_ADDRESS_SRC          ,"address_src"          ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_ADDRESS_DEST         ,"address_dest"         ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_CONDITION            ,"condition"            ,Tbranch_condition_t,_param->_size_branch_condition);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_LAST_TAKE            ,"last_take"            ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_MISS_PREDICTION      ,"miss_prediction"      ,Tcontrol_t         ,1);
      }

      {
        ALLOC1_INTERFACE("update_dir",OUT,NORTH,"Interface with update unit",_param->_nb_inst_branch_update);

        ALLOC1_VALACK_OUT(out_UPDATE_DIR_VAL                  ,VAL);
        ALLOC1_VALACK_IN ( in_UPDATE_DIR_ACK                  ,ACK);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_DIR_ADDRESS              ,"address"              ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_DIR_HISTORY              ,"history"              ,Thistory_t         ,_param->_size_history);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_DIR_DIRECTION            ,"direction"            ,Tcontrol_t         ,1);
      }

      {
        ALLOC1_INTERFACE("update_ras",OUT,NORTH,"Interface with update unit",_param->_nb_inst_branch_update);

        ALLOC1_VALACK_OUT(out_UPDATE_RAS_VAL                  ,VAL);
        ALLOC1_VALACK_IN ( in_UPDATE_RAS_ACK                  ,ACK);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_CONTEXT_ID           ,"context_id"           ,Tcontext_t         ,_param->_size_context_id);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_PUSH                 ,"push"                 ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_ADDRESS              ,"address"              ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_INDEX                ,"index"                ,Tptr_t             ,_param->_size_ras_index);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_MISS_PREDICTION      ,"miss_prediction"      ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_PREDICTION_IFETCH    ,"prediction_ifetch"    ,Tcontrol_t         ,1);
      }

      {
        ALLOC1_INTERFACE("update_upt",IN ,NORTH,"Interface with update unit",_param->_nb_inst_branch_update);

        ALLOC1_VALACK_IN ( in_UPDATE_UPT_VAL                  ,VAL);
        ALLOC1_VALACK_OUT(out_UPDATE_UPT_ACK                  ,ACK);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_CONTEXT_ID           ,"context_id"           ,Tcontext_t         ,_param->_size_context_id);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_MISS_PREDICTION      ,"miss_prediction"      ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_DIRECTION_GOOD       ,"direction_good"       ,Tcontrol_t         ,1);
        ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_BTB_VAL              ,"btb_val"              ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_BTB_ADDRESS_SRC      ,"btb_address_src"      ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_BTB_ADDRESS_DEST     ,"btb_address_dest"     ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_BTB_CONDITION        ,"btb_condition"        ,Tbranch_condition_t,_param->_size_branch_condition);
        ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_DIR_VAL              ,"dir_val"              ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_DIR_HISTORY          ,"dir_history"          ,Thistory_t         ,_param->_size_history);
        ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_RAS_VAL              ,"ras_val"              ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_RAS_PUSH             ,"ras_push"             ,Tcontrol_t         ,1);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_RAS_ADDRESS          ,"ras_address"          ,Taddress_t         ,_param->_size_instruction_address);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_RAS_INDEX            ,"ras_index"            ,Tptr_t             ,_param->_size_ras_index);
//      ALLOC1_SIGNAL_IN ( in_UPDATE_UPT_RAS_PREDICTION_IFETCH,"ras_prediction_ifetch",Tcontrol_t         ,1);
      }
    }

//  // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~            
//  {
//    ALLOC1_INTERFACE("depth",IN,NORTH,"Interface with depth",_param->_nb_context);
//
//    ALLOC1_SIGNAL_IN ( in_DEPTH_UPT_NB_BRANCH,"upt_nb_branch",Tdepth_t,_param->_size_depth+1);
//    ALLOC1_SIGNAL_IN ( in_DEPTH_UPT_TAIL     ,"upt_tail"     ,Tdepth_t,_param->_size_depth);
//    ALLOC1_SIGNAL_OUT(out_DEPTH_NB_BRANCH    ,"nb_branch"    ,Tdepth_t,_param->_size_depth+1);
//    ALLOC1_SIGNAL_OUT(out_DEPTH_TAIL         ,"tail"         ,Tdepth_t,_param->_size_depth);
//  }

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
        _component->generate_file();
#endif

    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
