#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::allocation (void)
  {
    string rename;

    log_printf(FUNC,RegisterFile_Multi_Banked,"allocation","Begin");

//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");
//#endif
    in_NRESET = new SC_IN (Tcontrol_t) ("in_NRESET");

    // ----- Interface Read
     in_READ_VAL     = new SC_IN       (Tcontrol_t)     * [_param._nb_port_read];
    out_READ_ACK     = new SC_OUT      (Tcontrol_t)     * [_param._nb_port_read];
     in_READ_ADDRESS = new SC_IN       (Taddress_t)     * [_param._nb_port_read];
    out_READ_DATA    = new SC_OUT      (Tdata_t)        * [_param._nb_port_read];

    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	rename =  "in_READ_VAL_"    +toString(i);
	 in_READ_VAL     [i] = new SC_IN       (Tcontrol_t) (rename.c_str());

	rename = "out_READ_ACK_"    +toString(i);
	out_READ_ACK     [i] = new SC_OUT      (Tcontrol_t) (rename.c_str());

	rename =  "in_READ_ADDRESS_"+toString(i);
	 in_READ_ADDRESS [i] = new SC_IN       (Taddress_t) (rename.c_str());

	rename = "out_READ_DATA_"   +toString(i);
	out_READ_DATA    [i] = new SC_OUT      (Tdata_t)    (rename.c_str());
      }

    // ----- Interface Write
     in_WRITE_VAL     = new SC_IN       (Tcontrol_t)     * [_param._nb_port_write];
    out_WRITE_ACK     = new SC_OUT      (Tcontrol_t)     * [_param._nb_port_write];
     in_WRITE_ADDRESS = new SC_IN       (Taddress_t)     * [_param._nb_port_write];
     in_WRITE_DATA    = new SC_IN       (Tdata_t)        * [_param._nb_port_write];

    for (uint32_t i=0; i<_param._nb_port_write; i++)
      {
	rename =  "in_WRITE_VAL_"    +toString(i);
	 in_WRITE_VAL     [i] = new SC_IN       (Tcontrol_t) (rename.c_str());

	rename = "out_WRITE_ACK_"    +toString(i);
	out_WRITE_ACK     [i] = new SC_OUT      (Tcontrol_t) (rename.c_str());

	rename =  "in_WRITE_ADDRESS_"+toString(i);
	 in_WRITE_ADDRESS [i] = new SC_IN       (Taddress_t) (rename.c_str());

	rename =  "in_WRITE_DATA_"   +toString(i);
	 in_WRITE_DATA    [i] = new SC_IN       (Tdata_t)    (rename.c_str());
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    log_printf(FUNC,RegisterFile_Multi_Banked,"allocation","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
