/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile_Multi_Banked/RegisterFile_Multi_Banked_Glue/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - nb_port_read  (unsigned int)" << endl
       << " - nb_port_write (unsigned int)" << endl
       << " - size_address  (unsigned int)" << endl
       << " - size_word     (unsigned int)" << endl
       << " - nb_bank       (unsigned int)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  const string   name          = argv[1];
  const uint32_t nb_port_read  = atoi(argv[2]);
  const uint32_t nb_port_write = atoi(argv[3]);
  const uint32_t size_address  = atoi(argv[4]);
  const uint32_t size_word     = atoi(argv[5]);
  const uint32_t nb_bank       = atoi(argv[6]);

  try 
    {
      morpheo::behavioural::generic::registerfile_multi_banked::registerfile_multi_banked_glue::Parameters param (nb_port_read ,
														  nb_port_write,
														  size_address ,
														  size_word    ,
														  nb_bank      );
      
      cout << param.print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

