/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Pseudo_LRU/include/Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace pseudo_lru {

#ifdef SYSTEMC
  Pseudo_LRU::Pseudo_LRU (sc_module_name name,
#else
  Pseudo_LRU::Pseudo_LRU (string name,
#endif
#ifdef STATISTICS
			  morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			  morpheo::behavioural::generic::victim::pseudo_lru::Parameters param ):
			  _name   (name)
			  ,_param (param)
  {
    log_printf(FUNC,Pseudo_LRU,"Pseudo_LRU","Begin");

#ifdef STATISTICS
    log_printf(TRACE,Pseudo_LRU,"Pseudo_LRU","Allocation of statistics");
    
    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    // Creation of a testbench
    //  -> port
    //  -> clock's signals
    log_printf(TRACE,Pseudo_LRU,"Pseudo_LRU","Creation of Testbench");
    _vhdl_testbench = new Vhdl_Testbench (_name);
    vhdl_testbench_port           (*_vhdl_testbench);
    _vhdl_testbench->set_clock    ("in_CLOCK",true);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(TRACE,Pseudo_LRU,"Pseudo_LRU","Generation of VHDL");
    vhdl();
#endif

#ifdef SYSTEMC
    log_printf(TRACE,Pseudo_LRU,"Pseudo_LRU","Allocation");
    allocation ();

    log_printf(TRACE,Pseudo_LRU,"Pseudo_LRU","Definition of sc_method");
    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);

    SC_METHOD (genMealy_access);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    for (uint32_t i=0; i<_param._nb_access; i++)
      {
	sensitive << *(in_ACCESS_VAL     [i]);
	if (_param._size_table>1)
	  sensitive << *(in_ACCESS_ADDRESS [i]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    log_printf(TRACE,Pseudo_LRU,"Pseudo_LRU","List dependency information");
    // List dependency information
    for (uint32_t i=0; i<_param._nb_access; i++)
      {
	(*(out_ACCESS_ENTITY [i])) (*( in_ACCESS_VAL     [i]));
	if (_param._size_table>1)
	  (*(out_ACCESS_ENTITY [i])) (*( in_ACCESS_ADDRESS [i]));
      }
#endif    

    // Constant - ack is always at one
    for (uint32_t i=0; i<_param._nb_access; i++)
      PORT_WRITE (out_ACCESS_ACK [i], 1);
    for (uint32_t i=0; i<_param._nb_update; i++)
      PORT_WRITE (out_UPDATE_ACK [i], 1);

#endif
    log_printf(FUNC,Pseudo_LRU,"Pseudo_LRU","End");
  };
  
  Pseudo_LRU::~Pseudo_LRU (void)
  {
    log_printf(FUNC,Pseudo_LRU,"~Pseudo_LRU","Begin");
#ifdef SYSTEMC
    deallocation ();
#endif

#ifdef VHDL_TESTBENCH
    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif
    log_printf(FUNC,Pseudo_LRU,"~Pseudo_LRU","End");
  };

}; // end namespace pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
